/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.print;

import gnu.javax.print.CupsServer;
import gnu.javax.print.ipp.IppException;
import java.util.ArrayList;
import javax.print.DocFlavor;
import javax.print.MultiDocPrintService;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;

public class CupsPrintServiceLookup
extends PrintServiceLookup {
    private CupsServer server;

    public PrintService getDefaultPrintService() {
        try {
            return this.server.getDefaultPrinter();
        }
        catch (IppException ippException) {
            return null;
        }
    }

    public MultiDocPrintService[] getMultiDocPrintServices(DocFlavor[] docFlavorArray, AttributeSet attributeSet) {
        ArrayList arrayList = new ArrayList();
        PrintService[] printServiceArray = this.getPrintServices();
        int n = 0;
        while (n < printServiceArray.length) {
            if (this.checkMultiDocPrintService(docFlavorArray, attributeSet, printServiceArray[n])) {
                arrayList.add(printServiceArray[n]);
            }
            ++n;
        }
        return (MultiDocPrintService[])arrayList.toArray(new MultiDocPrintService[arrayList.size()]);
    }

    public PrintService[] getPrintServices() {
        ArrayList arrayList = new ArrayList();
        try {
            arrayList.addAll(this.server.getAllPrinters());
            arrayList.addAll(this.server.getAllClasses());
        }
        catch (IppException ippException) {}
        return (PrintService[])arrayList.toArray(new PrintService[arrayList.size()]);
    }

    public PrintService[] getPrintServices(DocFlavor docFlavor, AttributeSet attributeSet) {
        ArrayList arrayList = new ArrayList();
        PrintService[] printServiceArray = this.getPrintServices();
        int n = 0;
        while (n < printServiceArray.length) {
            if (this.checkPrintService(docFlavor, attributeSet, printServiceArray[n])) {
                arrayList.add(printServiceArray[n]);
            }
            ++n;
        }
        return (PrintService[])arrayList.toArray(new PrintService[arrayList.size()]);
    }

    public boolean checkPrintService(DocFlavor docFlavor, AttributeSet attributeSet, PrintService printService) {
        boolean bl = true;
        if (docFlavor == null || printService.isDocFlavorSupported(docFlavor)) {
            if (attributeSet == null || attributeSet.size() == 0) {
                return bl;
            }
            Attribute[] attributeArray = attributeSet.toArray();
            int n = 0;
            while (n < attributeArray.length) {
                if (!printService.isAttributeCategorySupported(attributeArray[n].getCategory())) {
                    bl = false;
                    break;
                }
                ++n;
            }
            return bl;
        }
        return false;
    }

    public boolean checkMultiDocPrintService(DocFlavor[] docFlavorArray, AttributeSet attributeSet, PrintService printService) {
        if (printService instanceof MultiDocPrintService) {
            boolean bl = true;
            boolean bl2 = true;
            if (docFlavorArray == null || docFlavorArray.length != 0) {
                bl = true;
            } else {
                int n = 0;
                while (n < docFlavorArray.length) {
                    if (!printService.isDocFlavorSupported(docFlavorArray[n])) {
                        bl = false;
                        break;
                    }
                    ++n;
                }
            }
            if (attributeSet == null || attributeSet.size() == 0) {
                bl2 = true;
            } else {
                Attribute[] attributeArray = attributeSet.toArray();
                int n = 0;
                while (n < attributeArray.length) {
                    if (!printService.isAttributeCategorySupported(attributeArray[n].getCategory())) {
                        bl2 = false;
                        break;
                    }
                    ++n;
                }
            }
            if (bl2 && bl) {
                return true;
            }
        }
        return false;
    }

    public CupsPrintServiceLookup() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        this.server = new CupsServer(null, null);
    }
}

