/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.stream;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

class CRLFReader
extends Reader {
    public static final int CR = 13;
    public static final int LF = 10;
    private boolean doReset;
    protected Reader in;

    public int read() throws IOException {
        int n = this.in.read();
        if (n == 13) {
            this.in.mark(1);
            int n2 = this.in.read();
            if (n2 == 10) {
                n = n2;
            } else {
                this.in.reset();
            }
        }
        return n;
    }

    public int read(char[] cArray) throws IOException {
        return this.read(cArray, 0, cArray.length);
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        this.in.mark(n2 + 1);
        int n3 = this.in.read(cArray, n, n2);
        if (n3 > 0) {
            int n4 = this.indexOfCRLF(cArray, n, n3);
            if (this.doReset) {
                this.in.reset();
                if (n4 != -1) {
                    n3 = this.in.read(cArray, n, n4 + 1 - n);
                    this.in.read();
                    cArray[n4] = 10;
                } else {
                    n3 = this.in.read(cArray, n, n2);
                }
            }
        }
        return n3;
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public void mark(int n) throws IOException {
        this.in.mark(n);
    }

    public void reset() throws IOException {
        this.in.reset();
    }

    public long skip(long l) throws IOException {
        return this.in.skip(l);
    }

    public void close() throws IOException {
        this.in.close();
    }

    private final int indexOfCRLF(char[] cArray, int n, int n2) throws IOException {
        this.doReset = false;
        int n3 = n + n2;
        int n4 = n3 - 1;
        int n5 = n;
        while (n5 < n3) {
            if (cArray[n5] == '\r') {
                int n6;
                if (n5 == n4) {
                    n6 = this.in.read();
                    this.doReset = true;
                } else {
                    n6 = cArray[n5 + 1];
                }
                if (n6 == 10) {
                    this.doReset = true;
                    return n5;
                }
            }
            ++n5;
        }
        return -1;
    }

    protected CRLFReader(Reader reader) {
        if (!reader.markSupported()) {
            reader = new BufferedReader(reader);
        }
        this.in = reader;
    }
}

