/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import java.math.BigInteger;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class NegativeIntegerType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{11, 12, 4, 6, 5, 7, 8, 10, 9};

    public final int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    public final void checkValue(String string, ValidationContext validationContext) throws DatatypeException {
        super.checkValid(string, validationContext);
        int n = string.length();
        if (n == 0) {
            throw new DatatypeException(0, "invalid negative integer value");
        }
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (!(c == '-' ? n2 == 0 : c >= '0' && c <= '9')) {
                throw new DatatypeException(n2, "invalid negative integer value");
            }
            ++n2;
        }
    }

    public final Object createValue(String string, ValidationContext validationContext) {
        try {
            return new BigInteger(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    NegativeIntegerType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "negativeInteger"), TypeLibrary.NON_POSITIVE_INTEGER);
    }
}

