/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.xpath;

import gnu.xml.xpath.Expr;
import gnu.xml.xpath.NameTest;
import gnu.xml.xpath.NamespaceTest;
import gnu.xml.xpath.NodeTypeTest;
import gnu.xml.xpath.Path;
import gnu.xml.xpath.Test;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.xml.namespace.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class Selector
extends Path {
    public static final int ANCESTOR = 0;
    public static final int ANCESTOR_OR_SELF = 1;
    public static final int ATTRIBUTE = 2;
    public static final int CHILD = 3;
    public static final int DESCENDANT = 4;
    public static final int DESCENDANT_OR_SELF = 5;
    public static final int FOLLOWING = 6;
    public static final int FOLLOWING_SIBLING = 7;
    public static final int NAMESPACE = 8;
    public static final int PARENT = 9;
    public static final int PRECEDING = 10;
    public static final int PRECEDING_SIBLING = 11;
    public static final int SELF = 12;
    final int axis;
    final Test[] tests;

    public final Test[] getTests() {
        return this.tests;
    }

    public final boolean matches(Node node2) {
        return this.matches(node2, this.getContextPosition(node2), this.getContextSize(node2));
    }

    final boolean matches(Node node2, int n, int n2) {
        short s = node2.getNodeType();
        switch (this.axis) {
            case 3: {
                if (s != 2) break;
                return false;
            }
            case 2: 
            case 8: {
                if (s == 2) break;
                return false;
            }
            case 5: {
                return true;
            }
            default: {
                return false;
            }
        }
        int n3 = 0;
        while (n3 < this.tests.length && n2 > 0) {
            Test test = this.tests[n3];
            if (!test.matches(node2, n, n2)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    private final int getContextPosition(Node node2) {
        int n = 1;
        node2 = node2.getPreviousSibling();
        while (node2 != null) {
            if (this.tests[0].matches(node2, 1, 1)) {
                ++n;
            }
            node2 = node2.getPreviousSibling();
        }
        return n;
    }

    private final int getContextSize(Node node2) {
        if (node2.getNodeType() == 2) {
            Element element = ((Attr)node2).getOwnerElement();
            return element.getAttributes().getLength();
        }
        int n = 1;
        Node node3 = node2.getPreviousSibling();
        while (node3 != null) {
            if (this.tests[0].matches(node2, 1, 1)) {
                ++n;
            }
            node3 = node3.getPreviousSibling();
        }
        node3 = node2.getNextSibling();
        while (node3 != null) {
            if (this.tests[0].matches(node2, 1, 1)) {
                ++n;
            }
            node3 = node3.getNextSibling();
        }
        return n;
    }

    public final Object evaluate(Node node2, int n, int n2) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        this.addCandidates(node2, linkedHashSet);
        ArrayList arrayList = new ArrayList(linkedHashSet);
        List list2 = this.filterCandidates(arrayList, false);
        return list2;
    }

    final Collection evaluate(Node node2, Collection collection) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        Object object = collection.iterator();
        while (object.hasNext()) {
            this.addCandidates((Node)object.next(), linkedHashSet);
        }
        object = new ArrayList(linkedHashSet);
        List list2 = this.filterCandidates((List)object, true);
        return list2;
    }

    final List filterCandidates(List list2, boolean bl) {
        int n = list2.size();
        int n2 = this.tests.length;
        if (n2 > 0 && n > 0) {
            int n3 = 0;
            while (n3 < n2 && n > 0) {
                Test test = this.tests[n3];
                ArrayList arrayList = new ArrayList(n);
                int n4 = 0;
                while (n4 < n) {
                    short s;
                    Node node2 = (Node)list2.get(n4);
                    if (bl && ((s = node2.getNodeType()) == 9 || s == 11) && (this.axis == 5 || this.axis == 1 || this.axis == 12) && this.tests.length == 1 && this.tests[0] instanceof NodeTypeTest && ((NodeTypeTest)this.tests[0]).type == 0) {
                        arrayList.add(node2);
                    } else if (test.matches(node2, n4 + 1, n)) {
                        arrayList.add(node2);
                    }
                    ++n4;
                }
                list2 = arrayList;
                n = list2.size();
                ++n3;
            }
        }
        return list2;
    }

    final void addCandidates(Node node2, Collection collection) {
        switch (this.axis) {
            case 3: {
                this.addChildNodes(node2, collection, false);
                break;
            }
            case 4: {
                this.addChildNodes(node2, collection, true);
                break;
            }
            case 5: {
                collection.add(node2);
                this.addChildNodes(node2, collection, true);
                break;
            }
            case 9: {
                this.addParentNode(node2, collection, false);
                break;
            }
            case 0: {
                this.addParentNode(node2, collection, true);
                break;
            }
            case 1: {
                collection.add(node2);
                this.addParentNode(node2, collection, true);
                break;
            }
            case 7: {
                this.addFollowingNodes(node2, collection, false);
                break;
            }
            case 11: {
                this.addPrecedingNodes(node2, collection, false);
                break;
            }
            case 6: {
                this.addFollowingNodes(node2, collection, true);
                break;
            }
            case 10: {
                this.addPrecedingNodes(node2, collection, true);
                break;
            }
            case 2: {
                this.addAttributes(node2, collection);
                break;
            }
            case 8: {
                this.addNamespaceAttributes(node2, collection);
                break;
            }
            case 12: {
                collection.add(node2);
                break;
            }
        }
    }

    final void addChildNodes(Node node2, Collection collection, boolean bl) {
        Node node3 = node2.getFirstChild();
        while (node3 != null) {
            collection.add(node3);
            if (bl) {
                this.addChildNodes(node3, collection, bl);
            }
            node3 = node3.getNextSibling();
        }
    }

    final void addParentNode(Node node2, Collection collection, boolean bl) {
        Node node3;
        Node node4 = node3 = node2.getNodeType() == 2 ? ((Attr)node2).getOwnerElement() : node2.getParentNode();
        if (node3 != null) {
            collection.add(node3);
            if (bl) {
                this.addParentNode(node3, collection, bl);
            }
        }
    }

    final void addFollowingNodes(Node node2, Collection collection, boolean bl) {
        if (node2 != null && bl) {
            this.addChildNodes(node2, collection, true);
        }
        Node node3 = node2.getNodeType() == 2 ? null : node2.getNextSibling();
        while (node3 != null) {
            collection.add(node3);
            if (bl) {
                this.addChildNodes(node3, collection, true);
            }
            node3 = node3.getNextSibling();
        }
        if (bl) {
            while (node2 != null) {
                Node node4 = node2 = node2.getNodeType() == 2 ? ((Attr)node2).getOwnerElement() : node2.getParentNode();
                if (node2 == null) continue;
                node3 = node2.getNextSibling();
                while (node3 != null) {
                    collection.add(node3);
                    if (bl) {
                        this.addChildNodes(node3, collection, true);
                    }
                    node3 = node3.getNextSibling();
                }
            }
        }
    }

    final void addPrecedingNodes(Node node2, Collection collection, boolean bl) {
        Node node3 = node2.getNodeType() == 2 ? null : node2.getPreviousSibling();
        while (node3 != null) {
            collection.add(node3);
            if (bl) {
                this.addChildNodes(node3, collection, true);
            }
            node3 = node3.getPreviousSibling();
        }
        if (bl) {
            node3 = node2;
            Node node4 = node3 = node3.getNodeType() == 2 ? ((Attr)node3).getOwnerElement() : node3.getParentNode();
            if (node3 != null) {
                this.addPrecedingNodes(node3, collection, bl);
            }
        }
    }

    final void addAttributes(Node node2, Collection collection) {
        NamedNodeMap namedNodeMap = node2.getAttributes();
        if (namedNodeMap != null) {
            int n = namedNodeMap.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node3 = namedNodeMap.item(n2);
                if (!this.isNamespaceAttribute(node3)) {
                    collection.add(node3);
                }
                ++n2;
            }
        }
    }

    final void addNamespaceAttributes(Node node2, Collection collection) {
        NamedNodeMap namedNodeMap = node2.getAttributes();
        if (namedNodeMap != null) {
            int n = namedNodeMap.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node3 = namedNodeMap.item(n2);
                if (this.isNamespaceAttribute(node3)) {
                    collection.add(node3);
                }
                ++n2;
            }
        }
    }

    final boolean isNamespaceAttribute(Node node2) {
        String string = node2.getNamespaceURI();
        boolean bl = false;
        if ("http://www.w3.org/2000/xmlns/".equals(string) || "xmlns".equals(node2.getPrefix()) || "xmlns".equals(node2.getNodeName())) {
            bl = true;
        }
        return bl;
    }

    public final Expr clone(Object object) {
        int n = this.tests.length;
        ArrayList arrayList = new ArrayList(n);
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(this.tests[n2].clone(object));
            ++n2;
        }
        return new Selector(this.axis, arrayList);
    }

    public final boolean references(QName qName) {
        int n = 0;
        while (n < this.tests.length) {
            if (this.tests[n].references(qName)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.axis) {
            case 0: {
                stringBuffer.append("ancestor::");
                break;
            }
            case 1: {
                stringBuffer.append("ancestor-or-self::");
                break;
            }
            case 2: {
                if (this.tests.length == 0 || this.tests[0] instanceof NameTest) {
                    stringBuffer.append('@');
                    break;
                }
                stringBuffer.append("attribute::");
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                stringBuffer.append("descendant::");
                break;
            }
            case 5: {
                stringBuffer.append("descendant-or-self::");
                break;
            }
            case 6: {
                stringBuffer.append("following::");
                break;
            }
            case 7: {
                stringBuffer.append("following-sibling::");
                break;
            }
            case 8: {
                stringBuffer.append("namespace::");
                break;
            }
            case 9: {
                if (this.tests.length == 0 || this.tests[0] instanceof NodeTypeTest && ((NodeTypeTest)this.tests[0]).type == 0) {
                    return "..";
                }
                stringBuffer.append("parent::");
                break;
            }
            case 10: {
                stringBuffer.append("preceding::");
                break;
            }
            case 11: {
                stringBuffer.append("preceding-sibling::");
                break;
            }
            case 12: {
                if (this.tests.length == 0 || this.tests[0] instanceof NodeTypeTest && ((NodeTypeTest)this.tests[0]).type == 0) {
                    return ".";
                }
                stringBuffer.append("self::");
                break;
            }
        }
        if (this.tests.length == 0) {
            stringBuffer.append("[error]");
        } else {
            int n = 0;
            while (n < this.tests.length) {
                stringBuffer.append(this.tests[n]);
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public Selector(int n, List list2) {
        this.axis = n;
        int n2 = list2.size();
        int n3 = 1;
        if (n2 != 0) {
            n3 = n2;
        }
        this.tests = new Test[n3];
        if (n2 > 0) {
            list2.toArray(this.tests);
        } else {
            this.tests[0] = new NodeTypeTest(0);
        }
        if (n == 8 && this.tests[0] instanceof NameTest) {
            NameTest nameTest = (NameTest)this.tests[0];
            this.tests[0] = new NamespaceTest(nameTest.qName, nameTest.anyLocalName, nameTest.any);
        }
    }
}

