/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayoutInfo;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;

public class GridBagLayout
implements Serializable,
LayoutManager2 {
    private static final long serialVersionUID = 8838754796412211005L;
    protected static final int MINSIZE = 1;
    protected static final int PREFERREDSIZE = 2;
    protected static final int MAXGRIDSIZE = 512;
    protected Hashtable comptable = new Hashtable();
    private Hashtable internalcomptable = new Hashtable();
    protected GridBagLayoutInfo layoutInfo;
    protected GridBagConstraints defaultConstraints = new GridBagConstraints();
    public double[] columnWeights;
    public int[] columnWidths;
    public double[] rowWeights;
    public int[] rowHeights;

    private final int sumIntArray(int[] nArray, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 += nArray[n3];
            ++n3;
        }
        return n2;
    }

    private final int sumIntArray(int[] nArray) {
        return this.sumIntArray(nArray, nArray.length);
    }

    private final double sumDoubleArray(double[] dArray) {
        double d = 0.0;
        int n = 0;
        while (n < dArray.length) {
            d += dArray[n];
            ++n;
        }
        return d;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object == null) {
            return;
        }
        if (!(object instanceof GridBagConstraints)) {
            throw new IllegalArgumentException("constraints " + object + " are not an instance of GridBagConstraints");
        }
        this.setConstraints(component, (GridBagConstraints)object);
    }

    public Dimension preferredLayoutSize(Container container) {
        if (container == null) {
            return new Dimension(0, 0);
        }
        GridBagLayoutInfo gridBagLayoutInfo = this.getLayoutInfo(container, 2);
        return this.getMinSize(container, gridBagLayoutInfo);
    }

    public Dimension minimumLayoutSize(Container container) {
        if (container == null) {
            return new Dimension(0, 0);
        }
        GridBagLayoutInfo gridBagLayoutInfo = this.getLayoutInfo(container, 1);
        return this.getMinSize(container, gridBagLayoutInfo);
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void layoutContainer(Container container) {
        this.arrangeGrid(container);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
        this.layoutInfo = null;
    }

    public void setConstraints(Component component, GridBagConstraints gridBagConstraints) {
        GridBagConstraints gridBagConstraints2 = (GridBagConstraints)gridBagConstraints.clone();
        if (gridBagConstraints2.gridx < 0) {
            gridBagConstraints2.gridx = -1;
        }
        if (gridBagConstraints2.gridy < 0) {
            gridBagConstraints2.gridy = -1;
        }
        if (gridBagConstraints2.gridwidth == 0) {
            gridBagConstraints2.gridwidth = 0;
        } else if (gridBagConstraints2.gridwidth < 0) {
            gridBagConstraints2.gridwidth = 1;
        }
        if (gridBagConstraints2.gridheight == 0) {
            gridBagConstraints2.gridheight = 0;
        } else if (gridBagConstraints2.gridheight < 0) {
            gridBagConstraints2.gridheight = 1;
        }
        this.comptable.put(component, gridBagConstraints2);
    }

    public GridBagConstraints getConstraints(Component component) {
        return (GridBagConstraints)this.lookupConstraints(component).clone();
    }

    protected GridBagConstraints lookupConstraints(Component component) {
        GridBagConstraints gridBagConstraints = (GridBagConstraints)this.comptable.get(component);
        if (gridBagConstraints == null) {
            this.setConstraints(component, this.defaultConstraints);
            gridBagConstraints = (GridBagConstraints)this.comptable.get(component);
        }
        return gridBagConstraints;
    }

    private final GridBagConstraints lookupInternalConstraints(Component component) {
        GridBagConstraints gridBagConstraints = (GridBagConstraints)this.internalcomptable.get(component);
        if (gridBagConstraints == null) {
            gridBagConstraints = (GridBagConstraints)this.lookupConstraints(component).clone();
            this.internalcomptable.put(component, gridBagConstraints);
        }
        return gridBagConstraints;
    }

    public Point getLayoutOrigin() {
        if (this.layoutInfo == null) {
            return new Point(0, 0);
        }
        return new Point(this.layoutInfo.pos_x, this.layoutInfo.pos_y);
    }

    public int[][] getLayoutDimensions() {
        int[][] nArrayArray = new int[2][];
        if (this.layoutInfo == null) {
            nArrayArray[0] = new int[0];
            nArrayArray[1] = new int[0];
            return nArrayArray;
        }
        nArrayArray[0] = new int[this.layoutInfo.cols];
        System.arraycopy(this.layoutInfo.colWidths, 0, nArrayArray[0], 0, this.layoutInfo.cols);
        nArrayArray[1] = new int[this.layoutInfo.rows];
        System.arraycopy(this.layoutInfo.rowHeights, 0, nArrayArray[1], 0, this.layoutInfo.rows);
        return nArrayArray;
    }

    public double[][] getLayoutWeights() {
        double[][] dArrayArray = new double[2][];
        if (this.layoutInfo == null) {
            dArrayArray[0] = new double[0];
            dArrayArray[1] = new double[0];
            return dArrayArray;
        }
        dArrayArray[0] = new double[this.layoutInfo.cols];
        System.arraycopy(this.layoutInfo.colWeights, 0, dArrayArray[0], 0, this.layoutInfo.cols);
        dArrayArray[1] = new double[this.layoutInfo.rows];
        System.arraycopy(this.layoutInfo.rowWeights, 0, dArrayArray[1], 0, this.layoutInfo.rows);
        return dArrayArray;
    }

    public Point location(int n, int n2) {
        int n3;
        if (this.layoutInfo == null) {
            return new Point(0, 0);
        }
        int n4 = this.layoutInfo.pos_x;
        int n5 = this.layoutInfo.pos_y;
        int n6 = 0;
        while (n6 < this.layoutInfo.cols) {
            n3 = this.layoutInfo.colWidths[n6];
            if (n < n4 + n3) break;
            n4 += n3;
            ++n6;
        }
        int n7 = 0;
        while (n7 < this.layoutInfo.rows) {
            n3 = this.layoutInfo.rowHeights[n7];
            if (n2 < n5 + n3) break;
            n5 += n3;
            ++n7;
        }
        return new Point(n6, n7);
    }

    protected void AdjustForGravity(GridBagConstraints gridBagConstraints, Rectangle rectangle) {
        throw new Error("Not implemented");
    }

    protected void ArrangeGrid(Container container) {
        Component[] componentArray = container.getComponents();
        if (componentArray.length == 0) {
            return;
        }
        GridBagLayoutInfo gridBagLayoutInfo = this.getLayoutInfo(container, 2);
        if (gridBagLayoutInfo.cols == 0 && gridBagLayoutInfo.rows == 0) {
            return;
        }
        Component component = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < componentArray.length) {
            Component component2 = componentArray[n5];
            if (component2.isVisible()) {
                Dimension dimension = component2.getPreferredSize();
                GridBagConstraints gridBagConstraints = this.lookupInternalConstraints(component2);
                n2 = component != null && gridBagConstraints.gridheight == 0 ? (n2 += n4) : this.sumIntArray(gridBagLayoutInfo.rowHeights, gridBagConstraints.gridy);
                n = component != null && gridBagConstraints.gridwidth == 0 ? (n += n3) : this.sumIntArray(gridBagLayoutInfo.colWidths, gridBagConstraints.gridx);
                n3 = this.sumIntArray(gridBagLayoutInfo.colWidths, gridBagConstraints.gridx + gridBagConstraints.gridwidth) - n;
                n4 = this.sumIntArray(gridBagLayoutInfo.rowHeights, gridBagConstraints.gridy + gridBagConstraints.gridheight) - n2;
                Insets insets = gridBagConstraints.insets;
                if (insets != null) {
                    n += insets.left;
                    n2 += insets.top;
                    n3 -= insets.left + insets.right;
                    n4 -= insets.top + insets.bottom;
                }
                dimension.width += gridBagConstraints.ipadx;
                dimension.height += gridBagConstraints.ipady;
                switch (gridBagConstraints.fill) {
                    case 2: {
                        dimension.width = n3;
                        break;
                    }
                    case 3: {
                        dimension.height = n4;
                        break;
                    }
                    case 1: {
                        dimension.width = n3;
                        dimension.height = n4;
                        break;
                    }
                }
                int n6 = 0;
                int n7 = 0;
                switch (gridBagConstraints.anchor) {
                    case 11: {
                        n6 = n + (n3 - dimension.width) / 2;
                        n7 = n2;
                        break;
                    }
                    case 15: {
                        n6 = n + (n3 - dimension.width) / 2;
                        n7 = n2 + n4 - dimension.height;
                        break;
                    }
                    case 17: {
                        n6 = n;
                        n7 = n2 + (n4 - dimension.height) / 2;
                        break;
                    }
                    case 13: {
                        n6 = n + n3 - dimension.width;
                        n7 = n2 + (n4 - dimension.height) / 2;
                        break;
                    }
                    case 12: {
                        n6 = n + n3 - dimension.width;
                        n7 = n2;
                        break;
                    }
                    case 18: {
                        n6 = n;
                        n7 = n2;
                        break;
                    }
                    case 14: {
                        n6 = n + n3 - dimension.width;
                        n7 = n2 + n4 - dimension.height;
                        break;
                    }
                    case 16: {
                        n6 = n;
                        n7 = n2 + n4 - dimension.height;
                        break;
                    }
                    default: {
                        n6 = n + (n3 - dimension.width) / 2;
                        n7 = n2 + (n4 - dimension.height) / 2;
                    }
                }
                component2.setBounds(gridBagLayoutInfo.pos_x + n6, gridBagLayoutInfo.pos_y + n7, dimension.width, dimension.height);
                component = component2;
            }
            ++n5;
        }
        this.layoutInfo = this.getLayoutInfo(container, 2);
    }

    protected GridBagLayoutInfo GetLayoutInfo(Container container, int n) {
        Serializable serializable;
        int n2;
        GridBagConstraints gridBagConstraints;
        Serializable serializable2;
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException();
        }
        Dimension dimension = container.getSize();
        Insets insets = container.getInsets();
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        Component[] componentArray = container.getComponents();
        ArrayList arrayList = new ArrayList(componentArray.length);
        ArrayList arrayList2 = new ArrayList(componentArray.length);
        int n6 = 0;
        while (n6 < componentArray.length) {
            Component component = componentArray[n6];
            if (component.isVisible()) {
                GridBagConstraints gridBagConstraints2;
                serializable2 = this.lookupConstraints(component);
                gridBagConstraints = (GridBagConstraints)((GridBagConstraints)serializable2).clone();
                this.internalcomptable.put(component, gridBagConstraints);
                if (gridBagConstraints.gridx == -1) {
                    if (gridBagConstraints.gridy == -1) {
                        gridBagConstraints.gridy = n3;
                    }
                    if (!hashMap.containsKey(new Integer(gridBagConstraints.gridy))) {
                        n2 = 0;
                    } else {
                        Component component2 = (Component)hashMap.get(new Integer(gridBagConstraints.gridy));
                        serializable = this.lookupInternalConstraints(component2);
                        n2 = serializable.gridx + Math.max(1, serializable.gridwidth);
                    }
                    int n7 = gridBagConstraints.gridy + 1;
                    while (n7 < gridBagConstraints.gridy + Math.max(1, gridBagConstraints.gridheight)) {
                        if (hashMap.containsKey(new Integer(n7))) {
                            serializable = (Component)hashMap.get(new Integer(n7));
                            gridBagConstraints2 = this.lookupInternalConstraints((Component)serializable);
                            n2 = Math.max(n2, gridBagConstraints2.gridx + Math.max(1, gridBagConstraints2.gridwidth));
                        }
                        ++n7;
                    }
                    gridBagConstraints.gridx = n2;
                } else if (gridBagConstraints.gridy == -1) {
                    if (!hashMap2.containsKey(new Integer(gridBagConstraints.gridx))) {
                        n2 = n3;
                    } else {
                        Component component3 = (Component)hashMap2.get(new Integer(gridBagConstraints.gridx));
                        serializable = this.lookupInternalConstraints(component3);
                        n2 = serializable.gridy + Math.max(1, serializable.gridheight);
                    }
                    int n8 = gridBagConstraints.gridx + 1;
                    while (n8 < gridBagConstraints.gridx + Math.max(1, gridBagConstraints.gridwidth)) {
                        if (hashMap2.containsKey(new Integer(n8))) {
                            serializable = (Component)hashMap2.get(new Integer(n8));
                            gridBagConstraints2 = this.lookupInternalConstraints((Component)serializable);
                            n2 = Math.max(n2, gridBagConstraints2.gridy + Math.max(1, gridBagConstraints2.gridheight));
                        }
                        ++n8;
                    }
                    gridBagConstraints.gridy = n2;
                }
                n4 = Math.max(n4, gridBagConstraints.gridx + Math.max(1, gridBagConstraints.gridwidth));
                n5 = Math.max(n5, gridBagConstraints.gridy + Math.max(1, gridBagConstraints.gridheight));
                this.sortBySpan(component, gridBagConstraints.gridwidth, arrayList, true);
                this.sortBySpan(component, gridBagConstraints.gridheight, arrayList2, false);
                if (gridBagConstraints.gridwidth == 0) {
                    n3 = gridBagConstraints.gridy + Math.max(1, gridBagConstraints.gridheight);
                } else if (gridBagConstraints.gridwidth != 0) {
                    n2 = gridBagConstraints.gridy;
                    while (n2 < gridBagConstraints.gridy + Math.max(1, gridBagConstraints.gridheight)) {
                        if (hashMap.containsKey(new Integer(n2))) {
                            Component component4 = (Component)hashMap.get(new Integer(n2));
                            serializable = this.lookupInternalConstraints(component4);
                            if (gridBagConstraints.gridx > serializable.gridx) {
                                hashMap.put(new Integer(n2), component);
                            }
                        } else {
                            hashMap.put(new Integer(n2), component);
                        }
                        ++n2;
                    }
                    n2 = gridBagConstraints.gridx;
                    while (n2 < gridBagConstraints.gridx + Math.max(1, gridBagConstraints.gridwidth)) {
                        if (hashMap2.containsKey(new Integer(n2))) {
                            Component component5 = (Component)hashMap2.get(new Integer(n2));
                            serializable = this.lookupInternalConstraints(component5);
                            if (gridBagConstraints.gridy > serializable.gridy) {
                                hashMap2.put(new Integer(n2), component);
                            }
                        } else {
                            hashMap2.put(new Integer(n2), component);
                        }
                        ++n2;
                    }
                }
            }
            ++n6;
        }
        GridBagLayoutInfo gridBagLayoutInfo = new GridBagLayoutInfo(n4, n5);
        int n9 = 0;
        while (n9 < n4) {
            if (this.columnWidths != null && this.columnWidths.length > n9) {
                gridBagLayoutInfo.colWidths[n9] = this.columnWidths[n9];
            }
            if (this.columnWeights != null && this.columnWeights.length > n9) {
                gridBagLayoutInfo.colWeights[n9] = this.columnWeights[n9];
            }
            ++n9;
        }
        n9 = 0;
        while (n9 < n5) {
            if (this.rowHeights != null && this.rowHeights.length > n9) {
                gridBagLayoutInfo.rowHeights[n9] = this.rowHeights[n9];
            }
            if (this.rowWeights != null && this.rowWeights.length > n9) {
                gridBagLayoutInfo.rowWeights[n9] = this.rowWeights[n9];
            }
            ++n9;
        }
        n9 = 0;
        while (n9 < componentArray.length) {
            serializable2 = componentArray[n9];
            if (((Component)serializable2).isVisible()) {
                gridBagConstraints = this.lookupInternalConstraints((Component)serializable2);
                if (gridBagConstraints.gridwidth == 0 || gridBagConstraints.gridwidth == -1) {
                    if (gridBagConstraints.gridwidth == 0) {
                        n2 = gridBagConstraints.gridy;
                        while (n2 < gridBagConstraints.gridy + Math.max(1, gridBagConstraints.gridheight)) {
                            if (hashMap.containsKey(new Integer(n2))) {
                                Component component = (Component)hashMap.get(new Integer(n2));
                                serializable = this.lookupInternalConstraints(component);
                                if (serializable.gridwidth == -1) {
                                    gridBagConstraints.gridx = n4 - 1;
                                    break;
                                }
                                gridBagConstraints.gridx = Math.max(gridBagConstraints.gridx, serializable.gridx + Math.max(1, serializable.gridwidth));
                            }
                            ++n2;
                        }
                        gridBagConstraints.gridwidth = n4 - gridBagConstraints.gridx;
                    } else if (gridBagConstraints.gridwidth == -1) {
                        gridBagConstraints.gridwidth = n4 - gridBagConstraints.gridx - 1;
                    }
                    arrayList.remove(arrayList.indexOf(serializable2));
                    this.sortBySpan((Component)serializable2, gridBagConstraints.gridwidth, arrayList, true);
                }
                if (gridBagConstraints.gridheight == 0 || gridBagConstraints.gridheight == -1) {
                    if (gridBagConstraints.gridheight == 0) {
                        n2 = gridBagConstraints.gridx;
                        while (n2 < gridBagConstraints.gridx + Math.max(1, gridBagConstraints.gridwidth)) {
                            Component component;
                            if (hashMap2.containsKey(new Integer(n2)) && (component = (Component)hashMap.get(new Integer(n2))) != null) {
                                serializable = this.lookupInternalConstraints(component);
                                if (serializable.gridheight == -1) {
                                    gridBagConstraints.gridy = n5 - 1;
                                    break;
                                }
                                gridBagConstraints.gridy = Math.max(gridBagConstraints.gridy, serializable.gridy + Math.max(1, serializable.gridheight));
                            }
                            ++n2;
                        }
                        gridBagConstraints.gridheight = n5 - gridBagConstraints.gridy;
                    } else if (gridBagConstraints.gridheight == -1) {
                        gridBagConstraints.gridheight = n5 - gridBagConstraints.gridy - 1;
                    }
                    arrayList2.remove(arrayList2.indexOf(serializable2));
                    this.sortBySpan((Component)serializable2, gridBagConstraints.gridheight, arrayList2, false);
                }
            }
            ++n9;
        }
        n9 = 0;
        while (n9 < arrayList.size()) {
            serializable2 = (Component)arrayList.get(n9);
            if (((Component)serializable2).isVisible()) {
                gridBagConstraints = this.lookupInternalConstraints((Component)serializable2);
                int n10 = n2 = n == 2 ? ((Component)serializable2).getPreferredSize().width : ((Component)serializable2).getMinimumSize().width;
                if (gridBagConstraints.insets != null) {
                    n2 += gridBagConstraints.insets.left + gridBagConstraints.insets.right;
                }
                this.distributeSizeAndWeight(n2 += gridBagConstraints.ipadx, gridBagConstraints.weightx, gridBagConstraints.gridx, gridBagConstraints.gridwidth, gridBagLayoutInfo.colWidths, gridBagLayoutInfo.colWeights);
            }
            ++n9;
        }
        n9 = 0;
        while (n9 < arrayList2.size()) {
            serializable2 = (Component)arrayList2.get(n9);
            if (((Component)serializable2).isVisible()) {
                gridBagConstraints = this.lookupInternalConstraints((Component)serializable2);
                int n11 = n2 = n == 2 ? ((Component)serializable2).getPreferredSize().height : ((Component)serializable2).getMinimumSize().height;
                if (gridBagConstraints.insets != null) {
                    n2 += gridBagConstraints.insets.top + gridBagConstraints.insets.bottom;
                }
                this.distributeSizeAndWeight(n2 += gridBagConstraints.ipady, gridBagConstraints.weighty, gridBagConstraints.gridy, gridBagConstraints.gridheight, gridBagLayoutInfo.rowHeights, gridBagLayoutInfo.rowWeights);
            }
            ++n9;
        }
        if (dimension.width > 0 && dimension.height > 0) {
            this.calcCellSizes(gridBagLayoutInfo.colWidths, gridBagLayoutInfo.colWeights, dimension.width);
            this.calcCellSizes(gridBagLayoutInfo.rowHeights, gridBagLayoutInfo.rowWeights, dimension.height);
        }
        n9 = this.sumIntArray(gridBagLayoutInfo.colWidths);
        int n12 = this.sumIntArray(gridBagLayoutInfo.rowHeights);
        gridBagLayoutInfo.pos_x = n9 >= dimension.width ? insets.left : insets.left + (dimension.width - n9) / 2;
        gridBagLayoutInfo.pos_y = n12 >= dimension.height ? insets.top : insets.top + (dimension.height - n12) / 2;
        return gridBagLayoutInfo;
    }

    protected Dimension GetMinSize(Container container, GridBagLayoutInfo gridBagLayoutInfo) {
        if (container == null || gridBagLayoutInfo == null) {
            return new Dimension(0, 0);
        }
        Insets insets = container.getInsets();
        int n = this.sumIntArray(gridBagLayoutInfo.colWidths) + insets.left + insets.right;
        int n2 = this.sumIntArray(gridBagLayoutInfo.rowHeights) + insets.top + insets.bottom;
        return new Dimension(n, n2);
    }

    protected Dimension getMinSize(Container container, GridBagLayoutInfo gridBagLayoutInfo) {
        return this.GetMinSize(container, gridBagLayoutInfo);
    }

    private final void sortBySpan(Component component, int n, ArrayList arrayList, boolean bl) {
        if (n == 0 || n == -1) {
            arrayList.add(component);
        } else {
            int n2 = 0;
            if (arrayList.size() > 0) {
                GridBagConstraints gridBagConstraints = this.lookupInternalConstraints((Component)arrayList.get(n2));
                int n3 = bl ? gridBagConstraints.gridwidth : gridBagConstraints.gridheight;
                while (n3 != 0 && n3 != -1 && n >= n3) {
                    if (++n2 >= arrayList.size()) break;
                    gridBagConstraints = this.lookupInternalConstraints((Component)arrayList.get(n2));
                    n3 = bl ? gridBagConstraints.gridwidth : gridBagConstraints.gridheight;
                }
            }
            arrayList.add(n2, component);
        }
    }

    private final void distributeSizeAndWeight(int n, double d, int n2, int n3, int[] nArray, double[] dArray) {
        if (n3 == 1) {
            nArray[n2] = Math.max(nArray[n2], n);
            dArray[n2] = Math.max(dArray[n2], d);
        } else {
            int n4 = n3;
            int n5 = -1;
            int n6 = n2;
            while (n6 < n2 + n3) {
                if ((double)nArray[n6] == 0.0) {
                    --n4;
                } else {
                    n -= nArray[n6];
                    n5 = n6;
                }
                ++n6;
            }
            if (n4 == 0) {
                nArray[n2 + n3 - 1] = n;
            } else if (n > 0) {
                int n7 = n5;
                nArray[n7] = nArray[n7] + n;
            }
            this.calcCellWeights(d, dArray, n2, n3);
        }
    }

    private final void calcCellWeights(double d, double[] dArray, int n, int n2) {
        double d2 = 0.0;
        int n3 = n;
        while (n3 < n + n2) {
            d2 += dArray[n3];
            ++n3;
        }
        if (d > d2) {
            if (d2 == 0.0) {
                int n4 = n + n2 - 1;
                dArray[n4] = dArray[n4] + d;
            } else {
                double d3;
                double d4 = d3 = d - d2;
                int n5 = n;
                while (n5 < n + n2) {
                    double d5 = d3 * dArray[n5] / d2;
                    int n6 = n5++;
                    dArray[n6] = dArray[n6] + d5;
                    d4 -= d5;
                }
                if (d4 > 0.0 && dArray[n + n2 - 1] != 0.0) {
                    int n7 = n + n2 - 1;
                    dArray[n7] = dArray[n7] + d4;
                }
            }
        }
    }

    private final void calcCellSizes(int[] nArray, double[] dArray, int n) {
        int n2 = this.sumIntArray(nArray);
        double d = this.sumDoubleArray(dArray);
        int n3 = n - n2;
        if (n3 == 0) {
            return;
        }
        int n4 = 0;
        while (n4 < nArray.length) {
            int n5 = (int)((double)nArray[n4] + (double)n3 * dArray[n4] / d);
            if (n5 > 0) {
                nArray[n4] = n5;
            }
            ++n4;
        }
    }

    private final void dumpLayoutInfo(GridBagLayoutInfo gridBagLayoutInfo) {
        System.out.println("GridBagLayoutInfo:");
        System.out.println("cols: " + gridBagLayoutInfo.cols + ", rows: " + gridBagLayoutInfo.rows);
        System.out.print("colWidths: ");
        this.dumpArray(gridBagLayoutInfo.colWidths);
        System.out.print("rowHeights: ");
        this.dumpArray(gridBagLayoutInfo.rowHeights);
        System.out.print("colWeights: ");
        this.dumpArray(gridBagLayoutInfo.colWeights);
        System.out.print("rowWeights: ");
        this.dumpArray(gridBagLayoutInfo.rowWeights);
    }

    private final void dumpArray(int[] nArray) {
        String string = "";
        int n = 0;
        while (n < nArray.length) {
            System.out.print(string);
            System.out.print(nArray[n]);
            string = ", ";
            ++n;
        }
        System.out.println();
    }

    private final void dumpArray(double[] dArray) {
        String string = "";
        int n = 0;
        while (n < dArray.length) {
            System.out.print(string);
            System.out.print(dArray[n]);
            string = ", ";
            ++n;
        }
        System.out.println();
    }

    protected void arrangeGrid(Container container) {
        this.ArrangeGrid(container);
    }

    protected GridBagLayoutInfo getLayoutInfo(Container container, int n) {
        return this.GetLayoutInfo(container, n);
    }

    protected void adjustForGravity(GridBagConstraints gridBagConstraints, Rectangle rectangle) {
        this.AdjustForGravity(gridBagConstraints, rectangle);
    }
}

