/*
 * Decompiled with CFR 0.152.
 */
package java.awt.datatransfer;

import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Clipboard {
    protected Transferable contents;
    protected ClipboardOwner owner;
    private final String name;
    private final ArrayList listeners;

    public String getName() {
        return this.name;
    }

    public synchronized Transferable getContents(Object object) {
        return this.contents;
    }

    public synchronized void setContents(Transferable transferable, ClipboardOwner clipboardOwner) {
        FlavorListener[] flavorListenerArray;
        Transferable transferable2 = this.getContents(null);
        this.contents = transferable;
        if (this.owner != clipboardOwner) {
            flavorListenerArray = this.owner;
            this.owner = clipboardOwner;
            if (flavorListenerArray != null) {
                flavorListenerArray.lostOwnership(this, transferable2);
            }
        }
        if ((flavorListenerArray = this.getFlavorListeners()).length > 0) {
            Object object;
            boolean bl;
            boolean bl2 = false;
            if (transferable != null && transferable2 == null || transferable == null && transferable2 != null) {
                bl2 = true;
            }
            if (!(bl = bl2) && transferable != null && transferable2 != null) {
                object = transferable.getTransferDataFlavors();
                DataFlavor[] dataFlavorArray = transferable2.getTransferDataFlavors();
                boolean bl3 = false;
                if (((DataFlavor[])object).length != dataFlavorArray.length) {
                    bl3 = true;
                }
                bl = bl3;
                int n = 0;
                while (!bl && n < ((DataFlavor[])object).length) {
                    bl = object[n].equals(dataFlavorArray[n]) ^ true;
                    ++n;
                }
            }
            if (bl) {
                object = new FlavorEvent(this);
                int n = 0;
                while (n < flavorListenerArray.length) {
                    flavorListenerArray[n].flavorsChanged((FlavorEvent)object);
                    ++n;
                }
            }
        }
    }

    public DataFlavor[] getAvailableDataFlavors() {
        Transferable transferable = this.getContents(null);
        if (transferable == null) {
            return new DataFlavor[0];
        }
        return transferable.getTransferDataFlavors();
    }

    public boolean isDataFlavorAvailable(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = this.getAvailableDataFlavors();
        int n = 0;
        while (n < dataFlavorArray.length) {
            if (dataFlavor.equals(dataFlavorArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Object getData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        Transferable transferable = this.getContents(null);
        if (transferable == null) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        return transferable.getTransferData(dataFlavor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addFlavorListener(FlavorListener flavorListener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(flavorListener);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeFlavorListener(FlavorListener flavorListener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(flavorListener);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FlavorListener[] getFlavorListeners() {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            return (FlavorListener[])this.listeners.toArray(new FlavorListener[this.listeners.size()]);
        }
    }

    private final /* synthetic */ void this() {
        this.listeners = new ArrayList(3);
    }

    public Clipboard(String string) {
        this.this();
        this.name = string;
    }
}

