/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.util.NoSuchElementException;

public abstract class Rectangle2D
extends RectangularShape {
    public static final int OUT_LEFT = 1;
    public static final int OUT_TOP = 2;
    public static final int OUT_RIGHT = 4;
    public static final int OUT_BOTTOM = 8;

    public abstract void setRect(double var1, double var3, double var5, double var7);

    public void setRect(Rectangle2D rectangle2D) {
        this.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public boolean intersectsLine(double d, double d2, double d3, double d4) {
        double d5 = this.getX();
        double d6 = this.getY();
        double d7 = this.getWidth();
        double d8 = this.getHeight();
        if (d7 <= 0.0 || d8 <= 0.0) {
            return false;
        }
        if (d >= d5 && d <= d5 + d7 && d2 >= d6 && d2 <= d6 + d8) {
            return true;
        }
        if (d3 >= d5 && d3 <= d5 + d7 && d4 >= d6 && d4 <= d6 + d8) {
            return true;
        }
        double d9 = d5 + d7;
        double d10 = d6 + d8;
        boolean bl = false;
        if (Line2D.linesIntersect(d, d2, d3, d4, d5, d6, d5, d10) || Line2D.linesIntersect(d, d2, d3, d4, d5, d10, d9, d10) || Line2D.linesIntersect(d, d2, d3, d4, d9, d10, d9, d6) || Line2D.linesIntersect(d, d2, d3, d4, d9, d6, d5, d6)) {
            bl = true;
        }
        return bl;
    }

    public boolean intersectsLine(Line2D line2D) {
        return this.intersectsLine(line2D.getX1(), line2D.getY1(), line2D.getX2(), line2D.getY2());
    }

    public abstract int outcode(double var1, double var3);

    public int outcode(Point2D point2D) {
        return this.outcode(point2D.getX(), point2D.getY());
    }

    public void setFrame(double d, double d2, double d3, double d4) {
        this.setRect(d, d2, d3, d4);
    }

    public Rectangle2D getBounds2D() {
        return (Rectangle2D)this.clone();
    }

    public boolean contains(double d, double d2) {
        double d3 = this.getX();
        double d4 = this.getY();
        double d5 = this.getWidth();
        double d6 = this.getHeight();
        boolean bl = false;
        if (d5 > 0.0 && d6 > 0.0 && d >= d3 && d < d3 + d5 && d2 >= d4 && d2 < d4 + d6) {
            bl = true;
        }
        return bl;
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        double d5 = this.getX();
        double d6 = this.getY();
        double d7 = this.getWidth();
        double d8 = this.getHeight();
        boolean bl = false;
        if (d3 > 0.0 && d4 > 0.0 && d7 > 0.0 && d8 > 0.0 && d < d5 + d7 && d + d3 > d5 && d2 < d6 + d8 && d2 + d4 > d6) {
            bl = true;
        }
        return bl;
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        double d5 = this.getX();
        double d6 = this.getY();
        double d7 = this.getWidth();
        double d8 = this.getHeight();
        boolean bl = false;
        if (d3 > 0.0 && d4 > 0.0 && d7 > 0.0 && d8 > 0.0 && d >= d5 && d + d3 <= d5 + d7 && d2 >= d6 && d2 + d4 <= d6 + d8) {
            bl = true;
        }
        return bl;
    }

    public abstract Rectangle2D createIntersection(Rectangle2D var1);

    public static void intersect(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, Rectangle2D rectangle2D3) {
        double d = Math.max(rectangle2D.getX(), rectangle2D2.getX());
        double d2 = Math.max(rectangle2D.getY(), rectangle2D2.getY());
        double d3 = Math.min(rectangle2D.getMaxX(), rectangle2D2.getMaxX());
        double d4 = Math.min(rectangle2D.getMaxY(), rectangle2D2.getMaxY());
        rectangle2D3.setRect(d, d2, d3 - d, d4 - d2);
    }

    public abstract Rectangle2D createUnion(Rectangle2D var1);

    public static void union(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, Rectangle2D rectangle2D3) {
        double d = Math.min(rectangle2D.getX(), rectangle2D2.getX());
        double d2 = Math.min(rectangle2D.getY(), rectangle2D2.getY());
        double d3 = Math.max(rectangle2D.getMaxX(), rectangle2D2.getMaxX());
        double d4 = Math.max(rectangle2D.getMaxY(), rectangle2D2.getMaxY());
        rectangle2D3.setRect(d, d2, d3 - d, d4 - d2);
    }

    public void add(double d, double d2) {
        double d3 = Math.min(this.getX(), d);
        double d4 = Math.max(this.getMaxX(), d);
        double d5 = Math.min(this.getY(), d2);
        double d6 = Math.max(this.getMaxY(), d2);
        this.setRect(d3, d5, d4 - d3, d6 - d5);
    }

    public void add(Point2D point2D) {
        this.add(point2D.getX(), point2D.getY());
    }

    public void add(Rectangle2D rectangle2D) {
        Rectangle2D.union(this, rectangle2D, this);
    }

    public PathIterator getPathIterator(final AffineTransform affineTransform) {
        final double d = this.getX();
        final double d2 = this.getY();
        final double d3 = d + this.getWidth();
        final double d4 = d2 + this.getHeight();
        return new PathIterator(){
            private int current;

            public final int getWindingRule() {
                return 1;
            }

            public final boolean isDone() {
                boolean bl = false;
                if (this.current > 5) {
                    bl = true;
                }
                return bl;
            }

            public final void next() {
                ++this.current;
            }

            public final int currentSegment(float[] fArray) {
                switch (this.current) {
                    case 1: {
                        fArray[0] = (float)d3;
                        fArray[1] = (float)d2;
                        break;
                    }
                    case 2: {
                        fArray[0] = (float)d3;
                        fArray[1] = (float)d4;
                        break;
                    }
                    case 3: {
                        fArray[0] = (float)d;
                        fArray[1] = (float)d4;
                        break;
                    }
                    case 0: 
                    case 4: {
                        fArray[0] = (float)d;
                        fArray[1] = (float)d2;
                        break;
                    }
                    case 5: {
                        return 4;
                    }
                    default: {
                        throw new NoSuchElementException("rect iterator out of bounds");
                    }
                }
                if (affineTransform != null) {
                    affineTransform.transform(fArray, 0, fArray, 0, 1);
                }
                int n = 0;
                if (this.current == 0) {
                    n = 1;
                }
                return 1 - n;
            }

            public final int currentSegment(double[] dArray) {
                switch (this.current) {
                    case 1: {
                        dArray[0] = d3;
                        dArray[1] = d2;
                        break;
                    }
                    case 2: {
                        dArray[0] = d3;
                        dArray[1] = d4;
                        break;
                    }
                    case 3: {
                        dArray[0] = d;
                        dArray[1] = d4;
                        break;
                    }
                    case 0: 
                    case 4: {
                        dArray[0] = d;
                        dArray[1] = d2;
                        break;
                    }
                    case 5: {
                        return 4;
                    }
                    default: {
                        throw new NoSuchElementException("rect iterator out of bounds");
                    }
                }
                if (affineTransform != null) {
                    affineTransform.transform(dArray, 0, dArray, 0, 1);
                }
                int n = 0;
                if (this.current == 0) {
                    n = 1;
                }
                return 1 - n;
            }

            private final /* synthetic */ void this() {
                this.current = d3 <= d && d4 <= d2 ? 6 : 0;
            }
            {
                this.this();
            }
        };
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return this.getPathIterator(affineTransform);
    }

    public int hashCode() {
        long l = java.lang.Double.doubleToLongBits(this.getX()) + 37L * java.lang.Double.doubleToLongBits(this.getY()) + 43L * java.lang.Double.doubleToLongBits(this.getWidth()) + 47L * java.lang.Double.doubleToLongBits(this.getHeight());
        return (int)(l >> 32 ^ l);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Rectangle2D)) {
            return false;
        }
        Rectangle2D rectangle2D = (Rectangle2D)object;
        boolean bl = false;
        if (rectangle2D.getX() == this.getX() && rectangle2D.getY() == this.getY() && rectangle2D.getWidth() == this.getWidth() && rectangle2D.getHeight() == this.getHeight()) {
            bl = true;
        }
        return bl;
    }

    protected Rectangle2D() {
    }

    public static class Float
    extends Rectangle2D {
        public float x;
        public float y;
        public float width;
        public float height;

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public boolean isEmpty() {
            boolean bl = false;
            if (this.width <= 0.0f || this.height <= 0.0f) {
                bl = true;
            }
            return bl;
        }

        public void setRect(float f, float f2, float f3, float f4) {
            this.x = f;
            this.y = f2;
            this.width = f3;
            this.height = f4;
        }

        public void setRect(double d, double d2, double d3, double d4) {
            this.x = (float)d;
            this.y = (float)d2;
            this.width = (float)d3;
            this.height = (float)d4;
        }

        public void setRect(Rectangle2D rectangle2D) {
            this.x = (float)rectangle2D.getX();
            this.y = (float)rectangle2D.getY();
            this.width = (float)rectangle2D.getWidth();
            this.height = (float)rectangle2D.getHeight();
        }

        public int outcode(double d, double d2) {
            int n = 0;
            if (this.width <= 0.0f) {
                n |= 5;
            } else if (d < (double)this.x) {
                n |= 1;
            } else if (d > (double)(this.x + this.width)) {
                n |= 4;
            }
            if (this.height <= 0.0f) {
                n |= 0xA;
            } else if (d2 < (double)this.y) {
                n |= 2;
            } else if (d2 > (double)(this.y + this.height)) {
                n |= 8;
            }
            return n;
        }

        public Rectangle2D getBounds2D() {
            return new Float(this.x, this.y, this.width, this.height);
        }

        public Rectangle2D createIntersection(Rectangle2D rectangle2D) {
            Float float_ = new Float();
            Float.intersect(this, rectangle2D, float_);
            return float_;
        }

        public Rectangle2D createUnion(Rectangle2D rectangle2D) {
            Float float_ = new Float();
            Float.union(this, rectangle2D, float_);
            return float_;
        }

        public String toString() {
            return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",w=" + this.width + ",h=" + this.height + ']';
        }

        public Float() {
        }

        public Float(float f, float f2, float f3, float f4) {
            this.x = f;
            this.y = f2;
            this.width = f3;
            this.height = f4;
        }

        Float(double d, double d2, double d3, double d4) {
            this.x = (float)d;
            this.y = (float)d2;
            this.width = (float)d3;
            this.height = (float)d4;
        }
    }

    public static class Double
    extends Rectangle2D {
        public double x;
        public double y;
        public double width;
        public double height;

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public boolean isEmpty() {
            boolean bl = false;
            if (this.width <= 0.0 || this.height <= 0.0) {
                bl = true;
            }
            return bl;
        }

        public void setRect(double d, double d2, double d3, double d4) {
            this.x = d;
            this.y = d2;
            this.width = d3;
            this.height = d4;
        }

        public void setRect(Rectangle2D rectangle2D) {
            this.x = rectangle2D.getX();
            this.y = rectangle2D.getY();
            this.width = rectangle2D.getWidth();
            this.height = rectangle2D.getHeight();
        }

        public int outcode(double d, double d2) {
            int n = 0;
            if (this.width <= 0.0) {
                n |= 5;
            } else if (d < this.x) {
                n |= 1;
            } else if (d > this.x + this.width) {
                n |= 4;
            }
            if (this.height <= 0.0) {
                n |= 0xA;
            } else if (d2 < this.y) {
                n |= 2;
            } else if (d2 > this.y + this.height) {
                n |= 8;
            }
            return n;
        }

        public Rectangle2D getBounds2D() {
            return new Double(this.x, this.y, this.width, this.height);
        }

        public Rectangle2D createIntersection(Rectangle2D rectangle2D) {
            Double double_ = new Double();
            Double.intersect(this, rectangle2D, double_);
            return double_;
        }

        public Rectangle2D createUnion(Rectangle2D rectangle2D) {
            Double double_ = new Double();
            Double.union(this, rectangle2D, double_);
            return double_;
        }

        public String toString() {
            return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",w=" + this.width + ",h=" + this.height + ']';
        }

        public Double() {
        }

        public Double(double d, double d2, double d3, double d4) {
            this.x = d;
            this.y = d2;
            this.width = d3;
            this.height = d4;
        }
    }
}

