/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class DataOutputStream
extends FilterOutputStream
implements DataOutput {
    protected int written = 0;

    public void flush() throws IOException {
        this.out.flush();
    }

    public final int size() {
        return this.written;
    }

    public synchronized void write(int n) throws IOException {
        this.out.write(n);
        ++this.written;
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
        this.written += n2;
    }

    public final void writeBoolean(boolean bl) throws IOException {
        this.write(bl ? 1 : 0);
    }

    public final void writeByte(int n) throws IOException {
        this.write(n & 0xFF);
    }

    public final synchronized void writeShort(int n) throws IOException {
        this.write((byte)(0xFF & n >> 8));
        this.write((byte)(0xFF & n));
    }

    public final synchronized void writeChar(int n) throws IOException {
        this.write((byte)(0xFF & n >> 8));
        this.write((byte)(0xFF & n));
    }

    public final synchronized void writeInt(int n) throws IOException {
        this.write((byte)(0xFF & n >> 24));
        this.write((byte)(0xFF & n >> 16));
        this.write((byte)(0xFF & n >> 8));
        this.write((byte)(0xFF & n));
    }

    public final synchronized void writeLong(long l) throws IOException {
        this.write((byte)(0xFFL & l >> 56));
        this.write((byte)(0xFFL & l >> 48));
        this.write((byte)(0xFFL & l >> 40));
        this.write((byte)(0xFFL & l >> 32));
        this.write((byte)(0xFFL & l >> 24));
        this.write((byte)(0xFFL & l >> 16));
        this.write((byte)(0xFFL & l >> 8));
        this.write((byte)(0xFFL & l));
    }

    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public final void writeBytes(String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            this.writeByte(string.charAt(n2));
            ++n2;
        }
    }

    public final void writeChars(String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            this.writeChar(string.charAt(n2));
            ++n2;
        }
    }

    public final synchronized void writeUTF(String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n && n2 <= (int)-1) {
            char c = string.charAt(n3);
            n2 = c >= '\u0001' && c <= '\u007f' ? ++n2 : (c == '\u0000' || c >= '\u0080' && c <= '\u07ff' ? (n2 += 2) : (n2 += 3));
            ++n3;
        }
        if (n2 > (char)-1) {
            throw new UTFDataFormatException();
        }
        n3 = 0;
        byte[] byArray = new byte[n2];
        int n4 = 0;
        while (n4 < n) {
            char c = string.charAt(n4);
            if (c >= '\u0001' && c <= '\u007f') {
                byArray[n3++] = (byte)c;
            } else if (c == '\u0000' || c >= '\u0080' && c <= '\u07ff') {
                byArray[n3++] = (byte)(0xC0 | 0x1F & c >> 6);
                byArray[n3++] = (byte)(0x80 | 0x3F & c);
            } else {
                byArray[n3++] = (byte)(0xE0 | 0xF & c >> 12);
                byArray[n3++] = (byte)(0x80 | 0x3F & c >> 6);
                byArray[n3++] = (byte)(0x80 | 0x3F & c);
            }
            ++n4;
        }
        this.writeShort(n2);
        this.write(byArray, 0, n2);
    }

    public DataOutputStream(OutputStream outputStream) {
        super(outputStream);
    }
}

