/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Array;

final class VMSystem {
    static final void arraycopy(Object object, int n, Object object2, int n2, int n3) {
        if (object == null) {
            throw new NullPointerException("src == null");
        }
        if (object2 == null) {
            throw new NullPointerException("dest == null");
        }
        if (n3 == 0) {
            return;
        }
        Class clazz = object.getClass();
        if (!clazz.isArray()) {
            throw new ArrayStoreException("source is not an array: " + clazz.getName());
        }
        Class clazz2 = object2.getClass();
        if (!clazz2.isArray()) {
            throw new ArrayStoreException("destination is not an array: " + clazz2.getName());
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("srcStart < 0: " + n);
        }
        int n4 = Array.getLength(object);
        if ((long)n + (long)n3 > (long)n4) {
            throw new ArrayIndexOutOfBoundsException("srcStart + len > src.len: " + n + " + " + n3 + " > " + n4);
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("destStart < 0: " + n2);
        }
        int n5 = Array.getLength(object2);
        if ((long)n2 + (long)n3 > (long)n5) {
            throw new ArrayIndexOutOfBoundsException("destStart + len > dest.len: " + n2 + " + " + n3 + " > " + n5);
        }
        if (n3 < 0) {
            throw new ArrayIndexOutOfBoundsException("len < 0: " + n3);
        }
        VMSystem.arraycopy0(object, n, object2, n2, n3);
    }

    static final native void arraycopy0(Object var0, int var1, Object var2, int var3, int var4);

    static final native int identityHashCode(Object var0);

    static final native void setIn(InputStream var0);

    static final native void setOut(PrintStream var0);

    static final native void setErr(PrintStream var0);

    public static final native long currentTimeMillis();

    static final InputStream makeStandardInputStream() {
        return new BufferedInputStream(new FileInputStream(FileDescriptor.in));
    }

    static final PrintStream makeStandardOutputStream() {
        return new PrintStream(new BufferedOutputStream(new FileOutputStream(FileDescriptor.out)), true);
    }

    static final PrintStream makeStandardErrorStream() {
        return new PrintStream(new BufferedOutputStream(new FileOutputStream(FileDescriptor.err)), true);
    }

    static final native String getenv(String var0);

    VMSystem() {
    }
}

