/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public final class Field
extends AccessibleObject
implements Member {
    private Class clazz;
    private int slot;
    private String name;
    private Class type;

    private final void checkFinal() throws IllegalAccessException {
        if (Modifier.isFinal(this.getModifiers())) {
            throw new IllegalAccessException("trying to set final field " + this.toString());
        }
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Field)) {
            return false;
        }
        Field field = (Field)object;
        return this.clazz == field.clazz && this.type == field.type && this.name.equals(field.name);
    }

    public final Object get(Object object) throws IllegalArgumentException, IllegalAccessException {
        if (this.type == Double.TYPE) {
            return new Double(this.getDouble0(object));
        }
        if (this.type == Float.TYPE) {
            return new Float(this.getFloat0(object));
        }
        if (this.type == Long.TYPE) {
            return new Long(this.getLong0(object));
        }
        if (this.type == Integer.TYPE) {
            return new Integer(this.getInt0(object));
        }
        if (this.type == Short.TYPE) {
            return new Short(this.getShort0(object));
        }
        if (this.type == Byte.TYPE) {
            return new Byte(this.getByte0(object));
        }
        if (this.type == Character.TYPE) {
            return new Character(this.getChar0(object));
        }
        if (this.type == Boolean.TYPE) {
            return new Boolean(this.getBoolean0(object));
        }
        return this.getObject0(object);
    }

    public final boolean getBoolean(Object object) throws IllegalArgumentException, IllegalAccessException {
        if (this.type == Boolean.TYPE) {
            return this.getBoolean0(object);
        }
        throw new IllegalArgumentException();
    }

    public final byte getByte(Object object) throws IllegalArgumentException, IllegalAccessException {
        if (this.type == Byte.TYPE) {
            return this.getByte0(object);
        }
        throw new IllegalArgumentException();
    }

    public final char getChar(Object object) throws IllegalArgumentException, IllegalAccessException {
        if (this.type == Character.TYPE) {
            return this.getChar0(object);
        }
        throw new IllegalArgumentException();
    }

    public final double getDouble(Object object) throws IllegalArgumentException, IllegalAccessException {
        if (this.type == Double.TYPE) {
            return this.getDouble0(object);
        }
        if (this.type == Float.TYPE) {
            return this.getFloat0(object);
        }
        if (this.type == Long.TYPE) {
            return this.getLong0(object);
        }
        if (this.type == Integer.TYPE) {
            return this.getInt0(object);
        }
        if (this.type == Short.TYPE) {
            return this.getShort0(object);
        }
        if (this.type == Byte.TYPE) {
            return this.getByte0(object);
        }
        if (this.type == Character.TYPE) {
            return this.getChar0(object);
        }
        throw new IllegalArgumentException();
    }

    public final float getFloat(Object object) throws IllegalArgumentException, IllegalAccessException {
        if (this.type == Float.TYPE) {
            return this.getFloat0(object);
        }
        if (this.type == Long.TYPE) {
            return this.getLong0(object);
        }
        if (this.type == Integer.TYPE) {
            return this.getInt0(object);
        }
        if (this.type == Short.TYPE) {
            return this.getShort0(object);
        }
        if (this.type == Byte.TYPE) {
            return this.getByte0(object);
        }
        if (this.type == Character.TYPE) {
            return this.getChar0(object);
        }
        throw new IllegalArgumentException();
    }

    public final int getInt(Object object) throws IllegalArgumentException, IllegalAccessException {
        if (this.type == Integer.TYPE) {
            return this.getInt0(object);
        }
        if (this.type == Short.TYPE) {
            return this.getShort0(object);
        }
        if (this.type == Byte.TYPE) {
            return this.getByte0(object);
        }
        if (this.type == Character.TYPE) {
            return this.getChar0(object);
        }
        throw new IllegalArgumentException();
    }

    public final long getLong(Object object) throws IllegalArgumentException, IllegalAccessException {
        if (this.type == Long.TYPE) {
            return this.getLong0(object);
        }
        if (this.type == Integer.TYPE) {
            return this.getInt0(object);
        }
        if (this.type == Short.TYPE) {
            return this.getShort0(object);
        }
        if (this.type == Byte.TYPE) {
            return this.getByte0(object);
        }
        if (this.type == Character.TYPE) {
            return this.getChar0(object);
        }
        throw new IllegalArgumentException();
    }

    public final short getShort(Object object) throws IllegalArgumentException, IllegalAccessException {
        if (this.type == Short.TYPE) {
            return this.getShort0(object);
        }
        if (this.type == Integer.TYPE) {
            return (short)this.getInt0(object);
        }
        if (this.type == Long.TYPE) {
            return (short)this.getLong0(object);
        }
        if (this.type == Float.TYPE) {
            return (short)this.getFloat0(object);
        }
        if (this.type == Double.TYPE) {
            return (short)this.getDouble0(object);
        }
        throw new IllegalArgumentException();
    }

    private final void setInternal(Object object, Object object2) throws IllegalArgumentException, IllegalAccessException {
        if (this.type.isPrimitive()) {
            if (object2 instanceof Boolean) {
                this.setBooleanInternal(object, (Boolean)object2);
            } else if (object2 instanceof Byte) {
                this.setByteInternal(object, (Byte)object2);
            } else if (object2 instanceof Short) {
                this.setShortInternal(object, (Short)object2);
            } else if (object2 instanceof Character) {
                this.setCharInternal(object, ((Character)object2).charValue());
            } else if (object2 instanceof Integer) {
                this.setIntInternal(object, (Integer)object2);
            } else if (object2 instanceof Long) {
                this.setLongInternal(object, (Long)object2);
            } else if (object2 instanceof Float) {
                this.setFloatInternal(object, ((Float)object2).floatValue());
            } else {
                this.setDoubleInternal(object, (Double)object2);
            }
        } else {
            if (object2 != null && !this.type.isInstance(object2)) {
                throw new IllegalArgumentException("field type mismatch: Trying to assign a " + object2.getClass().getName() + " to " + this.toString());
            }
            this.setObject0(object, object2);
        }
    }

    public final void set(Object object, Object object2) throws IllegalArgumentException, IllegalAccessException {
        this.checkFinal();
        this.setInternal(object, object2);
    }

    public final void setBooleanInternal(Object object, boolean bl) throws IllegalArgumentException, IllegalAccessException {
        if (this.type != Boolean.TYPE) {
            throw new IllegalArgumentException();
        }
        this.setBoolean0(object, bl);
    }

    public final void setBoolean(Object object, boolean bl) throws IllegalArgumentException, IllegalAccessException {
        this.checkFinal();
        this.setBooleanInternal(object, bl);
    }

    public final void setByteInternal(Object object, byte by) throws IllegalArgumentException, IllegalAccessException {
        if (this.type == Byte.TYPE) {
            this.setByte0(object, by);
        } else if (this.type == Short.TYPE) {
            this.setShort0(object, by);
        } else if (this.type == Integer.TYPE) {
            this.setInt0(object, by);
        } else if (this.type == Long.TYPE) {
            this.setLong0(object, by);
        } else if (this.type == Float.TYPE) {
            this.setFloat0(object, by);
        } else if (this.type == Double.TYPE) {
            this.setDouble0(object, by);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public final void setByte(Object object, byte by) throws IllegalArgumentException, IllegalAccessException {
        this.checkFinal();
        this.setByteInternal(object, by);
    }

    public final void setCharInternal(Object object, char c) throws IllegalArgumentException, IllegalAccessException {
        if (this.type == Character.TYPE) {
            this.setChar0(object, c);
        } else if (this.type == Integer.TYPE) {
            this.setInt0(object, c);
        } else if (this.type == Long.TYPE) {
            this.setLong0(object, c);
        } else if (this.type == Float.TYPE) {
            this.setFloat0(object, c);
        } else if (this.type == Double.TYPE) {
            this.setDouble0(object, c);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public final void setChar(Object object, char c) throws IllegalArgumentException, IllegalAccessException {
        this.checkFinal();
        this.setCharInternal(object, c);
    }

    public final void setDoubleInternal(Object object, double d) throws IllegalArgumentException, IllegalAccessException {
        if (this.type != Double.TYPE) {
            throw new IllegalArgumentException();
        }
        this.setDouble0(object, d);
    }

    public final void setDouble(Object object, double d) throws IllegalArgumentException, IllegalAccessException {
        this.checkFinal();
        this.setDoubleInternal(object, d);
    }

    public final void setFloatInternal(Object object, float f) throws IllegalArgumentException, IllegalAccessException {
        if (this.type == Float.TYPE) {
            this.setFloat0(object, f);
        } else if (this.type == Double.TYPE) {
            this.setDouble0(object, f);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public final void setFloat(Object object, float f) throws IllegalArgumentException, IllegalAccessException {
        this.checkFinal();
        this.setFloatInternal(object, f);
    }

    public final void setIntInternal(Object object, int n) throws IllegalArgumentException, IllegalAccessException {
        if (this.type == Integer.TYPE) {
            this.setInt0(object, n);
        } else if (this.type == Long.TYPE) {
            this.setLong0(object, n);
        } else if (this.type == Float.TYPE) {
            this.setFloat0(object, n);
        } else if (this.type == Double.TYPE) {
            this.setDouble0(object, n);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public final void setInt(Object object, int n) throws IllegalArgumentException, IllegalAccessException {
        this.checkFinal();
        this.setIntInternal(object, n);
    }

    public final void setLongInternal(Object object, long l) throws IllegalArgumentException, IllegalAccessException {
        if (this.type == Long.TYPE) {
            this.setLong0(object, l);
        } else if (this.type == Float.TYPE) {
            this.setFloat0(object, l);
        } else if (this.type == Double.TYPE) {
            this.setDouble0(object, l);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public final void setLong(Object object, long l) throws IllegalArgumentException, IllegalAccessException {
        this.checkFinal();
        this.setLongInternal(object, l);
    }

    public final void setShortInternal(Object object, short s) throws IllegalArgumentException, IllegalAccessException {
        this.checkFinal();
        if (this.type == Short.TYPE) {
            this.setShort0(object, s);
        } else if (this.type == Integer.TYPE) {
            this.setInt0(object, s);
        } else if (this.type == Long.TYPE) {
            this.setLong0(object, s);
        } else if (this.type == Float.TYPE) {
            this.setFloat0(object, s);
        } else if (this.type == Double.TYPE) {
            this.setDouble0(object, s);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public final void setShort(Object object, short s) throws IllegalArgumentException, IllegalAccessException {
        this.checkFinal();
        this.setShortInternal(object, s);
    }

    public final Class getDeclaringClass() {
        return this.clazz;
    }

    public final native int getModifiers();

    public final String getName() {
        return this.name;
    }

    public final Class getType() {
        return this.type;
    }

    public final int hashCode() {
        return this.clazz.getName().hashCode() ^ this.name.hashCode();
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getModifiers();
        if (n != 0) {
            stringBuffer.append(Modifier.toString(n));
            stringBuffer.append(' ');
        }
        stringBuffer.append(Method.getPrettyName(this.type));
        stringBuffer.append(' ');
        stringBuffer.append(this.clazz.getName());
        stringBuffer.append('.');
        stringBuffer.append(this.name);
        return stringBuffer.toString();
    }

    private final native boolean getBoolean0(Object var1);

    private final native byte getByte0(Object var1);

    private final native char getChar0(Object var1);

    private final native short getShort0(Object var1);

    private final native int getInt0(Object var1);

    private final native long getLong0(Object var1);

    private final native float getFloat0(Object var1);

    private final native double getDouble0(Object var1);

    private final native Object getObject0(Object var1);

    private final native void setBoolean0(Object var1, boolean var2);

    private final native void setByte0(Object var1, byte var2);

    private final native void setChar0(Object var1, char var2);

    private final native void setShort0(Object var1, short var2);

    private final native void setInt0(Object var1, int var2);

    private final native void setLong0(Object var1, long var2);

    private final native void setFloat0(Object var1, float var2);

    private final native void setDouble0(Object var1, double var2);

    private final native void setObject0(Object var1, Object var2);

    private Field() {
    }
}

