/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.StringTokenizer;

public final class SocketPermission
extends Permission
implements Serializable {
    static final long serialVersionUID = -7204263841984476862L;
    private static final int MIN_PORT = 0;
    private static final int MAX_PORT = Integer.MAX_VALUE;
    private static final String[] ACTIONS = new String[]{"connect", "listen", "accept", "resolve"};
    private transient String host;
    private transient int minport;
    private transient int maxport;
    private String actions;
    private transient int actionmask;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void setHostPort(String string) {
        int n;
        String string2;
        if (string.length() == 0) {
            string2 = "";
            this.host = "";
        } else if (string.charAt(0) == '[') {
            n = string.indexOf("]");
            if (n == -1) {
                throw new IllegalArgumentException("Unmatched '['");
            }
            this.host = string.substring(1, n);
            if (n == string.length() - 1) {
                string2 = "";
            } else {
                if (string.charAt(n + 1) != ':') throw new IllegalArgumentException("Bad character after ']'");
                string2 = string.substring(n + 2);
            }
        } else {
            n = string.indexOf(":");
            if (n == -1) {
                this.host = string;
                string2 = "";
            } else {
                this.host = string.substring(0, n);
                string2 = string.substring(n + 1);
            }
        }
        if (string2.indexOf(":") != -1) {
            throw new IllegalArgumentException("Unexpected ':'");
        }
        if (string2.length() == 0) {
            this.minport = 0;
            this.maxport = Integer.MAX_VALUE;
            return;
        } else {
            n = string2.indexOf("-");
            if (n == -1) {
                this.minport = this.maxport = Integer.parseInt(string2);
                return;
            } else {
                if (string2.indexOf("-", n + 1) != -1) {
                    throw new IllegalArgumentException("Unexpected '-'");
                }
                if (n == 0) {
                    this.minport = 0;
                    this.maxport = Integer.parseInt(string2.substring(1));
                    return;
                } else if (n == string2.length() - 1) {
                    this.minport = Integer.parseInt(string2.substring(0, string2.length() - 1));
                    this.maxport = Integer.MAX_VALUE;
                    return;
                } else {
                    this.minport = Integer.parseInt(string2.substring(0, n));
                    this.maxport = Integer.parseInt(string2.substring(n + 1));
                }
            }
        }
    }

    private final void setActions(String string) {
        this.actionmask = 0;
        boolean bl = false;
        boolean bl2 = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            string2 = string2.trim().toLowerCase();
            this.setAction(string2);
            if (string2.equals("resolve")) {
                bl2 = true;
                continue;
            }
            bl = true;
        }
        if (bl && !bl2) {
            this.setAction("resolve");
        }
    }

    private final void setAction(String string) {
        int n = 0;
        while (n < ACTIONS.length) {
            if (string.equals(ACTIONS[n])) {
                this.actionmask |= 1 << n;
                return;
            }
            ++n;
        }
        throw new IllegalArgumentException("Unknown action " + string);
    }

    public final boolean equals(Object object) {
        if (!(object instanceof SocketPermission)) {
            return false;
        }
        SocketPermission socketPermission = (SocketPermission)object;
        boolean bl = false;
        if (socketPermission.actionmask == this.actionmask && socketPermission.minport == this.minport && socketPermission.maxport == this.maxport && socketPermission.host.equals(this.host)) {
            bl = true;
        }
        return bl;
    }

    public final int hashCode() {
        return this.actionmask + this.minport + this.maxport + this.host.hashCode();
    }

    public final String getActions() {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        while (n < ACTIONS.length) {
            if ((this.actionmask & 1 << n) != 0) {
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(ACTIONS[n]);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public final PermissionCollection newPermissionCollection() {
        return null;
    }

    public final boolean implies(Permission permission) {
        String string;
        String string2;
        String string3;
        block8: {
            if (!(permission instanceof SocketPermission)) {
                return false;
            }
            SocketPermission socketPermission = (SocketPermission)permission;
            if ((socketPermission.actionmask & this.actionmask) != socketPermission.actionmask) {
                return false;
            }
            if (socketPermission.minport < this.minport || socketPermission.maxport > this.maxport) {
                return false;
            }
            if (this.host.equals(socketPermission.host)) {
                return true;
            }
            string3 = null;
            string2 = null;
            try {
                string3 = InetAddress.getByName(this.host).getHostName();
                string2 = InetAddress.getByName(socketPermission.host).getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                if (string3 == null) {
                    string3 = this.host;
                }
                if (string2 != null) break block8;
                string2 = socketPermission.host;
            }
        }
        if (string3.equals(string2)) {
            return true;
        }
        return this.host.indexOf("*.") != -1 && string2.endsWith(string = this.host.substring(this.host.indexOf("*1")));
    }

    private final void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.setHostPort(this.getName());
        this.setActions(this.actions);
    }

    private final void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.actions = this.getActions();
        objectOutputStream.defaultWriteObject();
    }

    public SocketPermission(String string, String string2) {
        super(string);
        this.setHostPort(string);
        this.setActions(string2);
    }
}

