/*
 * Decompiled with CFR 0.152.
 */
package java.rmi;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;

public final class Naming {
    public static final Remote lookup(String string) throws NotBoundException, MalformedURLException, RemoteException {
        URL uRL = Naming.parseURL(string);
        String string2 = Naming.getName(uRL);
        return Naming.getRegistry(uRL).lookup(string2);
    }

    public static final void bind(String string, Remote remote) throws AlreadyBoundException, MalformedURLException, RemoteException {
        URL uRL = Naming.parseURL(string);
        String string2 = Naming.getName(uRL);
        Naming.getRegistry(uRL).bind(string2, remote);
    }

    public static final void unbind(String string) throws RemoteException, NotBoundException, MalformedURLException {
        URL uRL = Naming.parseURL(string);
        String string2 = Naming.getName(uRL);
        Naming.getRegistry(uRL).unbind(string2);
    }

    public static final void rebind(String string, Remote remote) throws RemoteException, MalformedURLException {
        URL uRL = Naming.parseURL(string);
        String string2 = Naming.getName(uRL);
        Naming.getRegistry(uRL).rebind(string2, remote);
    }

    public static final String[] list(String string) throws RemoteException, MalformedURLException {
        return Naming.getRegistry(Naming.parseURL(string)).list();
    }

    private static final Registry getRegistry(URL uRL) throws RemoteException {
        if (uRL.getPort() == -1) {
            return LocateRegistry.getRegistry(uRL.getHost());
        }
        return LocateRegistry.getRegistry(uRL.getHost(), uRL.getPort());
    }

    private static final URL parseURL(String string) throws MalformedURLException {
        try {
            URI uRI = new URI(string);
            String string2 = uRI.getHost();
            int n = uRI.getPort();
            String string3 = uRI.getQuery();
            String string4 = uRI.getPath();
            return new URL("http", string2 == null ? "localhost" : string2, n == -1 ? 1099 : n, uRI.getPath() + (string3 == null ? "" : string3));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new MalformedURLException("The URL syntax was invalid: " + uRISyntaxException.getMessage());
        }
    }

    private static final String getName(URL uRL) throws MalformedURLException {
        String string = uRL.getFile();
        if (string.length() == 0) {
            throw new MalformedURLException("No path specified: " + uRL);
        }
        if (string.charAt(0) == '/') {
            return string.substring(1);
        }
        return string;
    }

    private Naming() {
    }
}

