/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.InvalidKeyException;
import java.security.spec.KeySpec;

public class DESKeySpec
implements KeySpec {
    public static final int DES_KEY_LEN = 8;
    private static final byte[][] WEAK_KEYS;
    private byte[] key;

    public static boolean isParityAdjusted(byte[] byArray, int n) throws InvalidKeyException {
        if (byArray.length - n < 8) {
            throw new InvalidKeyException("DES keys must be 8 bytes long");
        }
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < 8) {
            bl2 = false;
            int n3 = 0;
            while (n3 < 8) {
                boolean bl3 = false;
                if ((byArray[n2 + n] & 1 << n3) != 0) {
                    bl3 = true;
                }
                bl2 ^= bl3;
                ++n3;
            }
            bl &= bl2;
            ++n2;
        }
        return bl;
    }

    public static boolean isWeak(byte[] byArray, int n) throws InvalidKeyException {
        if (byArray.length - n < 8) {
            throw new InvalidKeyException("DES keys must be 8 bytes long");
        }
        int n2 = 0;
        while (n2 < WEAK_KEYS.length) {
            if (DESKeySpec.equalsOrComplementEquals(byArray, n, WEAK_KEYS[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static final boolean equalsOrComplementEquals(byte[] byArray, int n, byte[] byArray2) {
        boolean bl = true;
        int n2 = 0;
        while (n2 < 8) {
            boolean bl2 = false;
            if (byArray[n + n2] == byArray2[n2]) {
                bl2 = true;
            }
            bl &= bl2;
            ++n2;
        }
        if (bl) {
            return true;
        }
        bl = true;
        n2 = 0;
        while (n2 < 8) {
            boolean bl3 = false;
            if (byArray[n + n2] == ~byArray2[n2]) {
                bl3 = true;
            }
            bl &= bl3;
            ++n2;
        }
        return bl;
    }

    public byte[] getKey() {
        return this.key;
    }

    public DESKeySpec(byte[] byArray) throws InvalidKeyException {
        this(byArray, 0);
    }

    public DESKeySpec(byte[] byArray, int n) throws InvalidKeyException {
        if (byArray.length - n < 8) {
            throw new InvalidKeyException("DES keys must be 8 bytes long");
        }
        this.key = new byte[8];
        System.arraycopy(byArray, n, this.key, 0, 8);
    }

    static {
        byte[][] byArrayArray = new byte[10][];
        byArrayArray[0] = new byte[8];
        byte[] byArray = new byte[8];
        byArray[0] = -1;
        byArray[1] = -1;
        byArray[2] = -1;
        byArray[3] = -1;
        byArrayArray[1] = byArray;
        byArrayArray[2] = new byte[]{1, 1, 1, 1, 1, 1, 1, 1};
        byArrayArray[3] = new byte[]{31, 31, 31, 31, 14, 14, 14, 14};
        byArrayArray[4] = new byte[]{1, -2, 1, -2, 1, -2, 1, -2};
        byArrayArray[5] = new byte[]{31, -32, 31, -32, -32, 31, -32, 31};
        byArrayArray[6] = new byte[]{1, -32, 1, -32, 1, -15, 1, -15};
        byArrayArray[7] = new byte[]{31, -2, 31, -2, 14, -2, 14, -2};
        byArrayArray[8] = new byte[]{1, 31, 1, 31, 1, 14, 1, 14};
        byArrayArray[9] = new byte[]{-32, -2, -32, -2, -15, -2, -15, -2};
        WEAK_KEYS = byArrayArray;
    }
}

