/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.LookAndFeel;
import javax.swing.Timer;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SpinnerUI;
import javax.swing.plaf.basic.BasicArrowButton;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BasicSpinnerUI
extends SpinnerUI {
    protected JSpinner spinner;
    private PropertyChangeListener listener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicSpinnerUI();
    }

    protected JComponent createEditor() {
        return this.spinner.getEditor();
    }

    protected LayoutManager createLayout() {
        return new DefaultLayoutManager();
    }

    protected Component createNextButton() {
        BasicArrowButton basicArrowButton = new BasicArrowButton(1);
        return basicArrowButton;
    }

    protected Component createPreviousButton() {
        BasicArrowButton basicArrowButton = new BasicArrowButton(5);
        return basicArrowButton;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeListener(){

            public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("editor".equals(propertyChangeEvent.getPropertyName())) {
                    BasicSpinnerUI.this.replaceEditor((JComponent)propertyChangeEvent.getOldValue(), (JComponent)propertyChangeEvent.getNewValue());
                }
            }
        };
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.spinner, "Spinner.background", "Spinner.foreground", "Spinner.font");
        LookAndFeel.installBorder(this.spinner, "Spinner.border");
        JComponent jComponent = this.spinner.getEditor();
        if (jComponent instanceof JSpinner.DefaultEditor) {
            JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)jComponent;
            defaultEditor.getTextField().setBorder(null);
        }
        this.spinner.setLayout(this.createLayout());
        this.spinner.setOpaque(true);
    }

    protected void installListeners() {
        this.spinner.addPropertyChangeListener(this.listener);
    }

    protected void installNextButtonListeners(Component component) {
        component.addMouseListener(new MouseAdapter(){
            volatile boolean mouseDown;
            Timer timer;

            public final void mousePressed(MouseEvent mouseEvent) {
                if (!BasicSpinnerUI.this.spinner.isEnabled()) {
                    return;
                }
                this.increment();
                this.timer.setInitialDelay(500);
                this.timer.start();
            }

            public final void mouseReleased(MouseEvent mouseEvent) {
                this.timer.stop();
            }

            final void increment() {
                Object object = BasicSpinnerUI.this.spinner.getNextValue();
                if (object != null) {
                    BasicSpinnerUI.this.spinner.getModel().setValue(object);
                }
            }

            private final /* synthetic */ void this() {
                this.mouseDown = false;
                this.timer = new Timer(50, new ActionListener(){

                    public final void actionPerformed(ActionEvent actionEvent) {
                        this.increment();
                    }
                });
            }
            {
                this.this();
            }
        });
    }

    protected void installPreviousButtonListeners(Component component) {
        component.addMouseListener(new MouseAdapter(){
            volatile boolean mouseDown;
            Timer timer;

            public final void mousePressed(MouseEvent mouseEvent) {
                if (!BasicSpinnerUI.this.spinner.isEnabled()) {
                    return;
                }
                this.decrement();
                this.timer.setInitialDelay(500);
                this.timer.start();
            }

            public final void mouseReleased(MouseEvent mouseEvent) {
                this.timer.stop();
            }

            final void decrement() {
                Object object = BasicSpinnerUI.this.spinner.getPreviousValue();
                if (object != null) {
                    BasicSpinnerUI.this.spinner.getModel().setValue(object);
                }
            }

            private final /* synthetic */ void this() {
                this.mouseDown = false;
                this.timer = new Timer(50, new ActionListener(){

                    public final void actionPerformed(ActionEvent actionEvent) {
                        this.decrement();
                    }
                });
            }
            {
                this.this();
            }
        });
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.spinner = (JSpinner)jComponent;
        this.installDefaults();
        this.installListeners();
        Component component = this.createNextButton();
        Component component2 = this.createPreviousButton();
        this.installNextButtonListeners(component);
        this.installPreviousButtonListeners(component2);
        jComponent.add((Component)this.createEditor(), "Editor");
        jComponent.add(component, "Next");
        jComponent.add(component2, "Previous");
    }

    protected void replaceEditor(JComponent jComponent, JComponent jComponent2) {
        this.spinner.remove(jComponent);
        this.spinner.add(jComponent2);
    }

    protected void uninstallDefaults() {
        this.spinner.setLayout(null);
    }

    protected void uninstallListeners() {
        this.spinner.removePropertyChangeListener(this.listener);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.uninstallDefaults();
        this.uninstallListeners();
        jComponent.removeAll();
    }

    private final /* synthetic */ void this() {
        this.listener = this.createPropertyChangeListener();
    }

    public BasicSpinnerUI() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class DefaultLayoutManager
    implements LayoutManager {
        private Component editor;
        private Component next;
        private Component previous;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void layoutContainer(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Insets insets = container.getInsets();
                boolean bl = container.getComponentOrientation().isLeftToRight();
                Dimension dimension = this.prefSize(this.editor);
                Dimension dimension2 = this.prefSize(this.next);
                Dimension dimension3 = this.prefSize(this.previous);
                Dimension dimension4 = BasicSpinnerUI.this.spinner.getPreferredSize();
                int n = bl ? insets.left : insets.right;
                int n2 = n;
                int n3 = insets.top;
                int n4 = Math.max(dimension3.width, dimension2.width);
                int n5 = dimension.height / 2;
                int n6 = dimension4.width - n4 - insets.left - insets.right;
                if (bl) {
                    this.setBounds(this.editor, n2, n3, n6, 2 * n5);
                    this.setBounds(this.next, n2 += n6, n3, n4, n5);
                    this.setBounds(this.previous, n2, n3 += n5, n4, n5);
                } else {
                    this.setBounds(this.next, n2, n3 + (dimension4.height - dimension.height) / 2, n4, n5);
                    this.setBounds(this.previous, n2, (n3 += n5) + (dimension4.height - dimension.height) / 2, n4, n5);
                    this.setBounds(this.editor, n2 += n4, n3 -= n5, n6, dimension.height);
                }
                return;
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension;
            Dimension dimension2 = new Dimension();
            if (this.editor != null) {
                Dimension dimension3 = this.editor.getMinimumSize();
                dimension2.width += dimension3.width;
                dimension2.height = dimension3.height;
            }
            int n = 0;
            int n2 = 0;
            if (this.next != null) {
                dimension = this.next.getMinimumSize();
                n = dimension.width;
            }
            if (this.previous != null) {
                dimension = this.previous.getMinimumSize();
                n2 = dimension.width;
            }
            dimension2.width += Math.max(n, n2);
            return dimension2;
        }

        public Dimension preferredLayoutSize(Container container) {
            Cloneable cloneable;
            Dimension dimension = new Dimension();
            if (this.editor != null) {
                Dimension dimension2 = this.editor.getPreferredSize();
                dimension.width += Math.max(dimension2.width, 40);
                dimension.height = dimension2.height;
            }
            int n = 0;
            int n2 = 0;
            if (this.next != null) {
                cloneable = this.next.getPreferredSize();
                n = cloneable.width;
            }
            if (this.previous != null) {
                cloneable = this.previous.getPreferredSize();
                n2 = cloneable.width;
            }
            dimension.width += Math.max(n, n2);
            cloneable = container.getInsets();
            dimension.width = dimension.width + ((Insets)cloneable).left + ((Insets)cloneable).right;
            dimension.height = dimension.height + ((Insets)cloneable).top + ((Insets)cloneable).bottom;
            return dimension;
        }

        public void removeLayoutComponent(Component component) {
            if (component == this.editor) {
                this.editor = null;
            } else if (component == this.next) {
                this.next = null;
            } else if (this.previous == component) {
                this.previous = null;
            }
        }

        public void addLayoutComponent(String string, Component component) {
            if ("Editor".equals(string)) {
                this.editor = component;
            } else if ("Next".equals(string)) {
                this.next = component;
            } else if ("Previous".equals(string)) {
                this.previous = component;
            }
        }

        private final Dimension prefSize(Component component) {
            if (component == null) {
                return new Dimension();
            }
            return component.getPreferredSize();
        }

        private final void setBounds(Component component, int n, int n2, int n3, int n4) {
            if (component != null) {
                component.setBounds(n, n2, n3, n4);
            }
        }

        private DefaultLayoutManager() {
        }
    }
}

