/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import gnu.classpath.SystemProperties;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.UIManager;

class MetalUtils {
    static BufferedImage pattern2D;
    static Color lightColor;
    static Color darkColor;

    static void fillMetalPattern(Component component, Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2) {
        if (graphics instanceof Graphics2D && SystemProperties.getProperty("gnu.javax.swing.noGraphics2D") == null) {
            MetalUtils.fillMetalPattern2D((Graphics2D)graphics, n, n2, n3, n4, color, color2);
        } else {
            int n5 = 0;
            int n6 = n2;
            while (n6 < n2 + n4) {
                if ((n6 - n2) % 2 == 0) {
                    graphics.setColor(color);
                } else {
                    graphics.setColor(color2);
                }
                int n7 = n + n5;
                while (n7 < n + n3) {
                    graphics.drawLine(n7, n6, n7, n6);
                    n7 += 4;
                }
                if (++n5 > 3) {
                    n5 = 0;
                }
                ++n6;
            }
        }
    }

    static void fillMetalPattern2D(Graphics2D graphics2D, int n, int n2, int n3, int n4, Color color, Color color2) {
        if (pattern2D == null || !darkColor.equals(color2) || !lightColor.equals(color)) {
            MetalUtils.initializePattern(color, color2);
        }
        TexturePaint texturePaint = new TexturePaint(pattern2D, new Rectangle2D.Double(0.0, 0.0, 4, 4));
        graphics2D.setPaint(texturePaint);
        graphics2D.fillRect(n, n2, n3, n4);
    }

    static void initializePattern(Color color, Color color2) {
        pattern2D = new BufferedImage(4, 4, 2);
        lightColor = color;
        darkColor = color2;
        Graphics graphics = pattern2D.getGraphics();
        graphics.setColor(color);
        graphics.fillRect(0, 0, 1, 1);
        graphics.fillRect(2, 2, 1, 1);
        graphics.setColor(color2);
        graphics.fillRect(1, 1, 1, 1);
        graphics.fillRect(3, 3, 1, 1);
        graphics.dispose();
    }

    static void paintGradient(Graphics graphics, int n, int n2, int n3, int n4, int n5, String string) {
        MetalUtils.paintGradient(graphics, n, n2, n3, n4, n5, string, null);
    }

    static void paintGradient(Graphics graphics, int n, int n2, int n3, int n4, int n5, String string, int[][] nArray) {
        List list2 = (List)UIManager.get(string);
        float f = ((Float)list2.get(0)).floatValue();
        float f2 = ((Float)list2.get(1)).floatValue();
        Color color = (Color)list2.get(2);
        Color color2 = (Color)list2.get(3);
        Color color3 = (Color)list2.get(4);
        MetalUtils.paintGradient(graphics, n, n2, n3, n4, f, f2, color, color2, color3, n5, nArray);
    }

    static void paintGradient(Graphics graphics, int n, int n2, int n3, int n4, float f, float f2, Color color, Color color2, Color color3, int n5, int[][] nArray) {
        if (n5 == 0) {
            MetalUtils.paintHorizontalGradient(graphics, n, n2, n3, n4, f, f2, color, color2, color3, nArray);
        } else {
            MetalUtils.paintVerticalGradient(graphics, n, n2, n3, n4, f, f2, color, color2, color3, nArray);
        }
    }

    static void paintHorizontalGradient(Graphics graphics, int n, int n2, int n3, int n4, float f, float f2, Color color, Color color2, Color color3, int[][] nArray) {
        Color color4;
        int n5;
        int n6;
        int n7;
        double d;
        int n8 = n2;
        int n9 = n2 + n4;
        int n10 = (int)((float)n3 * f);
        int n11 = (int)((float)n3 * f2);
        int n12 = n;
        int n13 = n12 + n10;
        int n14 = n13 + n11;
        int n15 = n14 + n10;
        int n16 = n + n3;
        int n17 = n12;
        while (n17 < n13) {
            if (n17 > n + n3) break;
            d = (double)(n17 - n12) / (double)n10;
            n7 = (int)((double)(color2.getRed() - color.getRed()) * d + (double)color.getRed());
            n6 = (int)((double)(color2.getGreen() - color.getGreen()) * d + (double)color.getGreen());
            n5 = (int)((double)(color2.getBlue() - color.getBlue()) * d + (double)color.getBlue());
            color4 = new Color(n7, n6, n5);
            graphics.setColor(color4);
            if (nArray != null) {
                n8 = nArray[n17 - n12][0] + n2;
                n9 = nArray[n17 - n12][1] + n2;
            }
            graphics.drawLine(n17, n8, n17, n9);
            ++n17;
        }
        graphics.setColor(color2);
        if (nArray == null) {
            graphics.fillRect(n13, n2, n14 - n13, n4);
        } else {
            n17 = n13;
            while (n17 < n14) {
                n8 = nArray[n17 - n12][0] + n2;
                n9 = nArray[n17 - n12][1] + n2;
                graphics.drawLine(n17, n8, n17, n9);
                ++n17;
            }
        }
        n17 = n14;
        while (n17 < n15) {
            if (n17 > n + n3) break;
            d = (double)(n17 - n14) / (double)n10;
            n7 = (int)((double)(color.getRed() - color2.getRed()) * d + (double)color2.getRed());
            n6 = (int)((double)(color.getGreen() - color2.getGreen()) * d + (double)color2.getGreen());
            n5 = (int)((double)(color.getBlue() - color2.getBlue()) * d + (double)color2.getBlue());
            color4 = new Color(n7, n6, n5);
            graphics.setColor(color4);
            if (nArray != null) {
                n8 = nArray[n17 - n12][0] + n2;
                n9 = nArray[n17 - n12][1] + n2;
            }
            graphics.drawLine(n17, n8, n17, n9);
            ++n17;
        }
        n17 = n15;
        while (n17 < n16) {
            if (n17 > n + n3) break;
            d = (double)(n17 - n15) / (double)(n16 - n15);
            n7 = (int)((double)(color3.getRed() - color.getRed()) * d + (double)color.getRed());
            n6 = (int)((double)(color3.getGreen() - color.getGreen()) * d + (double)color.getGreen());
            n5 = (int)((double)(color3.getBlue() - color.getBlue()) * d + (double)color.getBlue());
            color4 = new Color(n7, n6, n5);
            graphics.setColor(color4);
            if (nArray != null) {
                n8 = nArray[n17 - n12][0] + n2;
                n9 = nArray[n17 - n12][1] + n2;
            }
            graphics.drawLine(n17, n8, n17, n9);
            ++n17;
        }
    }

    static void paintVerticalGradient(Graphics graphics, int n, int n2, int n3, int n4, double d, double d2, Color color, Color color2, Color color3, int[][] nArray) {
        Color color4;
        int n5;
        int n6;
        int n7;
        double d3;
        int n8 = n;
        int n9 = n + n3;
        int n10 = (int)((double)n4 * d);
        int n11 = (int)((double)n4 * d2);
        int n12 = n2;
        int n13 = n12 + n10;
        int n14 = n13 + n11;
        int n15 = n14 + n10;
        int n16 = n2 + n4;
        int n17 = n12;
        while (n17 < n13) {
            if (n17 > n2 + n4) break;
            d3 = (double)(n17 - n12) / (double)n10;
            n7 = (int)((double)(color2.getRed() - color.getRed()) * d3 + (double)color.getRed());
            n6 = (int)((double)(color2.getGreen() - color.getGreen()) * d3 + (double)color.getGreen());
            n5 = (int)((double)(color2.getBlue() - color.getBlue()) * d3 + (double)color.getBlue());
            color4 = new Color(n7, n6, n5);
            graphics.setColor(color4);
            if (nArray != null) {
                n8 = nArray[n17 - n12][0] + n;
                n9 = nArray[n17 - n12][1] + n;
            }
            graphics.drawLine(n8, n17, n9, n17);
            ++n17;
        }
        graphics.setColor(color2);
        if (nArray == null) {
            graphics.fillRect(n, n13, n3, n14 - n13);
        } else {
            n17 = n13;
            while (n17 < n14) {
                n8 = nArray[n17 - n12][0] + n;
                n9 = nArray[n17 - n12][1] + n;
                graphics.drawLine(n8, n17, n9, n17);
                ++n17;
            }
        }
        n17 = n14;
        while (n17 < n15) {
            if (n17 > n2 + n4) break;
            d3 = (double)(n17 - n14) / (double)n10;
            n7 = (int)((double)(color.getRed() - color2.getRed()) * d3 + (double)color2.getRed());
            n6 = (int)((double)(color.getGreen() - color2.getGreen()) * d3 + (double)color2.getGreen());
            n5 = (int)((double)(color.getBlue() - color2.getBlue()) * d3 + (double)color2.getBlue());
            color4 = new Color(n7, n6, n5);
            graphics.setColor(color4);
            if (nArray != null) {
                n8 = nArray[n17 - n12][0] + n;
                n9 = nArray[n17 - n12][1] + n;
            }
            graphics.drawLine(n8, n17, n9, n17);
            ++n17;
        }
        n17 = n15;
        while (n17 < n16) {
            if (n17 > n2 + n4) break;
            d3 = (double)(n17 - n15) / (double)(n16 - n15);
            n7 = (int)((double)(color3.getRed() - color.getRed()) * d3 + (double)color.getRed());
            n6 = (int)((double)(color3.getGreen() - color.getGreen()) * d3 + (double)color.getGreen());
            n5 = (int)((double)(color3.getBlue() - color.getBlue()) * d3 + (double)color.getBlue());
            color4 = new Color(n7, n6, n5);
            graphics.setColor(color4);
            if (nArray != null) {
                n8 = nArray[n17 - n12][0] + n;
                n9 = nArray[n17 - n12][1] + n;
            }
            graphics.drawLine(n8, n17, n9, n17);
            ++n17;
        }
    }

    MetalUtils() {
    }
}

