/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.io.IOException;
import java.io.Reader;

class CSSParser {
    private static final int IDENTIFIER = 1;
    private static final int BRACKET_OPEN = 2;
    private static final int BRACKET_CLOSE = 3;
    private static final int BRACE_OPEN = 4;
    private static final int BRACE_CLOSE = 5;
    private static final int PAREN_OPEN = 6;
    private static final int PAREN_CLOSE = 7;
    private static final int END = -1;
    private static final char[] charMapping = null;
    private boolean didPushChar;
    private int pushedChar;
    private StringBuffer unitBuffer = new StringBuffer();
    private int[] unitStack;
    private int stackCount;
    private Reader reader;
    private boolean encounteredRuleSet;
    private CSSParserCallback callback;
    private char[] tokenBuffer = new char[10];
    private int tokenBufferLength;
    private boolean readWS;

    private final void append(char c) {
        if (this.tokenBuffer.length >= this.tokenBufferLength) {
            char[] cArray = new char[this.tokenBufferLength * 2];
            if (this.tokenBuffer != null) {
                System.arraycopy(this.tokenBuffer, 0, cArray, 0, this.tokenBufferLength);
            }
            cArray[this.tokenBufferLength] = c;
            this.tokenBuffer = cArray;
        } else {
            this.tokenBuffer[this.tokenBufferLength] = c;
        }
        ++this.tokenBufferLength;
    }

    private final int nextToken(char c) throws IOException {
        this.readWS = false;
        int n = this.readWS();
        switch (n) {
            case 34: {
                if (this.tokenBufferLength > 0) {
                    --this.tokenBufferLength;
                }
                return 1;
            }
            case 39: {
                if (this.tokenBufferLength > 0) {
                    --this.tokenBufferLength;
                }
                return 1;
            }
            case 40: {
                return 6;
            }
            case 41: {
                return 7;
            }
            case 123: {
                return 4;
            }
            case 125: {
                return 5;
            }
            case 91: {
                return 2;
            }
            case 93: {
                return 3;
            }
            case -1: {
                return -1;
            }
        }
        this.pushChar(n);
        this.getIdentifier(c);
        return 1;
    }

    private final int readChar() throws IOException {
        if (this.didPushChar) {
            this.didPushChar = false;
            return this.pushedChar;
        }
        return this.reader.read();
    }

    void parse(Reader reader, CSSParserCallback cSSParserCallback, boolean bl) throws IOException {
        this.reader = reader;
        this.callback = cSSParserCallback;
        try {
            if (!bl) {
                while (this.getNextStatement()) {
                }
            } else {
                this.parseDeclarationBlock();
            }
        }
        catch (IOException iOException) {}
    }

    private final int readWS() throws IOException {
        int n = this.readChar();
        while (Character.isWhitespace((char)n)) {
            this.readWS = true;
            int n2 = this.readChar();
            if (n2 == -1) {
                return n;
            }
            n = n2;
        }
        return -1;
    }

    private final boolean getNextStatement() throws IOException {
        int n = this.nextToken('\u0000');
        switch (n) {
            case 2: 
            case 4: 
            case 6: {
                this.parseTillClosed(n);
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                throw new IOException("Not a proper statement.");
            }
            case 1: {
                if (this.tokenBuffer[0] == '@') {
                    this.parseAtRule();
                    break;
                }
                this.parseRuleSet();
                break;
            }
            case -1: {
                return false;
            }
        }
        return true;
    }

    private final void parseAtRule() throws IOException {
    }

    private final void parseRuleSet() throws IOException {
    }

    private final boolean parseSelectors() throws IOException {
        return false;
    }

    private final void parseDeclarationBlock() throws IOException {
    }

    private final int parseDeclaration() throws IOException {
        return 0;
    }

    private final int parseIdentifiers(char c, boolean bl) throws IOException {
        return 0;
    }

    private final void parseTillClosed(int n) throws IOException {
    }

    private final boolean getIdentifier(char c) throws IOException {
        return false;
    }

    private final void readTill(char c) throws IOException {
    }

    private final void readComment() throws IOException {
    }

    private final void startBlock(int n) {
    }

    private final void endBlock(int n) {
    }

    private final boolean inBlock() {
        return false;
    }

    private final void pushChar(int n) throws IOException {
        if (this.didPushChar) {
            throw new IOException("pushChar called twice.");
        }
        this.didPushChar = true;
        this.pushedChar = n;
    }

    CSSParser() {
    }

    static interface CSSParserCallback {
        public void handleImport(String var1);

        public void startRule();

        public void endRule();

        public void handleSelector(String var1);

        public void handleProperty(String var1);

        public void handleValue(String var1);
    }
}

