/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.midi.file;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import javax.sound.midi.Track;
import javax.sound.midi.spi.MidiFileWriter;
import org.tritonus.share.TDebug;

public class StandardMidiFileWriter
extends MidiFileWriter {
    public static boolean USE_RUNNING_STATUS = true;
    public static boolean CANCEL_RUNNING_STATUS_ON_META_AND_SYSEX = true;

    public int[] getMidiFileTypes() {
        int[] nArray = new int[2];
        nArray[1] = 1;
        return nArray;
    }

    public int[] getMidiFileTypes(Sequence sequence) {
        Track[] trackArray = sequence.getTracks();
        if (trackArray.length == 1) {
            return new int[1];
        }
        return new int[]{1};
    }

    public int write(Sequence sequence, int n, OutputStream outputStream) throws IOException {
        if (!this.isFileTypeSupported(n, sequence)) {
            throw new IllegalArgumentException("file type is not supported for this sequence");
        }
        Track[] trackArray = sequence.getTracks();
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeInt(1297377380);
        dataOutputStream.writeInt(6);
        dataOutputStream.writeShort(n);
        dataOutputStream.writeShort(trackArray.length);
        float f = sequence.getDivisionType();
        int n2 = sequence.getResolution();
        int n3 = 0;
        if (f == 0.0f) {
            n3 = n2 & Short.MAX_VALUE;
        }
        dataOutputStream.writeShort(n3);
        int n4 = 14;
        int n5 = 0;
        while (n5 < trackArray.length) {
            n4 += StandardMidiFileWriter.writeTrack(trackArray[n5], dataOutputStream);
            ++n5;
        }
        return n4;
    }

    public int write(Sequence sequence, int n, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        int n2 = this.write(sequence, n, fileOutputStream);
        ((OutputStream)fileOutputStream).close();
        return n2;
    }

    private static final int writeTrack(Track track, DataOutputStream dataOutputStream) throws IOException {
        int n = 0;
        if (dataOutputStream != null) {
            dataOutputStream.writeInt(1297379947);
        }
        int n2 = 0;
        if (dataOutputStream != null) {
            n2 = StandardMidiFileWriter.writeTrack(track, null);
        }
        if (dataOutputStream != null) {
            dataOutputStream.writeInt(n2);
        }
        MidiEvent midiEvent = null;
        int[] nArray = new int[]{-1};
        int n3 = 0;
        while (n3 < track.size()) {
            MidiEvent midiEvent2 = track.get(n3);
            n += StandardMidiFileWriter.writeEvent(midiEvent2, midiEvent, nArray, dataOutputStream);
            midiEvent = midiEvent2;
            ++n3;
        }
        return n;
    }

    private static final int writeEvent(MidiEvent midiEvent, MidiEvent midiEvent2, int[] nArray, DataOutputStream dataOutputStream) throws IOException {
        int n = 0;
        long l = 0L;
        if (midiEvent2 != null) {
            l = midiEvent.getTick() - midiEvent2.getTick();
        }
        if (l < 0L) {
            TDebug.out("StandardMidiFileWriter.writeEvent(): warning: events not in order");
        }
        n += StandardMidiFileWriter.writeVariableLengthQuantity(l, dataOutputStream);
        MidiMessage midiMessage = midiEvent.getMessage();
        if (midiMessage instanceof ShortMessage) {
            n += StandardMidiFileWriter.writeShortMessage((ShortMessage)midiMessage, nArray, dataOutputStream);
        } else if (midiMessage instanceof SysexMessage) {
            n += StandardMidiFileWriter.writeSysexMessage((SysexMessage)midiMessage, nArray, dataOutputStream);
        } else if (midiMessage instanceof MetaMessage) {
            n += StandardMidiFileWriter.writeMetaMessage((MetaMessage)midiMessage, nArray, dataOutputStream);
        } else {
            TDebug.out("StandardMidiFileWriter.writeEvent(): warning: unknown message class");
        }
        return n;
    }

    private static final int writeShortMessage(ShortMessage shortMessage, int[] nArray, DataOutputStream dataOutputStream) throws IOException {
        int n = 0;
        int n2 = shortMessage.getLength();
        if (USE_RUNNING_STATUS && nArray[0] == shortMessage.getStatus()) {
            if (dataOutputStream != null) {
                dataOutputStream.write(shortMessage.getMessage(), 1, n2 - 1);
            }
            n += n2 - 1;
        } else {
            if (dataOutputStream != null) {
                dataOutputStream.write(shortMessage.getMessage(), 0, n2);
            }
            n += n2;
            nArray[0] = shortMessage.getStatus();
        }
        return n;
    }

    private static final int writeSysexMessage(SysexMessage sysexMessage, int[] nArray, DataOutputStream dataOutputStream) throws IOException {
        int n = 0;
        int n2 = sysexMessage.getLength();
        if (CANCEL_RUNNING_STATUS_ON_META_AND_SYSEX) {
            nArray[0] = -1;
        }
        if (dataOutputStream != null) {
            dataOutputStream.write(sysexMessage.getStatus());
        }
        ++n;
        n += StandardMidiFileWriter.writeVariableLengthQuantity(n2 - 1, dataOutputStream);
        if (dataOutputStream != null) {
            dataOutputStream.write(sysexMessage.getData(), 0, n2 - 1);
        }
        return n += n2 - 1;
    }

    private static final int writeMetaMessage(MetaMessage metaMessage, int[] nArray, DataOutputStream dataOutputStream) throws IOException {
        int n = 0;
        byte[] byArray = metaMessage.getData();
        int n2 = byArray.length;
        if (CANCEL_RUNNING_STATUS_ON_META_AND_SYSEX) {
            nArray[0] = -1;
        }
        if (dataOutputStream != null) {
            dataOutputStream.write(metaMessage.getStatus());
            dataOutputStream.write(metaMessage.getType());
        }
        n += 2;
        n += StandardMidiFileWriter.writeVariableLengthQuantity(n2, dataOutputStream);
        if (dataOutputStream != null) {
            dataOutputStream.write(byArray);
        }
        return n += n2;
    }

    private static final int writeVariableLengthQuantity(long l, OutputStream outputStream) throws IOException {
        int n = 0;
        boolean bl = false;
        int n2 = (int)(l >> 21 & 0x7FL);
        if (n2 != 0) {
            if (outputStream != null) {
                outputStream.write(n2 | 0x80);
            }
            ++n;
            bl = true;
        }
        if ((n2 = (int)(l >> 14 & 0x7FL)) != 0 || bl) {
            if (outputStream != null) {
                outputStream.write(n2 | 0x80);
            }
            ++n;
            bl = true;
        }
        if ((n2 = (int)(l >> 7 & 0x7FL)) != 0 || bl) {
            if (outputStream != null) {
                outputStream.write(n2 | 0x80);
            }
            ++n;
        }
        n2 = (int)(l & 0x7FL);
        if (outputStream != null) {
            outputStream.write(n2);
        }
        return ++n;
    }
}

