/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.mixer.alsa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import org.tritonus.lowlevel.alsa.Alsa;
import org.tritonus.lowlevel.alsa.AlsaPcm;
import org.tritonus.lowlevel.alsa.AlsaPcmHWParams;
import org.tritonus.lowlevel.alsa.AlsaPcmHWParamsFormatMask;
import org.tritonus.sampled.mixer.alsa.AlsaSourceDataLine;
import org.tritonus.sampled.mixer.alsa.AlsaTargetDataLine;
import org.tritonus.sampled.mixer.alsa.AlsaUtils;
import org.tritonus.share.GlobalInfo;
import org.tritonus.share.TDebug;
import org.tritonus.share.TSettings;
import org.tritonus.share.sampled.mixer.TMixer;
import org.tritonus.share.sampled.mixer.TMixerInfo;
import org.tritonus.share.sampled.mixer.TSoftClip;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AlsaDataLineMixer
extends TMixer {
    private static final AudioFormat[] EMPTY_AUDIOFORMAT_ARRAY = new AudioFormat[0];
    private static final int CHANNELS_LIMIT = 32;
    private static final int DEFAULT_BUFFER_SIZE = 32768;
    private String m_strPcmName;
    static /* synthetic */ Class class$javax$sound$sampled$Mixer;
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;
    static /* synthetic */ Class class$javax$sound$sampled$TargetDataLine;

    public static String getDeviceNamePrefix() {
        if (TSettings.AlsaUsePlughw) {
            return "plughw";
        }
        return "hw";
    }

    public static String getPcmName(int n) {
        String string = AlsaDataLineMixer.getDeviceNamePrefix() + ':' + n;
        return string;
    }

    public String getPcmName() {
        return this.m_strPcmName;
    }

    public void open() {
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.open(): begin");
        }
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.open(): end");
        }
    }

    public void close() {
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.close(): begin");
        }
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.close(): end");
        }
    }

    public int getMaxLines(Line.Info info) {
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.getMaxLines(): begin");
        }
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.getMaxLines(): end");
        }
        return 0;
    }

    protected SourceDataLine getSourceDataLine(AudioFormat audioFormat, int n) throws LineUnavailableException {
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.getSourceDataLine(): begin");
        }
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.getSourceDataLine(): format: " + audioFormat);
            TDebug.out("AlsaDataLineMixer.getSourceDataLine(): buffer size: " + n);
        }
        if (n < 1) {
            n = 32768;
        }
        AlsaSourceDataLine alsaSourceDataLine = new AlsaSourceDataLine(this, audioFormat, n);
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.getSourceDataLine(): returning: " + alsaSourceDataLine);
        }
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.getSourceDataLine(): end");
        }
        return alsaSourceDataLine;
    }

    protected TargetDataLine getTargetDataLine(AudioFormat audioFormat, int n) throws LineUnavailableException {
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.getTargetDataLine(): begin");
        }
        int n2 = n * audioFormat.getFrameSize();
        AlsaTargetDataLine alsaTargetDataLine = new AlsaTargetDataLine(this, audioFormat, n2);
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.getTargetDataLine(): returning: " + alsaTargetDataLine);
        }
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.getTargetDataLine(): end");
        }
        return alsaTargetDataLine;
    }

    protected Clip getClip(AudioFormat audioFormat) throws LineUnavailableException {
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.getClip(): begin");
        }
        TSoftClip tSoftClip = new TSoftClip((Mixer)this, audioFormat);
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.getClip(): end");
        }
        return tSoftClip;
    }

    private final List getSupportedFormats(int n) {
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.getSupportedFormats(): begin");
        }
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.getSupportedFormats(): direction: " + n);
        }
        ArrayList arrayList = new ArrayList();
        AlsaPcm alsaPcm = null;
        try {
            alsaPcm = new AlsaPcm(this.getPcmName(), n, 0);
        }
        catch (Exception exception) {
            if (TDebug.TraceAllExceptions) {
                TDebug.out(exception);
            }
            throw new RuntimeException("cannot open pcm");
        }
        AlsaPcmHWParams alsaPcmHWParams = new AlsaPcmHWParams();
        int n2 = alsaPcm.getAnyHWParams(alsaPcmHWParams);
        if (n2 != 0) {
            TDebug.out("AlsaDataLineMixer.getSupportedFormats(): getAnyHWParams(): " + Alsa.getStringError(n2));
            throw new RuntimeException(Alsa.getStringError(n2));
        }
        AlsaPcmHWParamsFormatMask alsaPcmHWParamsFormatMask = new AlsaPcmHWParamsFormatMask();
        int n3 = alsaPcmHWParams.getChannelsMin();
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.getSupportedFormats(): min channels: " + n3);
        }
        int n4 = alsaPcmHWParams.getChannelsMax();
        n4 = Math.min(n4, 32);
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.getSupportedFormats(): max channels: " + n4);
        }
        alsaPcmHWParams.getFormatMask(alsaPcmHWParamsFormatMask);
        int n5 = 0;
        while (n5 < 32) {
            if (TDebug.TraceMixer) {
                TDebug.out("AlsaDataLineMixer.getSupportedFormats(): checking ALSA format index: " + n5);
            }
            if (alsaPcmHWParamsFormatMask.test(n5)) {
                if (TDebug.TraceMixer) {
                    TDebug.out("AlsaDataLineMixer.getSupportedFormats(): ...supported");
                }
                AudioFormat audioFormat = AlsaUtils.getAlsaFormat(n5);
                if (TDebug.TraceMixer) {
                    TDebug.out("AlsaDataLineMixer.getSupportedFormats(): adding AudioFormat: " + audioFormat);
                }
                AlsaDataLineMixer.addChanneledAudioFormats(arrayList, audioFormat, n3, n4);
            } else if (TDebug.TraceMixer) {
                TDebug.out("AlsaDataLineMixer.getSupportedFormats(): ...not supported");
            }
            ++n5;
        }
        alsaPcm.close();
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.getSupportedFormats(): end");
        }
        return arrayList;
    }

    private static final void addChanneledAudioFormats(Collection collection, AudioFormat audioFormat, int n, int n2) {
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.addChanneledAudioFormats(): begin");
        }
        int n3 = n;
        while (n3 <= n2) {
            AudioFormat audioFormat2 = AlsaDataLineMixer.getChanneledAudioFormat(audioFormat, n3);
            if (TDebug.TraceMixer) {
                TDebug.out("AlsaDataLineMixer.addChanneledAudioFormats(): adding AudioFormat: " + audioFormat2);
            }
            collection.add(audioFormat2);
            ++n3;
        }
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.addChanneledAudioFormats(): end");
        }
    }

    private static final AudioFormat getChanneledAudioFormat(AudioFormat audioFormat, int n) {
        AudioFormat audioFormat2 = new AudioFormat(audioFormat.getEncoding(), audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), n, audioFormat.getSampleSizeInBits() / 8 * n, audioFormat.getFrameRate(), audioFormat.isBigEndian());
        return audioFormat2;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public AlsaDataLineMixer() {
        this(0);
    }

    public AlsaDataLineMixer(int n) {
        this(AlsaDataLineMixer.getPcmName(n));
    }

    public AlsaDataLineMixer(String string) {
        TMixerInfo tMixerInfo = new TMixerInfo("Alsa DataLine Mixer (" + string + ')', GlobalInfo.getVendor(), "Mixer for the Advanced Linux Sound Architecture (card " + string + ')', GlobalInfo.getVersion());
        Class clazz = class$javax$sound$sampled$Mixer;
        if (clazz == null) {
            clazz = class$javax$sound$sampled$Mixer = AlsaDataLineMixer.class("[Ljavax.sound.sampled.Mixer;", false);
        }
        super(tMixerInfo, new Line.Info(clazz));
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.<init>(String): begin.");
        }
        this.m_strPcmName = string;
        List list2 = this.getSupportedFormats(0);
        List list3 = this.getSupportedFormats(1);
        ArrayList arrayList = new ArrayList();
        Class clazz2 = class$javax$sound$sampled$SourceDataLine;
        if (clazz2 == null) {
            clazz2 = class$javax$sound$sampled$SourceDataLine = AlsaDataLineMixer.class("[Ljavax.sound.sampled.SourceDataLine;", false);
        }
        DataLine.Info info = new DataLine.Info(clazz2, (AudioFormat[])list2.toArray(EMPTY_AUDIOFORMAT_ARRAY), -1, -1);
        arrayList.add(info);
        ArrayList arrayList2 = new ArrayList();
        Class clazz3 = class$javax$sound$sampled$TargetDataLine;
        if (clazz3 == null) {
            clazz3 = class$javax$sound$sampled$TargetDataLine = AlsaDataLineMixer.class("[Ljavax.sound.sampled.TargetDataLine;", false);
        }
        DataLine.Info info2 = new DataLine.Info(clazz3, (AudioFormat[])list3.toArray(EMPTY_AUDIOFORMAT_ARRAY), -1, -1);
        arrayList2.add(info2);
        this.setSupportInformation(list2, list3, arrayList, arrayList2);
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.<init>(String): end.");
        }
    }
}

