/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.jackrabbit.util;

import java.io.File;
import java.io.IOException;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class TransientFileFactory {
    private static TransientFileFactory INSTANCE;
    private ReferenceQueue phantomRefQueue = new ReferenceQueue();
    private Collection trackedRefs = Collections.synchronizedList(new ArrayList());
    private final Thread reaper = new ReaperThread("Transient File Reaper");
    private static Thread shutdownHook;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TransientFileFactory getInstance() {
        Class clazz = TransientFileFactory.class;
        synchronized (clazz) {
            if (INSTANCE == null) {
                INSTANCE = new TransientFileFactory();
            }
            return INSTANCE;
        }
    }

    private TransientFileFactory() {
        this.reaper.setPriority(1);
        this.reaper.setDaemon(true);
        this.reaper.start();
        try {
            shutdownHook = new Thread(){

                public void run() {
                    TransientFileFactory.this.doShutdown();
                }
            };
            Runtime.getRuntime().addShutdownHook(shutdownHook);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public File createTransientFile(String prefix, String suffix, File directory) throws IOException {
        File f = File.createTempFile(prefix, suffix, directory);
        this.trackedRefs.add(new MoribundFileReference(f, this.phantomRefQueue));
        return f;
    }

    public static void shutdown() {
        TransientFileFactory.getInstance().doShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doShutdown() {
        Collection collection = this.trackedRefs;
        synchronized (collection) {
            Iterator it = this.trackedRefs.iterator();
            while (it.hasNext()) {
                MoribundFileReference fileRef = (MoribundFileReference)it.next();
                fileRef.delete();
            }
        }
        if (shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(shutdownHook);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    static {
        shutdownHook = null;
    }

    private class MoribundFileReference
    extends PhantomReference {
        private String path;

        MoribundFileReference(File file, ReferenceQueue queue) {
            super(file, queue);
            this.path = file.getPath();
        }

        boolean delete() {
            return new File(this.path).delete();
        }
    }

    private class ReaperThread
    extends Thread {
        ReaperThread(String name) {
            super(name);
        }

        public void run() {
            while (true) {
                MoribundFileReference fileRef = null;
                try {
                    fileRef = (MoribundFileReference)TransientFileFactory.this.phantomRefQueue.remove();
                }
                catch (Exception e) {
                    continue;
                }
                fileRef.delete();
                fileRef.clear();
                TransientFileFactory.this.trackedRefs.remove(fileRef);
            }
        }
    }
}

