# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Authors: Guido Amoruso <guidonte@fluendo.com>
#          Olivier Tilloy <olivier@fluendo.com>


from elisa.core.utils.i18n import install_translation
from elisa.core.action import ContextualAction


_ = install_translation('poblesec')


class Action(object):
    """Contextul action for a Controller object.

    The intended use is for controllers to subclass this and override the run()
    method, that can do everything you want, assuming to deal with a specific
    controller class.

    @ivar controller: the controller on which to run the action
    @type controller: L{elisa.plugins.pigment.pigment_controller.PigmentController}
    """

    icon = ''
    title = ''
    subtitle = ''

    def __init__(self, controller):
        self.controller = controller

    def run(self):
        raise NotImplementedError()


class ActionPathNotSetError(Exception):
    pass


class LinkAction(Action):
    crumb_title = None
    path = None
    args = {}

    def run(self):
        if self.path is None:
            raise ActionPathNotSetError()

        crumb_title = self.crumb_title
        if crumb_title is None:
            crumb_title = self.title

        browser = self.controller.frontend.retrieve_controllers('/poblesec/browser')[0]
        dfr = browser.history.append_controller(self.path, crumb_title,
                                                **self.args)

        return dfr


###############################################################################
#
# NEW GENERATION CONTEXTUAL ACTIONS
#
###############################################################################


class OpenControllerAction(ContextualAction):

    label = _('Open')

    def __init__(self, controller, path):
        super(OpenControllerAction, self).__init__(controller)
        self.path = path

    def open_controller(self, path, title, *args, **kwargs):
        """
        DOCME
        """
        browser = self.controller.frontend.retrieve_controllers('/poblesec/browser')[0]
        return browser.history.append_controller(path, title, *args, **kwargs)

    def execute(self, item):
        # Default implementation
        return self.open_controller(self.path, '')
