/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;

public class DateTimeConverter
implements Converter,
StateHolder {
    public static final String CONVERTER_ID = "javax.faces.DateTime";
    private static final TimeZone DEFAULT_TIME_ZONE = TimeZone.getTimeZone("GMT");
    private String dateStyle = "default";
    private Locale locale = null;
    private String pattern = null;
    private String timeStyle = "default";
    private TimeZone timeZone = DEFAULT_TIME_ZONE;
    private String type = "date";
    private boolean transientFlag = false;

    public String getDateStyle() {
        return this.dateStyle;
    }

    public void setDateStyle(String dateStyle) {
        this.dateStyle = dateStyle;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = this.getLocale(FacesContext.getCurrentInstance());
        }
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getTimeStyle() {
        return this.timeStyle;
    }

    public void setTimeStyle(String timeStyle) {
        this.timeStyle = timeStyle;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        try {
            if (value == null) {
                return null;
            }
            if ((value = value.trim()).length() < 1) {
                return null;
            }
            Locale locale = this.getLocale(context);
            DateFormat parser = this.getDateFormat(context, locale);
            if (null != this.timeZone) {
                parser.setTimeZone(this.timeZone);
            }
            return parser.parse(value);
        }
        catch (ConverterException e) {
            throw e;
        }
        catch (ParseException e) {
            throw new ConverterException("Error parsing '" + value + "'");
        }
        catch (Exception e) {
            throw new ConverterException(e);
        }
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        try {
            if (value == null) {
                return "";
            }
            if (value instanceof String) {
                return (String)value;
            }
            Locale locale = this.getLocale(context);
            DateFormat formatter = this.getDateFormat(context, locale);
            if (null != this.timeZone) {
                formatter.setTimeZone(this.timeZone);
            }
            return formatter.format(value);
        }
        catch (ConverterException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConverterException(e);
        }
    }

    private DateFormat getDateFormat(FacesContext context, Locale locale) {
        if (this.pattern == null && this.type == null) {
            throw new IllegalArgumentException("Either pattern or type must be specified.");
        }
        DateFormat df = null;
        if (this.pattern != null) {
            df = new SimpleDateFormat(this.pattern, locale);
        } else if (this.type.equals("both")) {
            df = DateFormat.getDateTimeInstance(this.getStyle(this.dateStyle), this.getStyle(this.timeStyle), locale);
        } else if (this.type.equals("date")) {
            df = DateFormat.getDateInstance(this.getStyle(this.dateStyle), locale);
        } else if (this.type.equals("time")) {
            df = DateFormat.getTimeInstance(this.getStyle(this.timeStyle), locale);
        } else {
            throw new IllegalArgumentException("Invalid type: " + this.type);
        }
        df.setLenient(false);
        return df;
    }

    private Locale getLocale(FacesContext context) {
        Locale locale = this.locale;
        if (locale == null) {
            locale = context.getViewRoot().getLocale();
        }
        return locale;
    }

    private int getStyle(String name) {
        if (name.equals("default")) {
            return 2;
        }
        if (name.equals("short")) {
            return 3;
        }
        if (name.equals("medium")) {
            return 2;
        }
        if (name.equals("long")) {
            return 1;
        }
        if (name.equals("full")) {
            return 0;
        }
        throw new ConverterException("Invalid style '" + name + "'");
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.dateStyle, this.locale, this.pattern, this.timeStyle, this.timeZone, this.type};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.dateStyle = (String)values[0];
        this.locale = (Locale)values[1];
        this.pattern = (String)values[2];
        this.timeStyle = (String)values[3];
        this.timeZone = (TimeZone)values[4];
        this.type = (String)values[5];
    }

    public boolean isTransient() {
        return this.transientFlag;
    }

    public void setTransient(boolean transientFlag) {
        this.transientFlag = transientFlag;
    }
}

