/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.modules.persistence.mapping.core.ui.wizard.relationship;

import com.sun.jdo.modules.persistence.mapping.core.ui.wizard.relationship.MapToKeyStep;
import com.sun.jdo.modules.persistence.mapping.core.util.DBListElement;
import com.sun.jdo.modules.persistence.mapping.core.util.MappingContext;
import com.sun.jdo.spi.persistence.utility.ui.SwingUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;

public class RelationshipTablePanel
extends JPanel {
    public static final int NO_JOIN = 0;
    public static final int JOIN_LOCAL = 1;
    public static final int JOIN_FOREIGN = 2;
    static final int LOCAL = 0;
    static final int JOIN = 1;
    static final int FOREIGN = 2;
    int tableType;
    MapToKeyStep impl;
    DefaultTableModel mappingTableModel;
    private JScrollPane mappingTableScrollPane;
    private JTable mappingTable;
    private JLabel imageLabel;
    private JButton addButton;
    private JButton removeButton;

    public RelationshipTablePanel(int type, MapToKeyStep impl) {
        this.tableType = type;
        this.impl = impl;
        this.initComponents();
        this.mappingTableScrollPane.getViewport().setBackground(this.mappingTable.getBackground());
        this.mappingTableModel = this.buildTable();
        SwingUtils.autosizeTableColumnWidths(this.mappingTable);
    }

    private void initComponents() {
        MappingContext mappingContext = this.getImpl().getMappingContext();
        JLabel mappingLabel = new JLabel();
        this.mappingTableScrollPane = new JScrollPane();
        this.mappingTable = new JTable();
        JPanel buttonPanel = new JPanel();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        JPanel imagePanel = new JPanel();
        this.imageLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        mappingLabel.setText(mappingContext.getString("LBL_Key_Column_Pairs"));
        mappingLabel.setDisplayedMnemonic(mappingContext.getMnemonic("LBL_Mnemonic_Key_Column_Pairs"));
        mappingLabel.setLabelFor(this.mappingTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.add((Component)mappingLabel, gridBagConstraints);
        this.mappingTableScrollPane.setPreferredSize(new Dimension(400, 60));
        this.mappingTableScrollPane.setMinimumSize(new Dimension(400, 60));
        this.mappingTable.setPreferredSize(new Dimension(400, 60));
        this.mappingTable.setPreferredScrollableViewportSize(new Dimension(400, 60));
        this.mappingTableScrollPane.setViewportView(this.mappingTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.add((Component)this.mappingTableScrollPane, gridBagConstraints);
        buttonPanel.setLayout(new FlowLayout(0));
        this.addButton.setMnemonic(mappingContext.getMnemonic("CTL_Mnemonic_ADD_PAIR"));
        this.addButton.setText(mappingContext.getString("CTL_ADD_PAIR"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RelationshipTablePanel.this.addButtonActionPerformed(evt);
            }
        });
        buttonPanel.add(this.addButton);
        this.removeButton.setMnemonic(mappingContext.getMnemonic("CTL_Mnemonic_REMOVE"));
        this.removeButton.setText(mappingContext.getString("CTL_REMOVE"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RelationshipTablePanel.this.removeButtonActionPerformed(evt);
            }
        });
        buttonPanel.add(this.removeButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 5, 10);
        this.add((Component)buttonPanel, gridBagConstraints);
        imagePanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        imagePanel.add((Component)this.imageLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.add((Component)imagePanel, gridBagConstraints);
    }

    String[][] getColumnHeader() {
        MappingContext context = this.getImpl().getMappingContext();
        return new String[][]{{context.getString("HD_Local_Column"), context.getString("HD_Foreign_Column")}, {context.getString("HD_Local_Column"), context.getString("HD_Join_Column")}, {context.getString("HD_Join_Column"), context.getString("HD_Foreign_Column")}};
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int count;
        int[] rows = this.mappingTable.getSelectedRows();
        int n = count = rows != null ? rows.length : 0;
        if (this.mappingTable.isEditing()) {
            this.mappingTable.editingStopped(new ChangeEvent(this));
        }
        this.mappingTable.clearSelection();
        for (int i = count - 1; i >= 0; --i) {
            this.mappingTableModel.removeRow(rows[i]);
        }
        if (rows != null && rows.length > 0) {
            SwingUtils.autosizeTable(this.mappingTable);
            SwingUtils.selectNearestRow(this.mappingTable, rows[0]);
            SwingUtils.scrollSelectedToVisible(this.mappingTable);
        }
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        this.insertRow();
        SwingUtils.autosizeTable(this.mappingTable);
        this.selectAndFocusPair();
    }

    public void selectAndFocusPair() {
        int idx = this.mappingTable.getRowCount() - 1;
        this.mappingTable.setRowSelectionInterval(idx, idx);
        SwingUtils.scrollSelectedToVisible(this.mappingTable);
        this.mappingTable.requestFocus();
    }

    private void processInsert(TableModelEvent evt) {
        if (this.impl != null) {
            this.impl.processInsert(evt);
        }
    }

    private void processUpdate(TableModelEvent evt) {
        if (this.impl != null) {
            this.impl.processUpdate(evt);
        }
    }

    private void processDelete(TableModelEvent evt) {
        if (this.impl != null) {
            this.impl.processDelete(evt);
        }
    }

    private DefaultTableModel buildTable() {
        DefaultTableModel tableModel = new DefaultTableModel(this.getColumnHeader()[this.tableType], 0);
        this.mappingTable.setModel(tableModel);
        this.mappingTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                RelationshipTablePanel.this.setButtonStates();
            }
        });
        tableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent evt) {
                if (evt.getType() == 1) {
                    RelationshipTablePanel.this.processInsert(evt);
                } else if (evt.getType() == 0) {
                    RelationshipTablePanel.this.processUpdate(evt);
                } else if (evt.getType() == -1) {
                    RelationshipTablePanel.this.processDelete(evt);
                }
            }
        });
        return tableModel;
    }

    void clearTable() {
        int rowCount = this.mappingTableModel.getRowCount();
        if (this.mappingTable.isEditing()) {
            this.mappingTable.editingStopped(new ChangeEvent(this));
        }
        for (int i = 0; i < rowCount; ++i) {
            this.mappingTableModel.removeRow(0);
        }
    }

    void insertRow() {
        DBListElement chooseElement = new DBListElement(this.getImpl().getMappingContext().getString("VALUE_column"));
        this.mappingTableModel.addRow(new Object[]{chooseElement, chooseElement});
    }

    public void setButtonStates() {
        if (this.impl != null) {
            this.impl.setButtonStates();
        }
    }

    public void setButtonStates(boolean btnState) {
        if (!btnState) {
            this.addButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        } else {
            this.addButton.setEnabled(true);
            if (this.mappingTable.getRowCount() == 0 || this.mappingTable.getSelectedRow() == -1) {
                this.removeButton.setEnabled(false);
            } else {
                this.removeButton.setEnabled(true);
            }
        }
    }

    public void setImpl(MapToKeyStep p) {
        this.impl = p;
    }

    public MapToKeyStep getImpl() {
        return this.impl;
    }

    public void setTableType(int type) {
        this.tableType = type;
    }

    public int getTableType() {
        return this.tableType;
    }

    public JTable getMappingTable() {
        return this.mappingTable;
    }

    public DefaultTableModel getMappingTableModel() {
        return this.mappingTableModel;
    }

    public void setImage(ImageIcon icon) {
        this.imageLabel.setIcon(icon);
    }
}

