/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.modules.persistence.mapping.core.util;

import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.spi.persistence.utility.MergedBundle;
import com.sun.jdo.spi.persistence.utility.logging.LogHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import com.sun.jdo.spi.persistence.utility.openide.HelpUtils;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.help.HelpSet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class MappingContext {
    protected static final String _componentName = "mapping.module";
    private static final String _baseName = "com.sun.jdo.modules.persistence.mapping.core.resources.Bundle";
    private static final String _baseHelp = "Services/JavaHelp/com-sun-jdo-modules-persistence-mapping-core-helpset.xml";
    private static final String _baseHelpURL = "com/sun/jdo/modules/persistence/docs/tp";
    private static HelpSet _parentHelp;
    private final Model _model;
    private final String _brandingSuffix;
    private final boolean _isJDOExposed;
    private final ResourceBundle _bundle;
    private final ClassLoader _classLoader;

    protected MappingContext(Model model) {
        this(model, null, MappingContext.class.getClassLoader());
    }

    protected MappingContext(Model model, String brandingSuffix, ClassLoader classLoader) {
        this(model, brandingSuffix, true, classLoader);
    }

    protected MappingContext(Model model, String brandingSuffix, boolean isJDOExposed, ClassLoader classLoader) {
        this._model = model;
        this._brandingSuffix = brandingSuffix;
        this._isJDOExposed = isJDOExposed;
        this._classLoader = classLoader;
        this._bundle = this.getBrandedBundle(_baseName);
    }

    public Model getModel() {
        return this._model;
    }

    public String getBrandingSuffix() {
        return this._brandingSuffix;
    }

    public boolean isJDOExposed() {
        return this._isJDOExposed;
    }

    public ResourceBundle getBrandedBundle(String baseName) {
        ResourceBundle bundle = NbBundle.getBundle((String)baseName);
        if (this._brandingSuffix != null) {
            ResourceBundle extraBundle = null;
            try {
                extraBundle = NbBundle.getBundle((String)(baseName + '_' + this._brandingSuffix), (Locale)Locale.getDefault(), (ClassLoader)this._classLoader);
            }
            catch (MissingResourceException e) {
                String message = MessageFormat.format(bundle.getString("mapping.module.context.extra_bundle_not_found"), this._brandingSuffix);
                this.getLogger().log(900, message, e);
            }
            if (extraBundle != null) {
                bundle = new MergedBundle(extraBundle, bundle);
            }
        }
        return bundle;
    }

    public String getString(String key) {
        return this._bundle.getString(key);
    }

    public char getMnemonic(String key) {
        return this.getString(key).trim().charAt(0);
    }

    public Logger getLogger() {
        return LogHelper.getLogger(_componentName, _baseName, MappingContext.class.getClassLoader());
    }

    public static synchronized HelpSet getHelpSet() {
        if (_parentHelp == null) {
            _parentHelp = HelpUtils.getHelpSet(_baseHelp, _baseHelpURL);
        }
        return _parentHelp;
    }

    public String getHelpID(Object key) {
        String brandedKey;
        String keyString;
        String string = keyString = key instanceof String ? (String)key : key.getClass().getName();
        if (this._brandingSuffix != null && HelpUtils.isValidHelpID(brandedKey = keyString + '_' + this._brandingSuffix, MappingContext.getHelpSet())) {
            return HelpUtils.getHelpID(brandedKey);
        }
        return HelpUtils.getHelpID(keyString);
    }

    public HelpCtx getHelpCtx(Object obj) {
        return HelpUtils.getHelpCtx(this.getHelpID(obj));
    }
}

