/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.modules.persistence.mapping.ejb.ui.panels;

import com.sun.jdo.api.persistence.mapping.core.ClassState;
import com.sun.jdo.api.persistence.mapping.core.TableState;
import com.sun.jdo.api.persistence.mapping.ejb.EJBInfoHelper;
import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.api.persistence.model.jdo.PersistenceClassElement;
import com.sun.jdo.api.persistence.model.jdo.RelationshipElement;
import com.sun.jdo.modules.persistence.mapping.core.util.MappingContext;
import com.sun.jdo.modules.persistence.mapping.core.util.Util;
import com.sun.jdo.modules.persistence.mapping.ejb.util.SunOneUtilsCMP;
import com.sun.jdo.spi.persistence.utility.StringHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.dbschema.util.NameUtil;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CreateFieldMappings
extends JPanel {
    private static final ResourceBundle bundle = NbBundle.getBundle((Class)CreateFieldMappings.class);
    private static final String BEAN_SUFFIX1 = "bean";
    private static final String BEAN_SUFFIX2 = "eb";
    private static final String EMPTY_STRING = bundle.getString("CFM_choose_schema");
    private MappingContext mappingContext;
    private Model model;
    private EJBInfoHelper infoHelper;
    private String cmpResourceJndiName;
    private List beansList;
    private List classStateList;
    private boolean noSchemaInJar;
    private boolean continueNeeded = false;
    private String[] dbVendorNames = new String[]{"DB2", "Generic SQL92", "MSSQL", "Oracle", "PointBase", "Sybase"};
    private final String DEFAULT_VENDOR_NAME = "PointBase";
    private ButtonGroup buttonGroup1;
    private JComboBox dbSchemaComboBox;
    private JLabel dbSchemaLabel;
    private JRadioButton generateTableRButton;
    private JCheckBox generateUnique;
    private JLabel jLabel1;
    private JTextArea jTextArea1;
    private JRadioButton mapToDbRButton;
    private JComboBox vendorComboBox;

    public CreateFieldMappings(MappingContext _mappingContext, EJBInfoHelper ebd, String resourceJndi, List beans) {
        this.mappingContext = _mappingContext;
        this.model = this.mappingContext.getModel();
        this.infoHelper = ebd;
        this.cmpResourceJndiName = resourceJndi;
        this.beansList = beans;
        this.initComponents();
        this.initAccessibility();
        HelpCtx.setHelpIDString((JComponent)this, (String)bundle.getString("HelpID_Create_Field_Mappings"));
        if (SunOneUtilsCMP.isSchemaGeneratorProperty(this.infoHelper, "use-unique-table-names")) {
            this.generateUnique.setSelected(true);
        } else {
            this.generateUnique.setSelected(false);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jTextArea1 = new JTextArea();
        this.generateTableRButton = new JRadioButton();
        this.mapToDbRButton = new JRadioButton();
        this.dbSchemaLabel = new JLabel();
        this.dbSchemaComboBox = new JComboBox();
        this.generateUnique = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.vendorComboBox = new JComboBox<String>(this.dbVendorNames);
        this.vendorComboBox.setSelectedItem("PointBase");
        this.setLayout(new GridBagLayout());
        this.jTextArea1.setBackground((Color)UIManager.getDefaults().get("Label.background"));
        this.jTextArea1.setColumns(50);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setFont(UIManager.getFont("Label.font"));
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(4);
        this.jTextArea1.setText(bundle.getString("CFM_MSG_1"));
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setMinimumSize(new Dimension(450, 60));
        this.jTextArea1.setPreferredSize(new Dimension(550, 100));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.insets = new Insets(14, 10, 10, 10);
        this.add((Component)this.jTextArea1, gridBagConstraints);
        this.generateTableRButton.setFont(new Font("Dialog", 0, 12));
        this.generateTableRButton.setMnemonic(bundle.getString("CFM_LBL_Mnemonic_generate_table").trim().charAt(0));
        this.generateTableRButton.setSelected(true);
        this.generateTableRButton.setText(bundle.getString("CFM_LBL_generate_table"));
        this.generateTableRButton.setToolTipText(bundle.getString("CFM_TT_generate_table"));
        this.buttonGroup1.add(this.generateTableRButton);
        this.generateTableRButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                CreateFieldMappings.this.generateTableRButtonItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        this.add((Component)this.generateTableRButton, gridBagConstraints);
        this.mapToDbRButton.setFont(new Font("Dialog", 0, 12));
        this.mapToDbRButton.setMnemonic(bundle.getString("CFM_LBL_Mnemonic_map_to_table").trim().charAt(0));
        this.mapToDbRButton.setText(bundle.getString("CFM_LBL_map_to_table"));
        this.mapToDbRButton.setToolTipText(bundle.getString("CFM_TT_map_to_table"));
        this.buttonGroup1.add(this.mapToDbRButton);
        this.mapToDbRButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                CreateFieldMappings.this.mapToDbRButtonItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)this.mapToDbRButton, gridBagConstraints);
        this.dbSchemaLabel.setDisplayedMnemonic(bundle.getString("CFM_LBL_Mnemonic_schema_files").trim().charAt(0));
        this.dbSchemaLabel.setFont(new Font("Dialog", 0, 12));
        this.dbSchemaLabel.setLabelFor(this.dbSchemaComboBox);
        this.dbSchemaLabel.setText(bundle.getString("CFM_LBL_schema_files"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 50, 0, 10);
        this.add((Component)this.dbSchemaLabel, gridBagConstraints);
        this.dbSchemaComboBox.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 50, 11, 10);
        this.add((Component)this.dbSchemaComboBox, gridBagConstraints);
        this.generateUnique.setMnemonic(bundle.getString("TGS_gen_unique_table_name_mn").trim().charAt(0));
        this.generateUnique.setText(ResourceBundle.getBundle("com/sun/jdo/modules/persistence/mapping/ejb/ui/panels/Bundle").getString("TGS_gen_unique_table_name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 50, 5, 0);
        this.add((Component)this.generateUnique, gridBagConstraints);
        this.jLabel1.setDisplayedMnemonic(bundle.getString("CF_LBL_Mnemonic_datasource_vendor").trim().charAt(0));
        this.jLabel1.setLabelFor(this.vendorComboBox);
        this.jLabel1.setText(ResourceBundle.getBundle("com/sun/jdo/modules/persistence/mapping/ejb/ui/panels/Bundle").getString("CF_LBL_datasource_vendor"));
        this.jLabel1.setToolTipText(ResourceBundle.getBundle("com/sun/jdo/modules/persistence/mapping/ejb/ui/panels/Bundle").getString("CF_TT_datasource_vendor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 50, 5, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 50, 10, 0);
        this.add((Component)this.vendorComboBox, gridBagConstraints);
    }

    private void mapToDbRButtonItemStateChanged(ItemEvent evt) {
        if (this.mapToDbRButton.isSelected()) {
            if (!this.noSchemaInJar) {
                this.dbSchemaComboBox.setEnabled(true);
            }
            this.generateUnique.setEnabled(false);
            this.vendorComboBox.setEnabled(false);
        }
    }

    private void generateTableRButtonItemStateChanged(ItemEvent evt) {
        if (this.generateTableRButton.isSelected()) {
            this.dbSchemaComboBox.setEnabled(false);
            this.generateUnique.setEnabled(true);
            this.vendorComboBox.setEnabled(true);
        }
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("CFM_MSG_accessibility"));
    }

    public void setSchemaFiles(List dbSchemaFiles) {
        if (dbSchemaFiles == null || dbSchemaFiles.size() == 0) {
            this.noSchemaInJar = true;
            this.dbSchemaComboBox.addItem(bundle.getString("CFM_no_schema_in_jar"));
            this.dbSchemaComboBox.setEnabled(false);
        } else {
            this.noSchemaInJar = false;
            Collections.sort(dbSchemaFiles);
            Vector<String> v = new Vector<String>();
            v.add(EMPTY_STRING);
            v.addAll(dbSchemaFiles);
            DefaultComboBoxModel model = new DefaultComboBoxModel(v);
            this.dbSchemaComboBox.setModel(model);
            this.dbSchemaComboBox.setSelectedItem(EMPTY_STRING);
        }
    }

    public boolean showAsDialog() {
        this.continueNeeded = false;
        String title = MessageFormat.format(bundle.getString("CFM_title"), this.infoHelper.getEjbJarDisplayName());
        DialogDescriptor dd = new DialogDescriptor((Object)this, title, true, -1, NotifyDescriptor.CANCEL_OPTION, 0, HelpCtx.findHelp((Component)this), null);
        Dialog d = DialogDisplayer.getDefault().createDialog(dd);
        d.addComponentListener(new DisplayWarning());
        d.setVisible(true);
        if (dd.getValue() == NotifyDescriptor.OK_OPTION) {
            if (this.generateTableRButton.isSelected()) {
                boolean unique = this.generateUnique.isSelected();
                SunOneUtilsCMP.setSchemaGeneratorProperty(this.infoHelper, "use-unique-table-names", unique);
                String vendorName = this.getVendorName();
                if (SunOneUtilsCMP.generateMapping(this.infoHelper, vendorName, unique)) {
                    SunOneUtilsCMP.setJavaToDB(this.infoHelper, true);
                    SunOneUtilsCMP.setGeneratedSchemaName(this.infoHelper, this.mappingContext.getModel());
                    SunOneUtilsCMP.setDatabaseVendorName(this.infoHelper, vendorName);
                    return true;
                }
                return false;
            }
            if (this.mapToDbRButton.isSelected()) {
                ClassState classState;
                String fullName = (String)this.dbSchemaComboBox.getSelectedItem();
                if (this.noSchemaInJar || fullName.equals(EMPTY_STRING)) {
                    this.showError(bundle.getString("CFM_select_schema_file"));
                    this.continueNeeded = true;
                    return false;
                }
                String genSchemaFileName = SunOneUtilsCMP.getGeneratedSchemaName(this.infoHelper);
                String schemaFileName = SunOneUtilsCMP.removeSchemaFileNameExtension(fullName);
                boolean sameSchemaName = schemaFileName.equals(genSchemaFileName);
                if (sameSchemaName) {
                    SchemaElement.removeFromCache((String)genSchemaFileName);
                }
                SchemaElement schema = SchemaElement.forName((String)schemaFileName, (Object)this.infoHelper.getClassLoader());
                HashMap<String, ClassState> classStateMap = new HashMap<String, ClassState>();
                if (schema == null) {
                    String error = MessageFormat.format(bundle.getString("CFM_Err_schema_null"), fullName);
                    Util.showError(new Exception(error));
                    return false;
                }
                ArrayList<String> suffixList = new ArrayList<String>();
                suffixList.add(this.mappingContext.getBrandingSuffix());
                suffixList.add(BEAN_SUFFIX1);
                suffixList.add(BEAN_SUFFIX2);
                Iterator itr = this.classStateList.iterator();
                while (itr.hasNext()) {
                    classState = (ClassState)itr.next();
                    TableState tableState = classState.getTableState();
                    String mceName = classState.getMappingClassElement().getName();
                    tableState.setCurrentPrimaryTable(null);
                    tableState.setCurrentSchema(schema);
                    tableState.addDefaultTableMapping(mceName, suffixList);
                    classStateMap.put(mceName, classState);
                }
                itr = this.classStateList.iterator();
                while (itr.hasNext()) {
                    classState = (ClassState)itr.next();
                    PersistenceClassElement pce = classState.getPersistenceClassElement();
                    ArrayList<String> alreadyHandled = new ArrayList<String>();
                    alreadyHandled.add(pce.getName());
                    RelationshipElement[] rels = pce.getRelationships();
                    if (rels == null) continue;
                    for (int i = 0; i < rels.length; ++i) {
                        String relatedClass = this.model.getRelatedClass(rels[i]);
                        if (relatedClass == null || alreadyHandled.contains(relatedClass)) continue;
                        TableState emptyState = classState.getFieldHolderState().getTableState(relatedClass);
                        TableState filledState = ((ClassState)classStateMap.get(relatedClass)).getTableState();
                        this.updateRelatedPrimaryTable(emptyState, filledState);
                        alreadyHandled.add(relatedClass);
                    }
                }
                itr = this.classStateList.iterator();
                while (itr.hasNext()) {
                    classState = (ClassState)itr.next();
                    classState.getFieldHolderState().addDefaultMapping();
                }
                if (!sameSchemaName) {
                    SchemaElement.removeFromCache((String)genSchemaFileName);
                }
            } else {
                this.showError(bundle.getString("CFM_select_action"));
                this.continueNeeded = true;
                return false;
            }
            SunOneUtilsCMP.cleanupJavaToDBRelatedProps(this.infoHelper);
            return true;
        }
        return false;
    }

    public List getModifiedClassStateList() {
        return this.classStateList;
    }

    private final void updateRelatedPrimaryTable(TableState oldState, TableState newState) {
        String realPrimaryTable = newState.getCurrentPrimaryTableName();
        if (realPrimaryTable != null && !realPrimaryTable.equals(oldState.getCurrentPrimaryTableName())) {
            TableElement realTable = null;
            if (!StringHelper.isEmpty(realPrimaryTable)) {
                realTable = TableElement.forName((String)NameUtil.getAbsoluteTableName((String)newState.getCurrentSchemaName(), (String)realPrimaryTable));
            }
            oldState.setCurrentPrimaryTable(realTable);
        }
    }

    private void convertToClassStateList() {
        this.classStateList = new ArrayList();
        Iterator iter = this.beansList.iterator();
        while (iter.hasNext()) {
            ClassState classState = SunOneUtilsCMP.createClassState(this.mappingContext, this.infoHelper, (String)iter.next());
            this.classStateList.add(classState);
        }
    }

    public String getCmpResourceJndiName() {
        return this.cmpResourceJndiName;
    }

    public boolean isGenerateTableSelected() {
        return this.generateTableRButton.isSelected();
    }

    public boolean isContinueNeeded() {
        return this.continueNeeded;
    }

    private String getVendorName() {
        String name = ((String)this.vendorComboBox.getSelectedItem()).toLowerCase();
        if (name.equals("generic sql92")) {
            name = "sql92";
        }
        return name.toUpperCase();
    }

    private boolean needWarning() {
        try {
            this.convertToClassStateList();
            Iterator itr = this.classStateList.iterator();
            while (itr.hasNext()) {
                ClassState classState = (ClassState)itr.next();
                if (classState.getTableState().getCurrentSchema() == null) continue;
                return true;
            }
            return false;
        }
        catch (RuntimeException ex) {
            this.noSchemaInJar = true;
            return true;
        }
    }

    private void showError(String errorMsg) {
        NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)errorMsg, 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
    }

    class DisplayWarning
    extends ComponentAdapter {
        DisplayWarning() {
        }

        public void componentShown(ComponentEvent ce) {
            if (CreateFieldMappings.this.needWarning()) {
                if (!Util.checkForWarning(bundle.getString("CFM_warning_generate_table"))) {
                    ce.getComponent().setVisible(false);
                }
            } else if (!SunOneUtilsCMP.isSchemaSpecified() && !Util.checkForWarning(bundle.getString("CFM_warning_lose_mapping"))) {
                ce.getComponent().setVisible(false);
            }
        }
    }
}

