/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.internalapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.netbeans.jmi.javamodel.Array;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.Case;
import org.netbeans.jmi.javamodel.Catch;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Expression;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Import;
import org.netbeans.jmi.javamodel.Invocation;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.MultipartIdClass;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Statement;
import org.netbeans.jmi.javamodel.StatementBlock;
import org.netbeans.jmi.javamodel.ThrowStatement;
import org.netbeans.jmi.javamodel.TryStatement;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeArgument;
import org.netbeans.jmi.javamodel.TypeParameter;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ArrayCloneMethod;
import org.netbeans.modules.javacore.jmiimpl.javamodel.JavaClassImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MetadataElement;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MethodImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ParameterizedTypeImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.SemiPersistentElement;
import org.netbeans.modules.javacore.parser.Scope;
import org.netbeans.modules.javacore.parser.TypeRef;

public class JavaModelUtil {
    private JavaModelUtil() {
    }

    public static Set getExceptionsFromStatements(List statements) {
        return JavaModelUtil.computeAllExceptions(statements, new HashSet());
    }

    private static Set computeAllExceptions(List elements, Set ignoredExceptions) {
        Iterator elIt = elements.iterator();
        HashSet foundExceptions = new HashSet();
        while (elIt.hasNext()) {
            Object el = elIt.next();
            if (el instanceof Invocation) {
                List exceptions;
                Invocation inv = (Invocation)el;
                CallableFeature cf = (CallableFeature)inv.getElement();
                if (cf != null && !(exceptions = cf.getExceptions()).isEmpty()) {
                    Iterator exIt = exceptions.iterator();
                    while (exIt.hasNext()) {
                        JavaModelUtil.addException((JavaClass)exIt.next(), foundExceptions, ignoredExceptions);
                    }
                }
            } else {
                TryStatement trySt;
                StatementBlock body;
                if (el instanceof MultipartId) continue;
                if (el instanceof ThrowStatement) {
                    ThrowStatement throwSt = (ThrowStatement)el;
                    Expression ex = throwSt.getExpression();
                    if (ex != null) {
                        JavaModelUtil.addException((JavaClass)ex.getType(), foundExceptions, ignoredExceptions);
                    }
                } else if (el instanceof TryStatement && (body = (trySt = (TryStatement)el).getBody()) != null) {
                    List catches = trySt.getCatches();
                    Iterator catchIt = catches.iterator();
                    HashSet localIgnores = new HashSet(ignoredExceptions);
                    StatementBlock finalizer = trySt.getFinalizer();
                    while (catchIt.hasNext()) {
                        Catch c = (Catch)catchIt.next();
                        JavaClass ex = (JavaClass)c.getParameter().getType();
                        JavaModelUtil.addException(ex, localIgnores, Collections.EMPTY_SET);
                    }
                    foundExceptions.addAll(JavaModelUtil.computeAllExceptions(Collections.singletonList(body), localIgnores));
                    foundExceptions.addAll(JavaModelUtil.computeAllExceptions(catches, ignoredExceptions));
                    if (finalizer != null) {
                        foundExceptions.addAll(JavaModelUtil.computeAllExceptions(Collections.singletonList(finalizer), ignoredExceptions));
                    }
                    return foundExceptions;
                }
            }
            foundExceptions.addAll(JavaModelUtil.computeAllExceptions(((Element)el).getChildren(), ignoredExceptions));
        }
        return foundExceptions;
    }

    private static void addException(JavaClass ex, Set foundExceptions, Set ignoredExceptions) {
        if (ex == null || ex instanceof UnresolvedClass) {
            return;
        }
        if (ignoredExceptions.contains(ex) || foundExceptions.contains(ex)) {
            return;
        }
        Iterator jclsIt = ignoredExceptions.iterator();
        while (jclsIt.hasNext()) {
            JavaClass igEx = (JavaClass)jclsIt.next();
            if (!ex.isSubTypeOf((ClassDefinition)igEx)) continue;
            return;
        }
        jclsIt = foundExceptions.iterator();
        while (jclsIt.hasNext()) {
            JavaClass fex = (JavaClass)jclsIt.next();
            if (!ex.isSubTypeOf((ClassDefinition)fex)) continue;
            return;
        }
        foundExceptions.add(ex);
    }

    public static List getSelectedStatements(Resource rsc, int startOffset, int endOffset) {
        List<Statement> selectedStatements;
        Statement firstStatement = JavaModelUtil.getStatement(rsc, startOffset);
        Statement lastStatement = JavaModelUtil.getStatement(rsc, endOffset - 1);
        if (firstStatement == null || lastStatement == null) {
            return null;
        }
        firstStatement = JavaModelUtil.adjustFirstStatement(startOffset, firstStatement);
        lastStatement = JavaModelUtil.adjustLastStatement(endOffset, lastStatement);
        if (firstStatement == null || lastStatement == null) {
            return null;
        }
        Element firstStComposite = (Element)firstStatement.refImmediateComposite();
        Element lastStComposite = (Element)lastStatement.refImmediateComposite();
        int lastStEndOffset = lastStComposite.getEndOffset();
        while (!firstStComposite.equals(lastStComposite)) {
            if (!(lastStComposite instanceof Statement) || lastStComposite.getEndOffset() != lastStEndOffset) {
                return null;
            }
            lastStatement = (Statement)lastStComposite;
            lastStComposite = (Element)lastStatement.refImmediateComposite();
        }
        if (firstStatement.equals(lastStatement)) {
            selectedStatements = Collections.singletonList(firstStatement);
        } else {
            Object st;
            List statements = firstStComposite instanceof StatementBlock ? ((StatementBlock)firstStComposite).getStatements() : ((Case)firstStComposite).getStatements();
            int firstIndex = statements.indexOf(firstStatement);
            ListIterator sIt = statements.listIterator(firstIndex);
            selectedStatements = new ArrayList<Statement>();
            do {
                st = sIt.next();
                selectedStatements.add((Statement)st);
            } while (!st.equals(lastStatement));
        }
        return selectedStatements;
    }

    private static Statement getStatement(Resource rsc, int offset) {
        Element el = rsc.getElementByOffset(offset);
        if (el instanceof Feature || el instanceof Resource) {
            return null;
        }
        int elStart = el.getStartOffset();
        int elEnd = el.getEndOffset();
        while (el != null && !(el instanceof Statement)) {
            if (!((el = (Element)el.refImmediateComposite()) instanceof Feature) && (el.getStartOffset() == elStart || el.getEndOffset() == elEnd)) continue;
            return null;
        }
        return (Statement)el;
    }

    private static Statement adjustFirstStatement(int startOffset, Statement s) {
        JavaMetamodel model = JavaMetamodel.getManager();
        if (model.getElementPosition((Element)s).getBegin().getOffset() == startOffset) {
            return s;
        }
        Iterator chIt = s.getChildren().iterator();
        while (chIt.hasNext()) {
            Element el = (Element)chIt.next();
            if (!(el instanceof Statement) || model.getElementPosition(el).getBegin().getOffset() <= startOffset) continue;
            return (Statement)el;
        }
        return null;
    }

    private static Statement adjustLastStatement(int endOffset, Statement s) {
        JavaMetamodel model = JavaMetamodel.getManager();
        if (model.getElementPosition((Element)s).getEnd().getOffset() == endOffset) {
            return s;
        }
        List children = s.getChildren();
        ListIterator chIt = children.listIterator(children.size());
        while (chIt.hasPrevious()) {
            Element el = (Element)chIt.previous();
            if (!(el instanceof Statement) || model.getElementPosition(el).getEnd().getOffset() >= endOffset) continue;
            return (Statement)el;
        }
        return null;
    }

    public static MultipartId resolveImportsForClass(Element scope, JavaClass jcls) {
        return (MultipartId)JavaModelUtil.typeToTypeReference(scope, (Type)jcls);
    }

    public static TypeReference resolveImportsForType(Element scope, Type type) {
        return (TypeReference)JavaModelUtil.typeToTypeReference(scope, type);
    }

    private static Element typeToTypeReference(Element scope, Type type) {
        if (type == null) {
            return null;
        }
        scope = JavaModelUtil.unwrapElement(scope);
        JavaModelPackage jpck = (JavaModelPackage)scope.refImmediatePackage();
        MultipartIdClass mpidClass = jpck.getMultipartId();
        if (type instanceof TypeParameter) {
            return mpidClass.createMultipartId(type.getName(), null, null);
        }
        if (type instanceof ParameterizedType) {
            String name;
            ParameterizedTypeImpl paramType = (ParameterizedTypeImpl)type;
            Type[] typePars = paramType.getParameters().toArray(new Type[0]);
            TypeArgument[] args = new TypeArgument[typePars.length];
            for (int i = 0; i < typePars.length; ++i) {
                args[i] = (TypeArgument)JavaModelUtil.typeToTypeReference(scope, typePars[i]);
                int status = paramType.getWildCardStatus(i);
                if (status == 0) continue;
                args[i] = jpck.getWildCard().createWildCard(status == 1, status == 3 ? null : (MultipartId)args[i]);
            }
            MultipartId parentName = (MultipartId)JavaModelUtil.typeToTypeReference(scope, (Type)paramType.getDeclaringClass());
            JavaClass def = paramType.getDefinition();
            if (parentName == null) {
                MultipartId defId = JavaModelUtil.createImportsForClass(scope, def);
                if (typePars.length == 0) {
                    return defId;
                }
                name = defId.getName();
            } else {
                name = def.getSimpleName();
            }
            return mpidClass.createMultipartId(name, parentName, Arrays.asList(args));
        }
        if (type instanceof Array) {
            int dimCount = 0;
            Type currType = type;
            while (currType instanceof Array) {
                ++dimCount;
                currType = ((Array)currType).getType();
            }
            return jpck.getArrayReference().createArrayReference(null, (MultipartId)JavaModelUtil.typeToTypeReference(scope, currType), dimCount);
        }
        if (type instanceof JavaClass) {
            if (type instanceof JavaClassImpl && ((JavaClassImpl)type).isTransient()) {
                return mpidClass.createMultipartId(type.getName(), null, null);
            }
            return JavaModelUtil.createImportsForClass(scope, (JavaClass)type);
        }
        if (type instanceof PrimitiveType) {
            return mpidClass.createMultipartId(type.getName(), null, null);
        }
        throw new IllegalArgumentException("Unable to convert to typeref: " + type.getClass().getName());
    }

    private static MultipartId createImportsForClass(Element scope, JavaClass type) {
        String simpleName;
        JavaModelPackage jpck = (JavaModelPackage)scope.refImmediatePackage();
        MultipartIdClass mpidClass = jpck.getMultipartId();
        if (type instanceof UnresolvedClass) {
            return mpidClass.createMultipartId(type.getName(), null, null);
        }
        Scope sc = Scope.computeTypeScope(scope);
        Object resolvedClass = sc.lookup(simpleName = type.getSimpleName());
        if (resolvedClass != null) {
            if (type.getName().equals(resolvedClass)) {
                return mpidClass.createMultipartId(simpleName, null, null);
            }
            return mpidClass.createMultipartId(type.getName(), null, null);
        }
        Import imp = jpck.getImport().createImport(type.getName(), null, false, false);
        scope.getResource().addImport(imp);
        return mpidClass.createMultipartId(simpleName, null, null);
    }

    public static Feature getDeclaringFeature(Element element) {
        while (!(element instanceof Feature) && element != null) {
            element = (Element)element.refImmediateComposite();
        }
        return (Feature)element;
    }

    public static Element duplicateInScope(Element scope, Element original) {
        scope = JavaModelUtil.unwrapElement(scope);
        JavaModelPackage pck = (JavaModelPackage)scope.refImmediatePackage();
        MetadataElement newElement = (MetadataElement)JavaModelUtil.unwrapElement(original).duplicate(pck);
        newElement.fixImports(scope, original);
        return newElement;
    }

    private static MetadataElement unwrapElement(Element el) {
        if (el instanceof MetadataElement) {
            return (MetadataElement)el;
        }
        if (el instanceof ParameterizedType) {
            return (MetadataElement)((ParameterizedType)el).getDefinition();
        }
        if (el instanceof ParameterizedTypeImpl.Wrapper) {
            return (MetadataElement)((Object)((ParameterizedTypeImpl.Wrapper)el).getWrappedObject());
        }
        throw new IllegalArgumentException("Unknown type " + el.getClass());
    }

    public static Collection getOverriddenMethods(Method method) {
        if (method instanceof ArrayCloneMethod) {
            ArrayList<Method> result = new ArrayList<Method>(1);
            result.add(((JavaClass)JavaModel.getDefaultExtent().getType().resolve("java.lang.Object")).getMethod("clone", Collections.EMPTY_LIST, false));
            return result;
        }
        MethodImpl mImpl = (MethodImpl)JavaModelUtil.unwrapElement((Element)method);
        return mImpl.getOverriddenMethods();
    }

    public static TypeReference createTypeReferenceFromType(Type type) {
        JavaModelPackage extent = JavaModel.getDefaultExtent();
        TypeRef typeRef = SemiPersistentElement.typeToTypeRef(type);
        return (TypeReference)SemiPersistentElement.typeRefToTypeReference(extent, typeRef, 0);
    }
}

