/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.spi;

import java.beans.PropertyChangeSupport;
import java.util.Map;
import javax.servlet.jsp.tagext.TagLibraryInfo;

public final class JSPColoringData
extends PropertyChangeSupport {
    public static final String PROP_COLORING_CHANGE = "coloringChange";
    public static final String PROP_PARSING_SUCCESSFUL = "parsingSuccessful";
    public static final String PROP_PARSING_IN_PROGRESS = "parsingInProgress";
    private Map taglibs;
    private Map prefixMapper;
    private boolean elIgnored = false;
    private boolean xmlSyntax = false;

    public JSPColoringData(Object sourceBean) {
        super(sourceBean);
    }

    public String toString() {
        return "JSPColoringData, taglibMap:\n" + (this.prefixMapper == null ? "null" : JSPColoringData.mapToString(this.prefixMapper, "  "));
    }

    private static String mapToString(Map m, String indent) {
        StringBuffer sb = new StringBuffer();
        for (Object key : m.keySet()) {
            sb.append(indent).append(key).append(" -> ").append(m.get(key)).append("\n");
        }
        return sb.toString();
    }

    public boolean isTagLibRegistered(String prefix) {
        if (this.taglibs == null || this.prefixMapper == null) {
            return false;
        }
        return this.prefixMapper.containsKey(prefix);
    }

    public boolean isELIgnored() {
        return this.elIgnored;
    }

    public boolean isXMLSyntax() {
        return this.xmlSyntax;
    }

    public void parsingStarted() {
        this.firePropertyChange(PROP_PARSING_IN_PROGRESS, null, new Boolean(true));
    }

    public void applyParsedData(Map newTaglibs, Map newPrefixMapper, boolean newELIgnored, boolean newXMLSyntax, boolean parseSuccessful) {
        boolean coloringSame = JSPColoringData.equalsColoringInformation(this.taglibs, this.prefixMapper, newTaglibs, newPrefixMapper);
        this.firePropertyChange(PROP_PARSING_SUCCESSFUL, null, new Boolean(parseSuccessful));
        if (parseSuccessful) {
            coloringSame = coloringSame && this.elIgnored == newELIgnored;
            this.elIgnored = newELIgnored;
        }
        if (this.taglibs == null && this.prefixMapper == null) {
            boolean bl = coloringSame = newELIgnored == this.elIgnored && newXMLSyntax == this.xmlSyntax && newTaglibs.isEmpty() && newPrefixMapper.isEmpty();
        }
        if (newXMLSyntax != this.xmlSyntax) {
            this.xmlSyntax = newXMLSyntax;
            coloringSame = false;
        }
        if (parseSuccessful || this.taglibs == null || this.prefixMapper == null) {
            this.taglibs = newTaglibs;
            this.prefixMapper = newPrefixMapper;
        } else {
            for (Object prefix : newPrefixMapper.keySet()) {
                Object newTaglib;
                Object uri = newPrefixMapper.get(prefix);
                Object uriOld = this.prefixMapper.get(prefix);
                if (uriOld != null && uri.equals(uriOld) || (newTaglib = newTaglibs.get(uri)) == null) continue;
                this.prefixMapper.put(prefix, uri);
                this.taglibs.put(uri, newTaglib);
            }
        }
        if (!coloringSame) {
            this.firePropertyChange(PROP_COLORING_CHANGE, null, null);
        }
    }

    private static boolean equalsColoringInformation(Map taglibs1, Map prefixMapper1, Map taglibs2, Map prefixMapper2) {
        if (taglibs1 == null != (taglibs2 == null)) {
            return false;
        }
        if (prefixMapper1 == null != (prefixMapper2 == null)) {
            return false;
        }
        if (prefixMapper1.size() != prefixMapper2.size()) {
            return false;
        }
        for (Object prefix : prefixMapper1.keySet()) {
            Object key1 = prefixMapper1.get(prefix);
            Object key2 = prefixMapper2.get(prefix);
            if (key1 == null || key2 == null) {
                return false;
            }
            TagLibraryInfo tli1 = (TagLibraryInfo)taglibs1.get(key1);
            TagLibraryInfo tli2 = (TagLibraryInfo)taglibs2.get(key2);
            if (tli1 == null || tli2 == null) {
                return false;
            }
            if (JSPColoringData.equalsColoringInformation(tli1, tli2)) continue;
            return false;
        }
        return true;
    }

    private static boolean equalsColoringInformation(TagLibraryInfo tli1, TagLibraryInfo tli2) {
        return true;
    }
}

