/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import java.util.List;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.modules.editor.hints.spi.ChangeInfo;
import org.netbeans.modules.java.hints.CreateElementJavaHint;
import org.netbeans.modules.java.hints.DeclarationInfo;
import org.netbeans.modules.java.hints.PositionUtils;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.openide.util.NbBundle;

class CreateFieldJavaHint
extends CreateElementJavaHint {
    private ClassDefinition javaClass;

    CreateFieldJavaHint(NamedElement symbol, ClassDefinition cls) {
        super(symbol);
        this.javaClass = cls;
        if (cls instanceof ParameterizedType) {
            this.javaClass = ((ParameterizedType)cls).getDefinition();
        }
        this.hintText = NbBundle.getMessage((Class)CreateFieldJavaHint.class, (String)"MSG_CreateField", (Object)this.name, (Object)cls.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeInfo implement() {
        Field newField;
        boolean bothInOneFile;
        boolean fail = true;
        JavaModel.getJavaRepository().beginTrans(true);
        try {
            JavaModel.setClassPath((Resource)this.unresolvedSymbol.getResource());
            Type fieldType = DeclarationInfo.computeType((Element)this.unresolvedSymbol);
            Resource classRes = this.javaClass.getResource();
            Resource unresRes = this.unresolvedSymbol.getResource();
            bothInOneFile = classRes.equals(unresRes);
            int modifiers = this.computeAccessModifiers(this.javaClass, unresRes);
            newField = this.createField(modifiers |= this.computeStaticModifier(this.unresolvedSymbol), fieldType);
            fail = false;
        }
        finally {
            JavaModel.getJavaRepository().endTrans(fail);
        }
        ChangeInfo ch = PositionUtils.selectFieldType(newField);
        if (!bothInOneFile) {
            this.addModified();
        }
        return ch;
    }

    private Field createField(int modifiers, Type type) {
        JavaModelPackage pac = (JavaModelPackage)this.javaClass.refImmediatePackage();
        TypeReference typeRef = JavaModelUtil.resolveImportsForType((Element)this.javaClass, (Type)type);
        Field field = pac.getField().createField(this.name, null, modifiers, null, null, false, typeRef, 0, null, null);
        List features = this.javaClass.getFeatures();
        int index = PositionUtils.getProposedFieldIndex(features);
        if (index == -1) {
            index = 0;
        }
        features.add(index, field);
        return field;
    }
}

