/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.StringTokenizer;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.model.XpathEvent;
import javax.enterprise.deploy.model.XpathListener;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.j2ee.jboss4.config.JBDeploymentConfiguration;
import org.netbeans.modules.j2ee.jboss4.config.gen.EjbRef;
import org.netbeans.modules.j2ee.jboss4.config.gen.JbossWeb;
import org.netbeans.modules.j2ee.jboss4.config.gen.MessageDestinationRef;
import org.netbeans.modules.j2ee.jboss4.config.gen.ResourceRef;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public class WarDeploymentConfiguration
extends JBDeploymentConfiguration
implements PropertyChangeListener,
XpathListener {
    private static final String RESOURCE_REF = "/web-app/resource-ref";
    private static final String EJB_REF = "/web-app/ejb-ref";
    private static final String MSG_DEST_REF = "/web-app/message-destination-ref";
    private File jbossWebFile;
    private JbossWeb jbossWeb;

    public WarDeploymentConfiguration(DeployableObject deployableObject) {
        super(deployableObject);
    }

    public void init(File file, File resourceDir) {
        super.init(resourceDir);
        this.jbossWebFile = file;
        this.getJbossWeb();
        if (this.deploymentDescriptorDO == null) {
            try {
                this.deploymentDescriptorDO = DataObject.find((FileObject)FileUtil.toFileObject((File)this.jbossWebFile));
                this.deploymentDescriptorDO.addPropertyChangeListener((PropertyChangeListener)this);
            }
            catch (DataObjectNotFoundException donfe) {
                ErrorManager.getDefault().notify((Throwable)donfe);
            }
        }
        if (this.deplObj != null && this.deplObj.getDDBeanRoot() != null) {
            DDBeanRoot root = this.deplObj.getDDBeanRoot();
            root.addXpathListener(RESOURCE_REF, (XpathListener)this);
            root.addXpathListener(EJB_REF, (XpathListener)this);
            root.addXpathListener(MSG_DEST_REF, (XpathListener)this);
        }
    }

    public String getContextPath() throws ConfigurationException {
        JbossWeb jbossWeb = this.getJbossWeb();
        if (jbossWeb == null) {
            throw new ConfigurationException("jboss-web.xml is not parseable, cannot read the context path value.");
        }
        return jbossWeb.getContextRoot();
    }

    public void setContextPath(String contextPath) throws ConfigurationException {
        if (!this.isCorrectCP(contextPath)) {
            String ctxRoot = contextPath;
            StringTokenizer tok = new StringTokenizer(contextPath, "/");
            StringBuffer buf = new StringBuffer();
            while (tok.hasMoreTokens()) {
                buf.append("/" + tok.nextToken());
            }
            ctxRoot = buf.toString();
            NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_invalidCP", (Object)contextPath), 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            contextPath = ctxRoot;
        }
        final String newContextPath = contextPath;
        this.modifyJbossWeb(new JbossWebModifier(){

            public void modify(JbossWeb jbossWeb) {
                jbossWeb.setContextRoot(newContextPath);
            }
        });
    }

    public synchronized void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "modified" && evt.getNewValue() == Boolean.FALSE) {
            if (evt.getSource() == this.deploymentDescriptorDO) {
                this.jbossWeb = null;
            } else {
                super.propertyChange(evt);
            }
        }
    }

    public void fireXpathEvent(XpathEvent xpe) {
        if (!xpe.isAddEvent()) {
            return;
        }
        DDBean eventDDBean = xpe.getBean();
        if (RESOURCE_REF.equals(eventDDBean.getXpath())) {
            String[] desc = eventDDBean.getText("description");
            String[] name = eventDDBean.getText("res-ref-name");
            String[] type = eventDDBean.getText("res-type");
            if (name.length > 0 && type.length > 0) {
                try {
                    if (desc.length > 0 && "javax.sql.DataSource".equals(type[0])) {
                        this.addResReference(desc[0], name[0]);
                    } else if ("javax.mail.Session".equals(type[0])) {
                        this.addMailReference(name[0]);
                    }
                    if ("javax.jms.ConnectionFactory".equals(type[0])) {
                        this.addConnectionFactoryReference(name[0]);
                    }
                }
                catch (ConfigurationException ce) {
                    ErrorManager.getDefault().notify((Throwable)ce);
                }
            }
        } else if (EJB_REF.equals(eventDDBean.getXpath())) {
            String[] name = eventDDBean.getText("ejb-ref-name");
            String[] type = eventDDBean.getText("ejb-ref-type");
            if (name.length > 0 && type.length > 0 && ("Session".equals(type[0]) || "Entity".equals(type[0]))) {
                try {
                    this.addEjbReference(name[0]);
                }
                catch (ConfigurationException ce) {
                    ErrorManager.getDefault().notify((Throwable)ce);
                }
            }
        } else if (MSG_DEST_REF.equals(eventDDBean.getXpath())) {
            String[] name = eventDDBean.getText("message-destination-ref-name");
            String[] type = eventDDBean.getText("message-destination-type");
            if (name.length > 0) {
                String destPrefix = "";
                if (type.length > 0) {
                    if (type[0].equals("javax.jms.Queue")) {
                        destPrefix = "queue/";
                    } else if (type[0].equals("javax.jms.Topic")) {
                        destPrefix = "topic/";
                    }
                }
                try {
                    this.addMsgDestReference(name[0], destPrefix);
                }
                catch (ConfigurationException ce) {
                    ErrorManager.getDefault().notify((Throwable)ce);
                }
            }
        }
    }

    private void addResReference(String desc, final String name) throws ConfigurationException {
        this.modifyJbossWeb(new JbossWebModifier(){

            public void modify(JbossWeb modifiedJbossWeb) {
                ResourceRef[] resourceRefs = modifiedJbossWeb.getResourceRef();
                for (int i = 0; i < resourceRefs.length; ++i) {
                    String rrn = resourceRefs[i].getResRefName();
                    if (!name.equals(rrn)) continue;
                    return;
                }
                ResourceRef newRR = new ResourceRef();
                newRR.setResRefName(name);
                newRR.setJndiName("java:" + name);
                modifiedJbossWeb.addResourceRef(newRR);
            }
        });
    }

    private void addMailReference(final String name) throws ConfigurationException {
        this.modifyJbossWeb(new JbossWebModifier(){

            public void modify(JbossWeb modifiedJbossWeb) {
                ResourceRef[] resourceRefs = modifiedJbossWeb.getResourceRef();
                for (int i = 0; i < resourceRefs.length; ++i) {
                    String rrn = resourceRefs[i].getResRefName();
                    if (!name.equals(rrn)) continue;
                    return;
                }
                ResourceRef newRR = new ResourceRef();
                newRR.setResRefName(name);
                newRR.setJndiName("java:Mail");
                modifiedJbossWeb.addResourceRef(newRR);
            }
        });
    }

    private void addConnectionFactoryReference(final String name) throws ConfigurationException {
        this.modifyJbossWeb(new JbossWebModifier(){

            public void modify(JbossWeb modifiedJbossWeb) {
                ResourceRef[] resourceRefs = modifiedJbossWeb.getResourceRef();
                for (int i = 0; i < resourceRefs.length; ++i) {
                    String rrn = resourceRefs[i].getResRefName();
                    if (!name.equals(rrn)) continue;
                    return;
                }
                ResourceRef newRR = new ResourceRef();
                newRR.setResRefName(name);
                newRR.setJndiName("ConnectionFactory");
                modifiedJbossWeb.addResourceRef(newRR);
            }
        });
    }

    private void addMsgDestReference(final String name, final String destPrefix) throws ConfigurationException {
        this.modifyJbossWeb(new JbossWebModifier(){

            public void modify(JbossWeb modifiedJbossWeb) {
                MessageDestinationRef[] mdRefs = modifiedJbossWeb.getMessageDestinationRef();
                for (int i = 0; i < mdRefs.length; ++i) {
                    String mdrn = mdRefs[i].getMessageDestinationRefName();
                    if (!name.equals(mdrn)) continue;
                    return;
                }
                MessageDestinationRef mdr = new MessageDestinationRef();
                mdr.setMessageDestinationRefName(name);
                String jndiName = name;
                if (name.startsWith("jms/")) {
                    jndiName = destPrefix + name.substring("jms/".length());
                }
                mdr.setJndiName(jndiName);
                modifiedJbossWeb.addMessageDestinationRef(mdr);
            }
        });
    }

    private void addEjbReference(final String name) throws ConfigurationException {
        this.modifyJbossWeb(new JbossWebModifier(){

            public void modify(JbossWeb modifiedJbossWeb) {
                EjbRef[] ejbRefs = modifiedJbossWeb.getEjbRef();
                for (int i = 0; i < ejbRefs.length; ++i) {
                    String ern = ejbRefs[i].getEjbRefName();
                    if (!name.equals(ern)) continue;
                    return;
                }
                EjbRef newER = new EjbRef();
                newER.setEjbRefName(name);
                String jndiName = name;
                if (jndiName.indexOf(47) != -1) {
                    jndiName = jndiName.substring(jndiName.lastIndexOf(47) + 1);
                }
                newER.setJndiName(jndiName);
                modifiedJbossWeb.addEjbRef(newER);
            }
        });
    }

    public synchronized JbossWeb getJbossWeb() {
        if (this.jbossWeb == null) {
            try {
                if (this.jbossWebFile.exists()) {
                    try {
                        this.jbossWeb = JbossWeb.createGraph(this.jbossWebFile);
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify((Throwable)ioe);
                    }
                    catch (RuntimeException re) {}
                } else {
                    this.jbossWeb = this.generateJbossWeb();
                    this.writefile(this.jbossWebFile, this.jbossWeb);
                }
            }
            catch (ConfigurationException ce) {
                ErrorManager.getDefault().notify((Throwable)ce);
            }
        }
        return this.jbossWeb;
    }

    public void save(OutputStream os) throws ConfigurationException {
        JbossWeb jbossWeb = this.getJbossWeb();
        if (jbossWeb == null) {
            throw new ConfigurationException("Cannot read configuration, it is probably in an inconsistent state.");
        }
        try {
            jbossWeb.write(os);
        }
        catch (IOException ioe) {
            throw new ConfigurationException(ioe.getLocalizedMessage());
        }
    }

    private void modifyJbossWeb(JbossWebModifier modifier) throws ConfigurationException {
        assert (this.deploymentDescriptorDO != null) : "DataObject has not been initialized yet";
        try {
            EditorCookie editor = (EditorCookie)this.deploymentDescriptorDO.getCookie(EditorCookie.class);
            StyledDocument doc = editor.getDocument();
            if (doc == null) {
                doc = editor.openDocument();
            }
            JbossWeb newJbossWeb = null;
            try {
                byte[] docString = doc.getText(0, doc.getLength()).getBytes();
                newJbossWeb = JbossWeb.createGraph(new ByteArrayInputStream(docString));
            }
            catch (RuntimeException e) {
                JbossWeb oldJbossWeb = this.getJbossWeb();
                if (oldJbossWeb == null) {
                    throw new ConfigurationException("Configuration data are not parseable cannot perform changes.");
                }
                NotifyDescriptor.Confirmation notDesc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_jbossWebXmlNotValid"), 2);
                Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)notDesc);
                if (result == NotifyDescriptor.CANCEL_OPTION) {
                    return;
                }
                newJbossWeb = oldJbossWeb;
            }
            modifier.modify(newJbossWeb);
            boolean modified = this.deploymentDescriptorDO.isModified();
            this.replaceDocument(doc, newJbossWeb);
            if (!modified) {
                SaveCookie cookie = (SaveCookie)this.deploymentDescriptorDO.getCookie(SaveCookie.class);
                cookie.save();
            }
            this.jbossWeb = newJbossWeb;
        }
        catch (BadLocationException ble) {
            throw (ConfigurationException)new ConfigurationException().initCause((Throwable)ble);
        }
        catch (IOException ioe) {
            throw (ConfigurationException)new ConfigurationException().initCause((Throwable)ioe);
        }
    }

    private JbossWeb generateJbossWeb() {
        JbossWeb jbossWeb = new JbossWeb();
        jbossWeb.setContextRoot("");
        return jbossWeb;
    }

    private boolean isCorrectCP(String contextPath) {
        boolean correct = true;
        if (!contextPath.equals("") && !contextPath.startsWith("/")) {
            correct = false;
        } else if (contextPath.endsWith("/")) {
            correct = false;
        } else if (contextPath.indexOf("//") >= 0) {
            correct = false;
        }
        return correct;
    }

    private static interface JbossWebModifier {
        public void modify(JbossWeb var1);
    }
}

