/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.nodes;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import org.netbeans.modules.j2ee.jboss4.nodes.JBApplicationsChildren;
import org.netbeans.modules.j2ee.jboss4.nodes.JBServletNode;
import org.netbeans.modules.j2ee.jboss4.nodes.Util;
import org.openide.ErrorManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class JBServletsChildren
extends Children.Keys {
    private static final String WAIT_NODE = "wait_node";
    private String name;
    private Lookup lookup;

    JBServletsChildren(String name, Lookup lookup) {
        this.lookup = lookup;
        this.name = name;
    }

    public void updateKeys() {
        this.setKeys(new Object[]{WAIT_NODE});
        RequestProcessor.getDefault().post(new Runnable(){
            Vector keys = new Vector();

            public void run() {
                try {
                    Object server = Util.getRMIServer(JBServletsChildren.this.lookup);
                    ObjectName searchPattern = new ObjectName("jboss.management.local:WebModule=" + JBServletsChildren.this.name + ",j2eeType=Servlet,*");
                    Set managedObj = (Set)server.getClass().getMethod("queryMBeans", ObjectName.class, QueryExp.class).invoke(server, searchPattern, null);
                    Iterator it = managedObj.iterator();
                    while (it.hasNext()) {
                        ObjectName elem = ((ObjectInstance)it.next()).getObjectName();
                        String s = elem.getKeyProperty("name");
                        this.keys.add(new JBServletNode(s));
                    }
                }
                catch (MalformedObjectNameException ex) {
                    ErrorManager.getDefault().log(4096, ex.getMessage());
                }
                catch (NullPointerException ex) {
                    ErrorManager.getDefault().log(4096, ex.getMessage());
                }
                catch (IllegalArgumentException ex) {
                    ErrorManager.getDefault().log(4096, ex.getMessage());
                }
                catch (SecurityException ex) {
                    ErrorManager.getDefault().log(4096, ex.getMessage());
                }
                catch (InvocationTargetException ex) {
                    ErrorManager.getDefault().log(4096, ex.getMessage());
                }
                catch (IllegalAccessException ex) {
                    ErrorManager.getDefault().log(4096, ex.getMessage());
                }
                catch (NoSuchMethodException ex) {
                    ErrorManager.getDefault().log(4096, ex.getMessage());
                }
                JBServletsChildren.this.setKeys(this.keys);
            }
        }, 0);
    }

    protected void addNotify() {
        this.updateKeys();
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
    }

    protected Node[] createNodes(Object key) {
        if (key instanceof JBServletNode) {
            return new Node[]{(JBServletNode)((Object)key)};
        }
        if (key instanceof String && key.equals(WAIT_NODE)) {
            return new Node[]{this.createWaitNode()};
        }
        return null;
    }

    private Node createWaitNode() {
        AbstractNode n = new AbstractNode(Children.LEAF);
        n.setName(NbBundle.getMessage(JBApplicationsChildren.class, (String)"LBL_WaitNode_DisplayName"));
        n.setIconBaseWithExtension("org/openide/src/resources/wait.gif");
        return n;
    }
}

