/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;

public class PriorityListenerList
implements Serializable {
    static final long serialVersionUID = 0L;
    private static final EventListener[] EMPTY_LISTENER_ARRAY = new EventListener[0];
    private static final EventListener[][] EMPTY_LISTENER_ARRAY_ARRAY = new EventListener[0][];
    private transient EventListener[][] listenersArray = EMPTY_LISTENER_ARRAY_ARRAY;

    public synchronized void add(EventListener listener, int priority) {
        EventListener[][] newListenersArray;
        if (priority >= this.listenersArray.length) {
            newListenersArray = new EventListener[priority + 1][];
            System.arraycopy(this.listenersArray, 0, newListenersArray, 0, this.listenersArray.length);
            for (int i = this.listenersArray.length; i < priority; ++i) {
                newListenersArray[i] = EMPTY_LISTENER_ARRAY;
            }
            newListenersArray[priority] = new EventListener[]{listener};
        } else {
            newListenersArray = (EventListener[][])this.listenersArray.clone();
            EventListener[] listeners = this.listenersArray[priority];
            EventListener[] newListeners = new EventListener[listeners.length + 1];
            System.arraycopy(listeners, 0, newListeners, 1, listeners.length);
            newListeners[0] = listener;
            newListenersArray[priority] = newListeners;
        }
        this.listenersArray = newListenersArray;
    }

    public synchronized void remove(EventListener listener, int priority) {
        if (priority < this.listenersArray.length) {
            int index;
            EventListener[] listeners = this.listenersArray[priority];
            for (index = listeners.length - 1; index >= 0 && listeners[index] != listener; --index) {
            }
            if (index >= 0) {
                EventListener[][] newListenersArray;
                boolean removeHighestPriorityLevel;
                EventListener[] newListeners;
                if (listeners.length == 1) {
                    newListeners = EMPTY_LISTENER_ARRAY;
                    removeHighestPriorityLevel = priority == this.listenersArray.length - 1;
                } else {
                    newListeners = new EventListener[listeners.length - 1];
                    System.arraycopy(listeners, 0, newListeners, 0, index);
                    System.arraycopy(listeners, index + 1, newListeners, index, newListeners.length - index);
                    removeHighestPriorityLevel = false;
                }
                if (removeHighestPriorityLevel) {
                    newListenersArray = new EventListener[this.listenersArray.length - 1][];
                    System.arraycopy(this.listenersArray, 0, newListenersArray, 0, newListenersArray.length);
                } else {
                    newListenersArray = (EventListener[][])this.listenersArray.clone();
                    newListenersArray[priority] = newListeners;
                }
                this.listenersArray = newListenersArray;
            }
        }
    }

    public EventListener[][] getListenersArray() {
        return this.listenersArray;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int priority;
        s.defaultWriteObject();
        s.writeInt(priority);
        for (priority = this.listenersArray.length - 1; priority >= 0; --priority) {
            EventListener[] listeners = this.listenersArray[priority];
            for (int i = 0; i < listeners.length; ++i) {
                EventListener listener = listeners[i];
                if (!(listener instanceof Serializable)) continue;
                s.writeObject(listener);
            }
            s.writeObject(null);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        int priority;
        s.defaultReadObject();
        Object object = this.listenersArray = priority != -1 ? new EventListener[priority + 1][] : EMPTY_LISTENER_ARRAY_ARRAY;
        for (priority = s.readInt(); priority >= 0; --priority) {
            EventListener listenerOrNull;
            ArrayList<EventListener> listeners = new ArrayList<EventListener>();
            while (null != (listenerOrNull = (EventListener)s.readObject())) {
                listeners.add(listenerOrNull);
            }
            this.listenersArray[priority] = listeners.toArray(new EventListener[listeners.size()]);
        }
    }
}

