/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.util.swing;

import java.util.Comparator;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;

public class PositionRegion {
    private static Comparator comparator;
    private Position startPosition;
    private Position endPosition;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static final Comparator getComparator() {
        if (comparator == null) {
            comparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((PositionRegion)o1).getStartOffset() - ((PositionRegion)o2).getStartOffset();
                }
            };
        }
        return comparator;
    }

    public static boolean isRegionsSorted(List positionRegionList) {
        for (int i = positionRegionList.size() - 2; i >= 0; --i) {
            if (PositionRegion.getComparator().compare(positionRegionList.get(i), positionRegionList.get(i + 1)) <= 0) continue;
            return false;
        }
        return true;
    }

    public PositionRegion(Position startPosition, Position endPosition) {
        if (!$assertionsDisabled && startPosition.getOffset() > endPosition.getOffset()) {
            throw new AssertionError((Object)("startPosition=" + startPosition.getOffset() + " > endPosition=" + endPosition));
        }
        this.startPosition = startPosition;
        this.endPosition = endPosition;
    }

    public PositionRegion(Document doc, int startOffset, int endOffset) throws BadLocationException {
        this(doc.createPosition(startOffset), doc.createPosition(endOffset));
    }

    public final int getStartOffset() {
        return this.startPosition.getOffset();
    }

    public final Position getStartPosition() {
        return this.startPosition;
    }

    public final int getEndOffset() {
        return this.endPosition.getOffset();
    }

    public final Position getEndPosition() {
        return this.endPosition;
    }

    public final int getLength() {
        return this.getEndOffset() - this.getStartOffset();
    }

    void setStartPositionImpl(Position startPosition) {
        if (!$assertionsDisabled && startPosition.getOffset() > this.endPosition.getOffset()) {
            throw new AssertionError((Object)("startPosition=" + startPosition.getOffset() + " > endPosition=" + this.endPosition));
        }
        this.startPosition = startPosition;
    }

    void setEndPositionImpl(Position endPosition) {
        if (!$assertionsDisabled && this.startPosition.getOffset() > endPosition.getOffset()) {
            throw new AssertionError((Object)("startPosition=" + this.startPosition.getOffset() + " > endPosition=" + endPosition));
        }
        this.endPosition = endPosition;
    }

    static {
        $assertionsDisabled = !PositionRegion.class.desiredAssertionStatus();
    }
}

