/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jmi.reflect.JmiException;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;

public final class JMIUtils {
    private static int transMonitor;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static List getMethods(ClassDefinition clazz) throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        List features = clazz.getFeatures();
        LinkedList methods = new LinkedList();
        Iterator it = features.iterator();
        while (it.hasNext()) {
            Object f = it.next();
            if (!(f instanceof Method)) continue;
            methods.add(f);
        }
        return methods;
    }

    public static List getConstructors(ClassDefinition clazz) throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        List features = clazz.getFeatures();
        LinkedList methods = new LinkedList();
        Iterator it = features.iterator();
        while (it.hasNext()) {
            Object f = it.next();
            if (!(f instanceof Constructor)) continue;
            methods.add(f);
        }
        return methods;
    }

    public static List getFields(JavaClass clazz) throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        List features = clazz.getFeatures();
        LinkedList fields = new LinkedList();
        Iterator it = features.iterator();
        while (it.hasNext()) {
            Object f = it.next();
            if (!(f instanceof Field)) continue;
            fields.add(f);
        }
        return fields;
    }

    public static boolean isPrimitiveType(Type type, PrimitiveTypeKindEnum kind) throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        boolean is = false;
        if (type instanceof PrimitiveType) {
            PrimitiveType ptype = (PrimitiveType)type;
            is = kind.equals((Object)ptype.getKind());
        }
        return is;
    }

    public static void beginTrans(boolean writeAccess) {
        JavaMetamodel.getDefaultRepository().beginTrans(writeAccess);
        ++transMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endTrans(boolean rollback) {
        try {
            if (!$assertionsDisabled && transMonitor <= 0) {
                throw new AssertionError();
            }
            JavaMetamodel.getDefaultRepository().endTrans(rollback);
        }
        finally {
            --transMonitor;
        }
    }

    public static void endTrans() {
        JMIUtils.endTrans(false);
    }

    public static boolean isInsideTrans() {
        return transMonitor > 0;
    }

    public static boolean equalTypes(Type type1, Type type2) throws JmiException {
        if (type1 == type2) {
            return true;
        }
        if (type1 == null || type2 == null) {
            return false;
        }
        type1 = type1 instanceof ParameterizedType ? ((ParameterizedType)type1).getDefinition() : type1;
        type2 = type2 instanceof ParameterizedType ? ((ParameterizedType)type2).getDefinition() : type2;
        return type1.equals(type2);
    }

    static {
        $assertionsDisabled = !JMIUtils.class.desiredAssertionStatus();
        transMonitor = 0;
    }
}

