/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.favorites;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.ObjectStreamException;
import java.util.Stack;
import javax.swing.ActionMap;
import javax.swing.SwingUtilities;
import org.netbeans.modules.favorites.Favorites;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.TreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeOp;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class Tab
extends TopComponent
implements Runnable,
ExplorerManager.Provider {
    static final long serialVersionUID = -8178367548546385799L;
    private static final DataObject[] needToSelect = new DataObject[1];
    private static transient Tab DEFAULT;
    protected transient TreeView view;
    private transient PropertyChangeListener weakRcL;
    private transient NodeListener weakNRcL;
    private transient NodeListener rcListener;
    private transient boolean valid = true;
    private ExplorerManager manager = new ExplorerManager();
    static /* synthetic */ Class class$org$openide$loaders$DataShadow;

    private Tab() {
        ActionMap map = this.getActionMap();
        map.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.manager));
        map.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.manager));
        map.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.manager));
        map.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.manager, (boolean)true));
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)map));
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(Tab.class);
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    protected String preferredID() {
        return "favorites";
    }

    protected void componentShowing() {
        super.componentShowing();
        if (this.view == null) {
            this.view = this.initGui();
            this.view.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)Tab.class, (String)"ACSN_ExplorerBeanTree"));
            this.view.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)Tab.class, (String)"ACSD_ExplorerBeanTree"));
        }
        this.run();
    }

    protected TreeView initGui() {
        BeanTreeView view = new BeanTreeView();
        view.setRootVisible(false);
        view.setDragSource(true);
        this.setLayout(new BorderLayout());
        this.add((Component)view);
        return view;
    }

    protected void componentActivated() {
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)true);
    }

    protected void componentDeactivated() {
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)false);
    }

    public void requestFocus() {
        super.requestFocus();
        if (this.view != null) {
            this.view.requestFocus();
        }
    }

    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        if (this.view != null) {
            return this.view.requestFocusInWindow();
        }
        return false;
    }

    public void setRootContext(Node rc) {
        Node oldRC = this.getExplorerManager().getRootContext();
        if (this.weakRcL != null) {
            oldRC.removePropertyChangeListener(this.weakRcL);
        }
        if (this.weakNRcL != null) {
            oldRC.removeNodeListener(this.weakNRcL);
        }
        this.getExplorerManager().setRootContext(rc);
        this.initializeWithRootContext(rc);
    }

    public Node getRootContext() {
        return this.getExplorerManager().getRootContext();
    }

    public void run() {
        if (!this.valid) {
            this.valid = true;
            this.validateRootContext();
        }
    }

    protected void updateTitle() {
        this.setName(this.getExplorerManager().getRootContext().getDisplayName());
    }

    private NodeListener rcListener() {
        if (this.rcListener == null) {
            this.rcListener = new RootContextListener();
        }
        return this.rcListener;
    }

    private void initializeWithRootContext(Node rc) {
        this.setIcon(rc.getIcon(1));
        this.setToolTipText(rc.getDisplayName());
        this.setName(rc.getDisplayName());
        this.updateTitle();
        if (this.weakRcL == null) {
            this.weakRcL = WeakListeners.propertyChange((PropertyChangeListener)this.rcListener(), (Object)rc);
        }
        rc.addPropertyChangeListener(this.weakRcL);
        if (this.weakNRcL == null) {
            this.weakNRcL = NodeOp.weakNodeListener((NodeListener)this.rcListener(), (Object)rc);
        }
        rc.addNodeListener(this.weakNRcL);
    }

    protected final void scheduleValidation() {
        this.valid = false;
        SwingUtilities.invokeLater(this);
    }

    public void setName(String name) {
        super.setName(name);
        if (this.view != null) {
            this.view.getAccessibleContext().setAccessibleName(name);
        }
    }

    public void setToolTipText(String text) {
        super.setToolTipText(text);
        if (this.view != null) {
            this.view.getAccessibleContext().setAccessibleDescription(text);
        }
    }

    public static synchronized Tab getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new Tab();
            DEFAULT.scheduleValidation();
        }
        return DEFAULT;
    }

    public static synchronized Tab findDefault() {
        if (DEFAULT == null) {
            TopComponent tc = WindowManager.getDefault().findTopComponent("favorites");
            if (DEFAULT == null) {
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Can not find project component for its ID. Returned " + tc));
                DEFAULT = new Tab();
                DEFAULT.scheduleValidation();
            }
        }
        return DEFAULT;
    }

    public int getPersistenceType() {
        return 0;
    }

    private static Node findClosestNode(DataObject obj, Node start, boolean useLogicalViews) {
        DataObject original = obj;
        Stack<DataObject> stack = new Stack<DataObject>();
        while (obj != null) {
            stack.push(obj);
            DataFolder tmp = obj.getFolder();
            if (tmp == null) {
                FileObject fo = FileUtil.getArchiveFile((FileObject)obj.getPrimaryFile());
                if (fo != null) {
                    try {
                        obj = DataObject.find((FileObject)fo);
                        stack.pop();
                    }
                    catch (DataObjectNotFoundException exc) {
                        obj = null;
                    }
                    continue;
                }
                obj = null;
                continue;
            }
            obj = tmp;
        }
        Node current = start;
        int topIdx = stack.size();
        int i = 0;
        while (i < topIdx) {
            Node n = Tab.findDataObject(current, (DataObject)stack.get(i));
            if (n != null) {
                current = n;
                topIdx = i;
                i = 0;
                continue;
            }
            ++i;
        }
        if (!Tab.check(current, original) && useLogicalViews) {
            Node[] children = current.getChildren().getNodes();
            for (int j = 0; j < children.length; ++j) {
                Node child = children[j];
                Node n = Tab.selectInLogicalViews(original, child);
                if (!Tab.check(n, original)) continue;
                current = n;
                break;
            }
        }
        return current;
    }

    private static Node selectInLogicalViews(DataObject original, Node start) {
        return start;
    }

    private boolean selectNode(DataObject obj, Node root) {
        Node node = Tab.findClosestNode(obj, root, true);
        try {
            this.getExplorerManager().setSelectedNodes(new Node[]{node});
        }
        catch (PropertyVetoException e) {
            throw new IllegalStateException();
        }
        return Tab.check(node, obj);
    }

    private static boolean check(Node node, DataObject obj) {
        DataObject dObj = (DataObject)node.getLookup().lookup(DataObject.class);
        if (obj == dObj) {
            return true;
        }
        return dObj instanceof DataShadow && obj == ((DataShadow)dObj).getOriginal();
    }

    private static Node findDataObject(Node node, DataObject obj) {
        Node[] arr = node.getChildren().getNodes(true);
        for (int i = 0; i < arr.length; ++i) {
            DataShadow ds = (DataShadow)arr[i].getCookie(class$org$openide$loaders$DataShadow == null ? Tab.class$("org.openide.loaders.DataShadow") : class$org$openide$loaders$DataShadow);
            if (ds != null && obj == ds.getOriginal()) {
                return arr[i];
            }
            DataObject o = (DataObject)arr[i].getCookie(class$org$openide$loaders$DataObject == null ? Tab.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
            if (o == null || obj != o) continue;
            return arr[i];
        }
        return null;
    }

    protected void validateRootContext() {
        Node projectsRc = Favorites.getNode();
        this.setRootContext(projectsRc);
    }

    protected boolean containsNode(DataObject obj) {
        Node node = Tab.findClosestNode(obj, this.getExplorerManager().getRootContext(), true);
        return Tab.check(node, obj);
    }

    protected void doSelectNode(DataObject obj) {
        Node root = this.getExplorerManager().getRootContext();
        if (this.selectNode(obj, root)) {
            this.requestActive();
            StatusDisplayer.getDefault().setStatusText("");
        } else {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)Tab.class, (String)"MSG_NodeNotFound"));
        }
    }

    public Object readResolve() throws ObjectStreamException {
        Tab.getDefault().scheduleValidation();
        return Tab.getDefault();
    }

    private final class RootContextListener
    implements NodeListener {
        private RootContextListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            Object source = evt.getSource();
            Node n = (Node)source;
            if ("displayName".equals(propName) || "name".equals(propName)) {
                Tab.this.setName(n.getDisplayName());
            } else if ("icon".equals(propName)) {
                Tab.this.setIcon(n.getIcon(1));
            } else if ("shortDescription".equals(propName)) {
                Tab.this.setToolTipText(n.getShortDescription());
            }
        }

        public void nodeDestroyed(NodeEvent nodeEvent) {
            Tab.this.close();
        }

        public void childrenRemoved(NodeMemberEvent e) {
        }

        public void childrenReordered(NodeReorderEvent e) {
        }

        public void childrenAdded(NodeMemberEvent e) {
        }
    }
}

