/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.multiview;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JTextField;
import org.netbeans.modules.j2ee.dd.api.ejb.EntityAndSession;
import org.netbeans.modules.j2ee.ddloaders.multiview.EjbJarMultiViewDataObject;
import org.netbeans.modules.j2ee.ddloaders.multiview.EntityAndSessionHelper;
import org.netbeans.modules.j2ee.ddloaders.multiview.NonEditableDocument;
import org.netbeans.modules.j2ee.ddloaders.multiview.Utils;
import org.netbeans.modules.j2ee.ddloaders.multiview.ui.EjbImplementationAndInterfacesForm;
import org.netbeans.modules.xml.multiview.ItemCheckBoxHelper;
import org.netbeans.modules.xml.multiview.Refreshable;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataSynchronizer;
import org.netbeans.modules.xml.multiview.cookies.LinkCookie;
import org.netbeans.modules.xml.multiview.ui.LinkButton;
import org.netbeans.modules.xml.multiview.ui.SectionNodeView;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class EjbImplementationAndInterfacesPanel
extends EjbImplementationAndInterfacesForm {
    private EntityAndSessionHelper helper;
    private NonEditableDocument beanClassDocument = new NonEditableDocument(){

        protected String retrieveText() {
            return EjbImplementationAndInterfacesPanel.this.helper == null ? null : EjbImplementationAndInterfacesPanel.this.helper.getEjbClass();
        }
    };
    private NonEditableDocument localComponentDocument = new NonEditableDocument(){

        protected String retrieveText() {
            return EjbImplementationAndInterfacesPanel.this.helper == null ? null : EjbImplementationAndInterfacesPanel.this.helper.getLocal();
        }
    };
    private NonEditableDocument localHomeDocument = new NonEditableDocument(){

        protected String retrieveText() {
            return EjbImplementationAndInterfacesPanel.this.helper == null ? null : EjbImplementationAndInterfacesPanel.this.helper.getLocalHome();
        }
    };
    private NonEditableDocument remoteComponentDocument = new NonEditableDocument(){

        protected String retrieveText() {
            return EjbImplementationAndInterfacesPanel.this.helper == null ? null : EjbImplementationAndInterfacesPanel.this.helper.getRemote();
        }
    };
    private NonEditableDocument remoteHomeDocument = new NonEditableDocument(){

        protected String retrieveText() {
            return EjbImplementationAndInterfacesPanel.this.helper == null ? null : EjbImplementationAndInterfacesPanel.this.helper.getHome();
        }
    };
    private String className = null;
    private static final String LINK_BEAN = "linkBean";
    private static final String LINK_LOCAL = "linkLocal";
    private static final String LINK_LOCAL_HOME = "linkLocalHome";
    private static final String LINK_REMOTE = "linkRemote";
    private static final String LINK_REMOTE_HOME = "linkRemoteHome";

    public EjbImplementationAndInterfacesPanel(SectionNodeView sectionNodeView, final EntityAndSessionHelper helper) {
        super(sectionNodeView);
        this.helper = helper;
        this.getBeanClassTextField().setDocument(this.beanClassDocument);
        this.getLocalComponentTextField().setDocument(this.localComponentDocument);
        this.getLocalHomeTextField().setDocument(this.localHomeDocument);
        this.getRemoteComponentTextField().setDocument(this.remoteComponentDocument);
        this.getRemoteHomeTextField().setDocument(this.remoteHomeDocument);
        final JButton moveClassButton = this.getMoveClassButton();
        final JButton renameClassButton = this.getRenameClassButton();
        this.scheduleRefreshView();
        FocusAdapter focusListener = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                Component component = e.getComponent();
                if (component instanceof JTextField) {
                    EjbImplementationAndInterfacesPanel.this.className = ((JTextField)component).getText().trim();
                    boolean enabled = EjbImplementationAndInterfacesPanel.this.className.length() > 0;
                    moveClassButton.setEnabled(enabled);
                    renameClassButton.setEnabled(enabled);
                } else {
                    boolean isRefactorButton;
                    boolean bl = isRefactorButton = component == moveClassButton || component == renameClassButton;
                    if (moveClassButton.isEnabled()) {
                        moveClassButton.setEnabled(isRefactorButton);
                    }
                    if (renameClassButton.isEnabled()) {
                        renameClassButton.setEnabled(isRefactorButton);
                    }
                }
            }
        };
        this.addFocusListener(focusListener);
        moveClassButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Utils.activateMoveClassUI(EjbImplementationAndInterfacesPanel.this.className);
                moveClassButton.setEnabled(false);
                renameClassButton.setEnabled(false);
            }
        });
        renameClassButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Utils.activateRenameClassUI(EjbImplementationAndInterfacesPanel.this.className);
                moveClassButton.setEnabled(false);
                renameClassButton.setEnabled(false);
            }
        });
        XmlMultiViewDataSynchronizer synchronizer = ((EjbJarMultiViewDataObject)sectionNodeView.getDataObject()).getModelSynchronizer();
        this.addRefreshable((Refreshable)new ItemCheckBoxHelper(synchronizer, this.getLocalInterfaceCheckBox()){

            public boolean getItemValue() {
                boolean value = helper.getLocal() != null;
                EjbImplementationAndInterfacesPanel.this.getLocalComponentLinkButton().setVisible(value);
                EjbImplementationAndInterfacesPanel.this.getLocalHomeLinkButton().setVisible(value);
                return value;
            }

            public void setItemValue(boolean value) {
                if (value != this.getItemValue()) {
                    if (value) {
                        EjbImplementationAndInterfacesPanel.this.addInterfaces(true);
                    } else {
                        EjbImplementationAndInterfacesPanel.this.removeInterfaces(true);
                    }
                    this.refresh();
                }
            }
        });
        this.addRefreshable((Refreshable)new ItemCheckBoxHelper(synchronizer, this.getRemoteInterfaceCheckBox()){

            public boolean getItemValue() {
                boolean value = helper.getRemote() != null;
                EjbImplementationAndInterfacesPanel.this.getRemoteComponentLinkButton().setVisible(value);
                EjbImplementationAndInterfacesPanel.this.getRemoteHomeLinkButton().setVisible(value);
                return value;
            }

            public void setItemValue(boolean value) {
                if (value != this.getItemValue()) {
                    if (value) {
                        EjbImplementationAndInterfacesPanel.this.addInterfaces(false);
                    } else {
                        EjbImplementationAndInterfacesPanel.this.removeInterfaces(false);
                    }
                    this.refresh();
                }
            }
        });
        this.initLinkButton(this.getBeanClassLinkButton(), LINK_BEAN);
        this.initLinkButton(this.getLocalComponentLinkButton(), LINK_LOCAL);
        this.initLinkButton(this.getLocalHomeLinkButton(), LINK_LOCAL_HOME);
        this.initLinkButton(this.getRemoteComponentLinkButton(), LINK_REMOTE);
        this.initLinkButton(this.getRemoteHomeLinkButton(), LINK_REMOTE_HOME);
    }

    private void initLinkButton(AbstractButton button, String key) {
        LinkButton.initLinkButton((AbstractButton)button, (LinkCookie)this, null, (String)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInterfaces(boolean local) {
        String interfaceType = Utils.getBundleMessage(local ? "TXT_Local" : "TXT_Remote");
        String msg = Utils.getBundleMessage("MSG_AddInterfaces", interfaceType);
        String title = Utils.getBundleMessage("LBL_AddInterfaces");
        NotifyDescriptor descriptor = new NotifyDescriptor((Object)msg, title, 0, 3, null, null);
        DialogDisplayer.getDefault().notify(descriptor);
        if (NotifyDescriptor.YES_OPTION == descriptor.getValue()) {
            try {
                this.helper.addInterfaces(local);
            }
            finally {
                this.scheduleRefreshView();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeInterfaces(boolean local) {
        String componentInterface = local ? this.helper.getLocal() : this.helper.getRemote();
        String homeInterface = local ? this.helper.getLocalHome() : this.helper.getHome();
        String businessInterfaceName = this.helper.getBusinessInterfaceName(local);
        String msg = businessInterfaceName == null ? Utils.getBundleMessage("MSG_RemoveInterfaces", homeInterface, componentInterface) : Utils.getBundleMessage("MSG_RemoveInterfaces2", homeInterface, componentInterface, businessInterfaceName);
        String interfaceType = Utils.getBundleMessage(local ? "TXT_Local" : "TXT_Remote");
        String title = Utils.getBundleMessage("LBL_RemoveInterfaces", interfaceType);
        NotifyDescriptor descriptor = new NotifyDescriptor((Object)msg, title, 0, 2, null, null);
        DialogDisplayer.getDefault().notify(descriptor);
        if (NotifyDescriptor.YES_OPTION == descriptor.getValue()) {
            try {
                this.helper.removeInterfaces(local);
            }
            finally {
                this.scheduleRefreshView();
            }
        }
    }

    public void refreshView() {
        this.beanClassDocument.init();
        this.localComponentDocument.init();
        this.localHomeDocument.init();
        this.remoteComponentDocument.init();
        this.remoteHomeDocument.init();
        String localComponent = this.helper.getLocal();
        boolean isLocal = localComponent != null;
        this.getLocalInterfaceCheckBox().setSelected(isLocal);
        String remoteComponent = this.helper.getRemote();
        boolean isRemote = remoteComponent != null;
        this.getRemoteInterfaceCheckBox().setSelected(isRemote);
    }

    public void dataModelPropertyChange(Object source, String propertyName, Object oldValue, Object newValue) {
        if (source instanceof EntityAndSession) {
            this.scheduleRefreshView();
        }
    }

    public void linkButtonPressed(Object ddBean, String ddProperty) {
        Object javaClass = ddProperty == LINK_BEAN ? this.helper.getBeanClass() : (ddProperty == LINK_LOCAL ? this.helper.getLocalBusinessInterfaceClass() : (ddProperty == LINK_LOCAL_HOME ? this.helper.getLocalHomeInterfaceClass() : (ddProperty == LINK_REMOTE ? this.helper.getRemoteBusinessInterfaceClass() : (ddProperty == LINK_REMOTE_HOME ? this.helper.getHomeInterfaceClass() : null))));
        if (javaClass != null) {
            Utils.openEditorFor(this.helper.ejbJarFile, javaClass);
        }
    }
}

