/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean;

import java.util.Map;
import java.util.ResourceBundle;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import org.netbeans.modules.j2ee.sun.share.configbean.Base;
import org.netbeans.modules.j2ee.sun.share.configbean.DCBFactory;
import org.netbeans.modules.j2ee.sun.share.configbean.Error;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;

public class DCBFactoryMgr {
    protected static final ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.Bundle");
    private Map factoryMap;
    private String beanBaseXpath;

    public DCBFactoryMgr(Map xPathFactoryMap, String baseXpath) {
        this.factoryMap = xPathFactoryMap;
        this.beanBaseXpath = baseXpath;
        if (!Utils.hasTrailingSlash(this.beanBaseXpath)) {
            this.beanBaseXpath = this.beanBaseXpath + "/";
        }
    }

    public Base createDCB(DDBean ddBean, Base dcbParent) throws ConfigurationException {
        Base dcbResult = null;
        if (dcbResult == null) {
            String ddBeanRelativeXPath = this.makeRelative(ddBean.getXpath());
            DCBFactory factory = (DCBFactory)this.factoryMap.get(ddBeanRelativeXPath);
            if (factory != null) {
                dcbResult = factory.createDCB(ddBean, dcbParent);
                if (null == dcbResult) {
                    dcbResult = new Error();
                    dcbResult.init(ddBean, dcbParent);
                }
            } else {
                Object[] args = new Object[]{ddBean.getXpath()};
                throw Utils.makeCE("ERR_BadFactoryMapping", args, null);
            }
        }
        return dcbResult;
    }

    public String[] getFactoryKeys() {
        return this.factoryMap.keySet().toArray(new String[this.factoryMap.size()]);
    }

    private String makeRelative(String xpath) {
        String result = xpath.startsWith(this.beanBaseXpath) ? xpath.substring(this.beanBaseXpath.length()) : (!xpath.startsWith("/") ? xpath : xpath);
        return result;
    }
}

