/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.handler;

import com.sun.xml.ws.client.ServiceContext;
import com.sun.xml.ws.handler.HandlerChainsModel;
import com.sun.xml.ws.util.HandlerAnnotationInfo;
import com.sun.xml.ws.util.HandlerAnnotationProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerResolverImpl
implements HandlerResolver {
    private HandlerChainsModel handlerModel;
    private Map<PortInfo, List<Handler>> chainMap;
    private ServiceContext serviceContext;
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.handler");

    public HandlerResolverImpl(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
        this.handlerModel = HandlerAnnotationProcessor.buildHandlerChainsModel(serviceContext.getServiceClass());
        this.chainMap = new HashMap<PortInfo, List<Handler>>();
    }

    @Override
    public List<Handler> getHandlerChain(PortInfo info) {
        HandlerAnnotationInfo chainInfo;
        List<Handler> chain = this.chainMap.get(info);
        if (chain != null) {
            return chain;
        }
        if (this.handlerModel != null && (chainInfo = this.handlerModel.getHandlersForPortInfo(info)) != null) {
            chain = chainInfo.getHandlers();
            this.serviceContext.setRoles(info.getPortName(), chainInfo.getRoles());
        }
        if (chain == null) {
            if (logger.isLoggable(Level.FINE)) {
                this.logGetChain(info);
            }
            chain = new ArrayList<Handler>();
        }
        this.chainMap.put(info, chain);
        return chain;
    }

    private void logGetChain(PortInfo info) {
        logger.fine("No handler chain found for port info:");
        this.logPortInfo(info, Level.FINE);
        logger.fine("Existing handler chains:");
        if (this.chainMap.isEmpty()) {
            logger.fine("none");
        } else {
            for (PortInfo key : this.chainMap.keySet()) {
                logger.fine(this.chainMap.get(key).size() + " handlers for port info ");
                this.logPortInfo(key, Level.FINE);
            }
        }
    }

    private void logPortInfo(PortInfo info, Level level) {
        logger.log(level, "binding: " + info.getBindingID() + "\nservice: " + info.getServiceName() + "\nport: " + info.getPortName());
    }
}

