/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.openide.text.ActiveEditorDrop;
import org.openide.windows.TopComponent;

final class QuietEditorPane
extends JEditorPane {
    static final int FIRE = 1;
    static final int PAINT = 2;
    static final int ALL = 3;
    private int lastPosition = -1;
    int working = 1;
    private int fontHeight;
    private int charWidth;
    static /* synthetic */ Class class$org$openide$windows$TopComponent;
    static /* synthetic */ Class class$javax$swing$JComponent;
    static /* synthetic */ Class class$java$awt$datatransfer$Transferable;

    static DataFlavor constructActiveEditorDropFlavor() {
        try {
            return new DataFlavor("text/active_editor_flavor;class=org.openide.text.ActiveEditorDrop", "Active Editor Flavor", QuietEditorPane.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    public QuietEditorPane() {
        this.setFontHeightWidth(this.getFont());
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.setFontHeightWidth(this.getFont());
    }

    private void setFontHeightWidth(Font font) {
        FontMetrics metrics = this.getFontMetrics(font);
        this.fontHeight = metrics.getHeight();
        this.charWidth = metrics.charWidth('m');
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        switch (orientation) {
            case 1: {
                return this.fontHeight;
            }
            case 0: {
                return this.charWidth;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + orientation);
    }

    public void setDocument(Document doc) {
        super.setDocument(doc);
        if (doc != null) {
            TransferHandler thn = this.getTransferHandler();
            DelegatingTransferHandler dth = new DelegatingTransferHandler(thn);
            this.setTransferHandler(dth);
        }
    }

    public void setWorking(int x) {
        this.working = x;
    }

    public void firePropertyChange(String s, Object val1, Object val2) {
        if ((this.working & 1) != 0) {
            super.firePropertyChange(s, val1, val2);
        }
    }

    public void setCaret(Caret caret) {
        Caret oldCaret;
        if (caret == null && (oldCaret = this.getCaret()) != null) {
            this.lastPosition = oldCaret.getDot();
        }
        super.setCaret(caret);
    }

    int getLastPosition() {
        return this.lastPosition;
    }

    public void revalidate() {
        if ((this.working & 2) != 0) {
            super.revalidate();
        }
    }

    public void repaint() {
        if ((this.working & 2) != 0) {
            super.repaint();
        }
    }

    private class DelegatingTransferHandler
    extends TransferHandler {
        TransferHandler delegator;

        public DelegatingTransferHandler(TransferHandler delegator) {
            this.delegator = delegator;
        }

        public void exportAsDrag(JComponent comp, InputEvent e, int action) {
            this.delegator.exportAsDrag(comp, e, action);
        }

        public void exportToClipboard(JComponent comp, Clipboard clip, int action) {
            this.delegator.exportToClipboard(comp, clip, action);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean importData(JComponent comp, Transferable t) {
            block5: {
                try {
                    Object obj;
                    if (!t.isDataFlavorSupported(ActiveEditorDrop.FLAVOR) || !((obj = t.getTransferData(ActiveEditorDrop.FLAVOR)) instanceof ActiveEditorDrop) || !(comp instanceof JTextComponent)) break block5;
                    boolean success = false;
                    try {
                        success = ((ActiveEditorDrop)obj).handleTransfer((JTextComponent)comp);
                    }
                    finally {
                        this.requestFocus(comp);
                    }
                    return success;
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
            return this.delegator.importData(comp, t);
        }

        private void requestFocus(JComponent comp) {
            Container container = SwingUtilities.getAncestorOfClass(class$org$openide$windows$TopComponent == null ? (class$org$openide$windows$TopComponent = QuietEditorPane.class$("org.openide.windows.TopComponent")) : class$org$openide$windows$TopComponent, comp);
            if (container != null) {
                ((TopComponent)container).requestActive();
            } else {
                Container f = comp;
                while (!((f = f.getParent()) instanceof Frame) && f != null) {
                }
                if (f != null) {
                    f.requestFocus();
                }
                comp.requestFocus();
            }
        }

        public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
            for (int i = 0; i < transferFlavors.length; ++i) {
                if (transferFlavors[i] != ActiveEditorDrop.FLAVOR) continue;
                return true;
            }
            return this.delegator.canImport(comp, transferFlavors);
        }

        public int getSourceActions(JComponent c) {
            return this.delegator.getSourceActions(c);
        }

        public Icon getVisualRepresentation(Transferable t) {
            return this.delegator.getVisualRepresentation(t);
        }

        protected void exportDone(JComponent source, Transferable data, int action) {
            try {
                Method method = this.delegator.getClass().getDeclaredMethod("exportDone", class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = QuietEditorPane.class$("javax.swing.JComponent")) : class$javax$swing$JComponent, class$java$awt$datatransfer$Transferable == null ? (class$java$awt$datatransfer$Transferable = QuietEditorPane.class$("java.awt.datatransfer.Transferable")) : class$java$awt$datatransfer$Transferable, Integer.TYPE);
                method.setAccessible(true);
                method.invoke((Object)this.delegator, source, data, new Integer(action));
            }
            catch (NoSuchMethodException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
        }

        protected Transferable createTransferable(JComponent comp) {
            try {
                Method method = this.delegator.getClass().getDeclaredMethod("createTransferable", class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = QuietEditorPane.class$("javax.swing.JComponent")) : class$javax$swing$JComponent);
                method.setAccessible(true);
                return (Transferable)method.invoke((Object)this.delegator, comp);
            }
            catch (NoSuchMethodException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
            return null;
        }
    }
}

