/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.slides;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.netbeans.core.windows.Constants;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.view.ModeView;
import org.netbeans.core.windows.view.SlidingView;
import org.netbeans.core.windows.view.ViewElement;
import org.netbeans.core.windows.view.dnd.TopComponentDroppable;
import org.netbeans.core.windows.view.dnd.WindowDnDManager;
import org.netbeans.core.windows.view.ui.AbstractModeContainer;
import org.netbeans.core.windows.view.ui.ModeComponent;
import org.netbeans.core.windows.view.ui.Tabbed;
import org.netbeans.core.windows.view.ui.slides.TabbedSlideAdapter;
import org.openide.windows.TopComponent;

public final class SlideBarContainer
extends AbstractModeContainer {
    VisualPanel panel = new VisualPanel(this);

    public SlideBarContainer(ModeView modeView, WindowDnDManager windowDnDManager) {
        super(modeView, windowDnDManager, 2);
        this.panel.setBorder(SlideBarContainer.computeBorder(this.getSlidingView().getSide()));
        this.panel.add(this.tabbedHandler.getComponent(), "Center");
    }

    private SlidingView getSlidingView() {
        return (SlidingView)super.getModeView();
    }

    public void requestAttention(TopComponent tc) {
        this.tabbedHandler.requestAttention(tc);
    }

    public void cancelRequestAttention(TopComponent tc) {
        this.tabbedHandler.cancelRequestAttention(tc);
    }

    public void setTopComponents(TopComponent[] tcs, TopComponent selected) {
        super.setTopComponents(tcs, selected);
    }

    public Rectangle getTabBounds(int tabIndex) {
        return this.tabbedHandler.getTabBounds(tabIndex);
    }

    protected Component getModeComponent() {
        return this.panel;
    }

    protected Tabbed createTabbed() {
        return new TabbedSlideAdapter(((SlidingView)this.modeView).getSide());
    }

    protected boolean isAttachingPossible() {
        return false;
    }

    protected TopComponentDroppable getModeDroppable() {
        return this.panel;
    }

    protected void updateActive(boolean active) {
        Window window;
        if (active && (window = SwingUtilities.getWindowAncestor(this.panel)) != null && !window.isActive() && WindowManagerImpl.getInstance().getEditorAreaState() == 1) {
            window.toFront();
        }
    }

    public boolean isActive() {
        Window window = SwingUtilities.getWindowAncestor(this.panel);
        return window == null ? false : window.isActive();
    }

    protected void updateTitle(String title) {
    }

    private static Border computeBorder(String orientation) {
        int bottom = 0;
        int left = 0;
        int right = 0;
        int top = 0;
        if ("left".equals(orientation)) {
            top = 1;
            left = 1;
            bottom = 1;
            right = 2;
        }
        if ("bottom".equals(orientation)) {
            top = 2;
            left = 1;
            bottom = 1;
            right = 1;
        }
        if ("right".equals(orientation)) {
            top = 1;
            left = 2;
            bottom = 1;
            right = 1;
        }
        return new EmptyBorder(top, left, bottom, right);
    }

    private static class VisualPanel
    extends JPanel
    implements ModeComponent,
    TopComponentDroppable {
        private final SlideBarContainer modeContainer;

        public VisualPanel(SlideBarContainer modeContainer) {
            super(new BorderLayout());
            this.modeContainer = modeContainer;
            this.enableEvents(16L);
        }

        public ModeView getModeView() {
            return this.modeContainer.getModeView();
        }

        public int getKind() {
            return this.modeContainer.getKind();
        }

        public Shape getIndicationForLocation(Point location) {
            return this.modeContainer.getIndicationForLocation(location);
        }

        public Object getConstraintForLocation(Point location) {
            return this.modeContainer.getConstraintForLocation(location);
        }

        public Component getDropComponent() {
            return this.modeContainer.getDropComponent();
        }

        public ViewElement getDropViewElement() {
            return this.modeContainer.getDropModeView();
        }

        public boolean canDrop(TopComponent transfer, Point location) {
            return this.modeContainer.canDrop(transfer);
        }

        public boolean supportsKind(int kind, TopComponent transfer) {
            if (Constants.SWITCH_MODE_ADD_NO_RESTRICT || WindowManagerImpl.getInstance().isTopComponentAllowedToMoveAnywhere(transfer)) {
                return true;
            }
            boolean isNonEditor = kind == 0 || kind == 2;
            boolean thisIsNonEditor = this.getKind() == 0 || this.getKind() == 2;
            return isNonEditor == thisIsNonEditor;
        }

        public Dimension getMinimumSize() {
            if (this.modeContainer.getTopComponents().length == 0) {
                Border b = this.getBorder();
                if (null != b) {
                    Insets insets = b.getBorderInsets(this);
                    return new Dimension(Math.max(1, insets.left + insets.right), Math.max(1, insets.top + insets.bottom));
                }
                return new Dimension(1, 1);
            }
            Dimension retValue = super.getMinimumSize();
            return retValue;
        }
    }
}

