/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.toolbars;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.netbeans.core.IDESettings;
import org.netbeans.core.NbPlaces;
import org.netbeans.core.windows.view.ui.toolbars.ConfigureToolbarPanel;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarConstraints;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarDnDListener;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarLayout;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarProcessor;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarRow;
import org.openide.ErrorManager;
import org.openide.awt.JPopupMenuPlus;
import org.openide.awt.Toolbar;
import org.openide.awt.ToolbarPool;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.XMLDataObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.xml.sax.AttributeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public final class ToolbarConfiguration
implements ToolbarPool.Configuration,
PropertyChangeListener {
    protected static final String TOOLBAR_DTD_WEB = "http://www.netbeans.org/dtds/toolbar.dtd";
    protected static final String TOOLBAR_DTD_PUBLIC_ID = "-//NetBeans IDE//DTD toolbar//EN";
    protected static final Class TOOLBAR_PROCESSOR_CLASS = ToolbarProcessor.class;
    protected static final String TOOLBAR_ICON_BASE = "/org/netbeans/core/windows/toolbars/xmlToolbars";
    private static ErrorManager ERR = ErrorManager.getDefault().getInstance("org.netbeans.core.windows.toolbars");
    private volatile long lastReload;
    protected static final String EXT_XML = "xml";
    protected static final String TAG_CONFIG = "Configuration";
    protected static final String TAG_ROW = "Row";
    protected static final String TAG_TOOLBAR = "Toolbar";
    protected static final String ATT_TOOLBAR_NAME = "name";
    protected static final String ATT_TOOLBAR_POSITION = "position";
    protected static final String ATT_TOOLBAR_VISIBLE = "visible";
    private static JPanel toolbarPanel;
    private static WeakHashMap confs2Names;
    private ToolbarLayout toolbarLayout;
    private ToolbarDnDListener toolbarListener;
    private WeakHashMap allToolbars;
    private Vector toolbarRows;
    private HashMap invisibleToolbars;
    private static JMenu toolbarMenu;
    private WeakHashMap waitingToolbars;
    private String configName;
    private String configDisplayName;
    private int prefWidth;
    private final ThreadLocal WRITE_IN_PROGRESS = new ThreadLocal();
    private int lastConfigurationHash = -1;
    PropertyChangeSupport pcs;

    public ToolbarConfiguration(String name, String displayName) {
        this.configName = name;
        this.configDisplayName = displayName;
        if (this.configDisplayName.endsWith(".xml")) {
            this.configDisplayName = this.configDisplayName.substring(0, this.configDisplayName.length() - ".xml".length());
        }
        this.initInstance();
        confs2Names.put(this, name);
    }

    public ToolbarConfiguration(XMLDataObject xml) throws IOException {
        this(xml.getNodeDelegate().getName(), xml.getNodeDelegate().getDisplayName());
        this.readConfig(xml);
    }

    private void readConfig(XMLDataObject xml) throws IOException {
        Parser parser = xml.createParser();
        ToolbarParser handler = new ToolbarParser();
        parser.setEntityResolver(handler);
        parser.setDocumentHandler(handler);
        InputStream is = null;
        try {
            is = xml.getPrimaryFile().getInputStream();
            parser.parse(new InputSource(is));
        }
        catch (Exception saxe) {
            IOException ex = new IOException(saxe.toString());
            ErrorManager.getDefault().annotate((Throwable)ex, (Throwable)saxe);
            throw ex;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException exc) {
                ErrorManager.getDefault().notify(1, (Throwable)exc);
            }
        }
        this.checkToolbarRows();
    }

    private void initInstance() {
        this.allToolbars = new WeakHashMap();
        this.waitingToolbars = new WeakHashMap();
        this.toolbarRows = new Vector();
        this.invisibleToolbars = new HashMap();
        this.toolbarListener = new ToolbarDnDListener(this);
    }

    static final String getBundleString(String bundleStr) {
        return NbBundle.getMessage((Class)ToolbarConfiguration.class, (String)bundleStr);
    }

    public static final ToolbarConfiguration findConfiguration(String name) {
        Map.Entry curEntry = null;
        Iterator iter = confs2Names.entrySet().iterator();
        while (iter.hasNext()) {
            curEntry = iter.next();
            if (!name.equals((String)curEntry.getValue())) continue;
            return (ToolbarConfiguration)curEntry.getKey();
        }
        return null;
    }

    void addToolbar(ToolbarRow row, ToolbarConstraints tc) {
        if (tc == null) {
            return;
        }
        if (tc.isVisible()) {
            row.addToolbar(tc);
        } else {
            int rI = row == null ? this.toolbarRows.size() : this.toolbarRows.indexOf(row);
            this.invisibleToolbars.put(tc, new Integer(rI));
        }
        this.allToolbars.put(tc.getName(), tc);
    }

    ToolbarConstraints removeToolbar(String name) {
        ToolbarConstraints tc = (ToolbarConstraints)this.allToolbars.remove(name);
        if (tc.destroy()) {
            this.checkToolbarRows();
        }
        return tc;
    }

    void addRow(ToolbarRow row) {
        this.addRow(row, this.toolbarRows.size());
    }

    void addRow(ToolbarRow row, int index) {
        ToolbarRow prev = null;
        ToolbarRow next = null;
        int rowCount = this.toolbarRows.size();
        if (index > 0 && index <= rowCount) {
            prev = (ToolbarRow)this.toolbarRows.elementAt(index - 1);
        }
        if (index >= 0 && index < rowCount) {
            next = (ToolbarRow)this.toolbarRows.elementAt(index);
        }
        if (prev != null) {
            prev.setNextRow(row);
        }
        row.setPrevRow(prev);
        row.setNextRow(next);
        if (next != null) {
            next.setPrevRow(row);
        }
        this.toolbarRows.insertElementAt(row, index);
        this.updateBounds(row);
    }

    void removeRow(ToolbarRow row) {
        ToolbarRow prev = row.getPrevRow();
        ToolbarRow next = row.getNextRow();
        if (prev != null) {
            prev.setNextRow(next);
        }
        if (next != null) {
            next.setPrevRow(prev);
        }
        this.toolbarRows.removeElement(row);
        this.updateBounds(next);
        this.revalidateWindow();
    }

    void updateBounds(ToolbarRow row) {
        while (row != null) {
            row.updateBounds();
            row = row.getNextRow();
        }
    }

    private static final ToolbarPool toolbarPool() {
        return ToolbarPool.getDefault();
    }

    void revalidateWindow() {
        Window w;
        ToolbarConfiguration.toolbarPanel().revalidate();
        IDESettings settings = (IDESettings)IDESettings.findObject((Class)IDESettings.class, (boolean)true);
        int uiMode = settings.getUIMode();
        if (uiMode == 1 && (w = SwingUtilities.windowForComponent(ToolbarConfiguration.toolbarPanel())) != null) {
            int width = ToolbarConfiguration.toolbarPanel().getRootPane().getSize().width;
            int height = ToolbarConfiguration.toolbarPanel().getRootPane().getPreferredSize().height;
            Insets insets = w.getInsets();
            w.setSize(new Dimension(width + insets.left + insets.right, height + insets.top + insets.bottom));
            w.validate();
        }
    }

    int rowIndex(ToolbarRow row) {
        return this.toolbarRows.indexOf(row);
    }

    void updatePrefWidth() {
        Iterator it = this.toolbarRows.iterator();
        this.prefWidth = 0;
        while (it.hasNext()) {
            this.prefWidth = Math.max(this.prefWidth, ((ToolbarRow)it.next()).getPrefWidth());
        }
    }

    int getPrefWidth() {
        return this.prefWidth;
    }

    int getPrefHeight() {
        if (this.getRowCount() == 0) {
            return 0;
        }
        ToolbarRow lastRow = (ToolbarRow)this.toolbarRows.lastElement();
        return this.getRowVertLocation(lastRow) + lastRow.getPreferredHeight();
    }

    void checkToolbarRows() {
        Object[] rows = this.toolbarRows.toArray();
        for (int i = rows.length - 1; i >= 0; --i) {
            ToolbarRow row = (ToolbarRow)rows[i];
            if (!row.isEmpty()) continue;
            this.removeRow(row);
        }
    }

    int getRowCount() {
        return this.toolbarRows.size();
    }

    ToolbarConstraints getToolbarConstraints(String name) {
        return (ToolbarConstraints)this.allToolbars.get(name);
    }

    ToolbarConstraints checkToolbarConstraints(String name, Integer position, Boolean visible, int toolbarIndex) {
        ToolbarConstraints tc = (ToolbarConstraints)this.allToolbars.get(name);
        if (tc == null) {
            tc = new ToolbarConstraints(this, name, position, visible, toolbarIndex);
        } else {
            tc.checkNextPosition(position, visible);
        }
        return tc;
    }

    boolean checkConfigurationOver() {
        ToolbarConstraints tc;
        String name;
        int i;
        boolean change = false;
        Object[] waNas = this.waitingToolbars.keySet().toArray();
        Object[] names = this.allToolbars.keySet().toArray();
        for (i = 0; i < waNas.length; ++i) {
            name = (String)waNas[i];
            if (ToolbarConfiguration.toolbarPool().findToolbar(name) == null) continue;
            tc = (ToolbarConstraints)this.waitingToolbars.remove(name);
            this.allToolbars.put(name, tc);
            this.addVisible(tc);
            change = true;
        }
        for (i = 0; i < names.length; ++i) {
            name = (String)names[i];
            if (ToolbarConfiguration.toolbarPool().findToolbar(name) != null) continue;
            tc = this.removeToolbar(name);
            this.waitingToolbars.put(name, tc);
            this.invisibleToolbars.put(tc, new Integer(tc.rowIndex()));
            change = true;
        }
        if (change || Utilities.arrayHashCode((Object[])ToolbarConfiguration.toolbarPool().getConfigurations()) != this.lastConfigurationHash) {
            this.rebuildMenu();
        }
        return change;
    }

    void refresh() {
        this.rebuildPanel();
        this.rebuildMenu();
    }

    private void rebuildMenu() {
        if (toolbarMenu != null) {
            toolbarMenu.removeAll();
            this.fillToolbarsMenu(toolbarMenu);
            this.revalidateWindow();
        }
    }

    private void removeVisible(ToolbarConstraints tc) {
        this.invisibleToolbars.put(tc, new Integer(tc.rowIndex()));
        if (tc.destroy()) {
            this.checkToolbarRows();
        }
        tc.setVisible(false);
    }

    private void addVisible(ToolbarConstraints tc) {
        int rC = this.toolbarRows.size();
        int pos = (Integer)this.invisibleToolbars.remove(tc);
        tc.setVisible(true);
        for (int i = pos; i < pos + tc.getRowCount(); ++i) {
            this.getRow(i).addToolbar(tc, tc.getPosition());
        }
        if (rC != this.toolbarRows.size()) {
            this.revalidateWindow();
        }
    }

    ToolbarRow getRow(int rI) {
        ToolbarRow row;
        int s = this.toolbarRows.size();
        if (rI < 0) {
            row = new ToolbarRow(this);
            this.addRow(row, 0);
        } else if (rI >= s) {
            row = new ToolbarRow(this);
            this.addRow(row);
        } else {
            row = (ToolbarRow)this.toolbarRows.elementAt(rI);
        }
        return row;
    }

    ToolbarRow createLastRow() {
        return this.getRow(this.toolbarRows.size());
    }

    void reactivatePanel(boolean someBarRemoved, boolean writeAtAll) {
        ToolbarConfiguration.toolbarPanel().removeAll();
        this.prefWidth = 0;
        Toolbar[] tbs = ToolbarConfiguration.toolbarPool().getToolbars();
        ToolbarRow lastRow = null;
        for (int i = 0; i < tbs.length; ++i) {
            Toolbar tb = tbs[i];
            String name = tb.getName();
            ToolbarConstraints tc = (ToolbarConstraints)this.allToolbars.get(name);
            if (tc == null) {
                if (lastRow == null) {
                    lastRow = this.toolbarRows.isEmpty() ? this.createLastRow() : this.getRow(this.toolbarRows.size() - 1);
                }
                tc = new ToolbarConstraints(this, name, null, Boolean.TRUE);
                this.addToolbar(lastRow, tc);
            }
            ToolbarConfiguration.toolbarPanel().add((Component)tb, tc);
        }
        this.revalidateWindow();
    }

    private void rebuildPanel() {
        ToolbarConfiguration.toolbarPanel().removeAll();
        this.prefWidth = 0;
        Toolbar[] tbs = ToolbarConfiguration.toolbarPool().getToolbars();
        ToolbarRow newRow = null;
        boolean smallToolbarIcons = ToolbarPool.getDefault().getPreferredIconSize() == 16;
        for (int i = 0; i < tbs.length; ++i) {
            Toolbar tb = tbs[i];
            String name = tb.getName();
            Component[] comps = tb.getComponents();
            for (int j = 0; j < comps.length; ++j) {
                if (!(comps[j] instanceof JComponent)) continue;
                if (smallToolbarIcons) {
                    ((JComponent)comps[j]).putClientProperty("PreferredIconSize", null);
                    continue;
                }
                ((JComponent)comps[j]).putClientProperty("PreferredIconSize", new Integer(24));
            }
            ToolbarConstraints tc = (ToolbarConstraints)this.allToolbars.get(name);
            if (tc == null) {
                if (newRow == null) {
                    newRow = this.createLastRow();
                }
                tc = new ToolbarConstraints(this, name, null, Boolean.TRUE);
                this.addToolbar(newRow, tc);
            }
            ToolbarConfiguration.toolbarPanel().add((Component)tb, tc);
        }
        this.revalidateWindow();
    }

    boolean isImportantActivateComponent() {
        Toolbar[] toolbars;
        Object[] names = this.allToolbars.keySet().toArray();
        if (names.length != (toolbars = ToolbarConfiguration.toolbarPool().getToolbars()).length) {
            return true;
        }
        return !this.configName.equals(ToolbarConfiguration.toolbarPool().getConfiguration());
    }

    void reflectChanges() {
        try {
            this.writeDocument();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Component activate() {
        return this.activate(this.isImportantActivateComponent(), true);
    }

    private Component activate(boolean isImportant, boolean writeAtAll) {
        ToolbarConfiguration.toolbarPool().setToolbarsListener((Toolbar.DnDListener)this.toolbarListener);
        boolean someBarRemoved = this.checkConfigurationOver();
        if (isImportant || someBarRemoved) {
            this.toolbarLayout = new ToolbarLayout(this);
            ToolbarConfiguration.toolbarPanel().setLayout(this.toolbarLayout);
            this.reactivatePanel(someBarRemoved, writeAtAll);
            this.rebuildMenu();
        }
        return ToolbarConfiguration.toolbarPanel();
    }

    public String getName() {
        return this.configName;
    }

    public String getDisplayName() {
        return this.configDisplayName;
    }

    public JPopupMenu getContextMenu() {
        JPopupMenuPlus menu = new JPopupMenuPlus();
        this.fillToolbarsMenu((JComponent)menu);
        return menu;
    }

    public JMenu getToolbarsMenu(JMenu menu) {
        this.fillToolbarsMenu(menu);
        toolbarMenu = menu;
        return menu;
    }

    private void fillToolbarsMenu(JComponent menu) {
        this.lastConfigurationHash = Utilities.arrayHashCode((Object[])ToolbarPool.getDefault().getConfigurations());
        Iterator<Toolbar> it = Arrays.asList(ToolbarPool.getDefault().getToolbars()).iterator();
        while (it.hasNext()) {
            final Toolbar tb = it.next();
            final String tbName = tb.getName();
            ToolbarConstraints tc = (ToolbarConstraints)this.allToolbars.get(tb.getName());
            if (tc == null || tb == null) {
                this.checkConfigurationOver();
            }
            if (tc == null || tb == null) continue;
            JCheckBoxMenuItem mi = new JCheckBoxMenuItem(tb.getDisplayName(), tc.isVisible());
            mi.putClientProperty("ToolbarName", tbName);
            mi.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    ToolbarConstraints tc = (ToolbarConstraints)ToolbarConfiguration.this.allToolbars.get(tbName);
                    ToolbarConfiguration.this.setToolbarVisible(tb, !tc.isVisible());
                }
            });
            menu.add(mi);
        }
        menu.add(new JPopupMenu.Separator());
        boolean smallToolbarIcons = ToolbarPool.getDefault().getPreferredIconSize() == 16;
        JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem(ToolbarConfiguration.getBundleString("PROP_smallToolbarIcons"), smallToolbarIcons);
        cbmi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                if (ev.getSource() instanceof JCheckBoxMenuItem) {
                    JCheckBoxMenuItem cb = (JCheckBoxMenuItem)ev.getSource();
                    boolean state = cb.getState();
                    if (state) {
                        ToolbarPool.getDefault().setPreferredIconSize(16);
                    } else {
                        ToolbarPool.getDefault().setPreferredIconSize(24);
                    }
                    String name = ToolbarPool.getDefault().getConfiguration();
                    ToolbarConfiguration tbConf = ToolbarConfiguration.findConfiguration(name);
                    if (tbConf != null) {
                        tbConf.rebuildPanel();
                    }
                    ToolbarConfiguration.this.rebuildMenu();
                }
            }
        });
        menu.add(cbmi);
        menu.add(new JPopupMenu.Separator());
        JMenuItem menuItem = new JMenuItem(ToolbarConfiguration.getBundleString("CTL_CustomizeToolbars"));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ConfigureToolbarPanel.showConfigureDialog();
            }
        });
        menu.add(menuItem);
    }

    public void setToolbarVisible(Toolbar tb, boolean b) {
        ToolbarConstraints tc = this.getToolbarConstraints(tb.getName());
        if (b) {
            this.addVisible(tc);
        } else {
            this.removeVisible(tc);
        }
        if (toolbarMenu != null) {
            Component[] elements = toolbarMenu.getMenuComponents();
            for (int i = 0; i < elements.length; ++i) {
                JComponent component = (JComponent)elements[i];
                String tcmenu = (String)component.getClientProperty("ToolbarName");
                if (tcmenu == null || !tcmenu.equals(tb.getName())) continue;
                ((JCheckBoxMenuItem)component).setSelected(b);
                break;
            }
        }
        tb.setVisible(b);
        this.reflectChanges();
        this.firePropertyChange();
    }

    public boolean isToolbarVisible(Toolbar tb) {
        ToolbarConstraints tc = this.getToolbarConstraints(tb.getName());
        return tc.isVisible();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(l);
        }
    }

    private void firePropertyChange() {
        if (this.pcs != null) {
            this.pcs.firePropertyChange("constraints", null, null);
        }
    }

    public void writeDocument() throws IOException {
        this.writeDocument(this.configName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDocument(final String cn) throws IOException {
        ERR.log("writeDocument: " + cn);
        WritableToolbarConfiguration wtc = new WritableToolbarConfiguration(this.toolbarRows, this.invisibleToolbars);
        final StringBuffer sb = new StringBuffer("<?xml version=\"1.0\"?>\n\n");
        sb.append("<!DOCTYPE ").append(TAG_CONFIG).append(" PUBLIC \"").append(TOOLBAR_DTD_PUBLIC_ID).append("\" \"").append(TOOLBAR_DTD_WEB).append("\">\n\n").append(wtc.toString());
        final FileObject tbFO = NbPlaces.getDefault().toolbars().getPrimaryFile();
        FileSystem tbFS = tbFO.getFileSystem();
        Object prev = this.WRITE_IN_PROGRESS.get();
        try {
            this.WRITE_IN_PROGRESS.set(Boolean.TRUE);
            tbFS.runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    FileLock lock = null;
                    OutputStream os = null;
                    FileObject xmlFO = tbFO.getFileObject(cn, ToolbarConfiguration.EXT_XML);
                    if (xmlFO == null) {
                        xmlFO = tbFO.createData(cn, ToolbarConfiguration.EXT_XML);
                    }
                    try {
                        lock = xmlFO.lock();
                        os = xmlFO.getOutputStream(lock);
                        OutputStreamWriter writer = new OutputStreamWriter(os, "UTF-8");
                        writer.write(sb.toString());
                        ((Writer)writer).close();
                    }
                    finally {
                        ToolbarConfiguration.this.lastReload = System.currentTimeMillis();
                        ERR.log("Setting last reload: " + ToolbarConfiguration.this.lastReload);
                        if (os != null) {
                            os.close();
                        }
                        if (lock != null) {
                            lock.releaseLock();
                        }
                    }
                }
            });
        }
        finally {
            this.WRITE_IN_PROGRESS.set(prev);
        }
        ERR.log("writeDocument finished");
    }

    private static final synchronized JPanel toolbarPanel() {
        if (toolbarPanel == null) {
            toolbarPanel = new JPanel();
            toolbarPanel.setLayout(new FlowLayout(0));
        }
        return toolbarPanel;
    }

    public void propertyChange(PropertyChangeEvent ev) {
        if (!"document".equals(ev.getPropertyName())) {
            return;
        }
        if (Boolean.TRUE.equals(this.WRITE_IN_PROGRESS.get())) {
            return;
        }
        this.updateConfiguration((XMLDataObject)ev.getSource());
    }

    void updateConfiguration(final XMLDataObject xmlDataObject) {
        long mod = xmlDataObject.getPrimaryFile().lastModified().getTime();
        ERR.log("Checking modified: " + this.lastReload);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    ToolbarConfiguration.this.initInstance();
                    ToolbarConfiguration.this.readConfig(xmlDataObject);
                    ToolbarConfiguration.this.checkConfigurationOver();
                    if (ToolbarConfiguration.this.configName.equals(ToolbarConfiguration.toolbarPool().getConfiguration())) {
                        ERR.log("Activating the configuration");
                        ToolbarConfiguration.this.activate(true, false);
                    }
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
        });
    }

    int getRowVertLocation(ToolbarRow row) {
        int index = this.rowIndex(row);
        int vertLocation = index * 1;
        Iterator iter = this.toolbarRows.iterator();
        for (int i = 0; i < index; ++i) {
            vertLocation += ((ToolbarRow)iter.next()).getPreferredHeight();
        }
        return vertLocation;
    }

    static {
        confs2Names = new WeakHashMap(10);
    }

    static class WritableToolbarConfiguration {
        Vector rows;

        public WritableToolbarConfiguration(Vector rs, Map iv) {
            this.initRows(rs);
            this.initInvisible(iv);
            this.removeEmptyRows();
        }

        void initRows(Vector rs) {
            this.rows = new Vector();
            Iterator it = rs.iterator();
            while (it.hasNext()) {
                this.rows.addElement(new ToolbarRow.WritableToolbarRow((ToolbarRow)it.next()));
            }
        }

        void initInvisible(Map iv) {
            Iterator it = iv.keySet().iterator();
            while (it.hasNext()) {
                int row;
                ToolbarConstraints tc = (ToolbarConstraints)it.next();
                for (int i = row = ((Integer)iv.get(tc)).intValue(); i < row + tc.getRowCount(); ++i) {
                    this.getRow(i).addToolbar(tc);
                }
            }
        }

        void removeEmptyRows() {
            for (int i = this.rows.size() - 1; i >= 0; --i) {
                ToolbarRow.WritableToolbarRow row = (ToolbarRow.WritableToolbarRow)this.rows.elementAt(i);
                if (!row.isEmpty()) continue;
                this.rows.removeElement(row);
            }
        }

        ToolbarRow.WritableToolbarRow getRow(int r) {
            try {
                return (ToolbarRow.WritableToolbarRow)this.rows.elementAt(r);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.rows.addElement(new ToolbarRow.WritableToolbarRow());
                return this.getRow(r);
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("<").append(ToolbarConfiguration.TAG_CONFIG).append(">\n");
            Iterator it = this.rows.iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString());
            }
            sb.append("</").append(ToolbarConfiguration.TAG_CONFIG).append(">\n");
            return sb.toString();
        }
    }

    private class ToolbarParser
    extends HandlerBase
    implements EntityResolver {
        private ToolbarRow currentRow = null;
        private int toolbarIndex = 0;

        private ToolbarParser() {
        }

        public void startElement(String name, AttributeList amap) throws SAXException {
            if (ToolbarConfiguration.TAG_ROW.equals(name)) {
                this.toolbarIndex = 0;
                this.currentRow = new ToolbarRow(ToolbarConfiguration.this);
                ToolbarConfiguration.this.addRow(this.currentRow);
            } else if (this.currentRow != null && ToolbarConfiguration.TAG_TOOLBAR.equals(name)) {
                String visStr;
                String tbname = amap.getValue(ToolbarConfiguration.ATT_TOOLBAR_NAME);
                if (tbname == null || tbname.equals("")) {
                    return;
                }
                String posStr = amap.getValue(ToolbarConfiguration.ATT_TOOLBAR_POSITION);
                Integer pos = null;
                if (posStr != null) {
                    pos = new Integer(posStr);
                }
                Boolean vis = (visStr = amap.getValue(ToolbarConfiguration.ATT_TOOLBAR_VISIBLE)) != null ? Boolean.valueOf(visStr) : Boolean.TRUE;
                ToolbarConfiguration.this.addToolbar(this.currentRow, ToolbarConfiguration.this.checkToolbarConstraints(tbname, pos, vis, this.toolbarIndex++));
            }
        }

        public void endElement(String name) throws SAXException {
            if (ToolbarConfiguration.TAG_ROW.equals(name)) {
                this.currentRow = null;
            }
        }

        public InputSource resolveEntity(String pubid, String sysid) {
            return new InputSource(new ByteArrayInputStream(new byte[0]));
        }
    }
}

