/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.nodes;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelListener;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModeler;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlService;
import org.netbeans.modules.websvc.core.jaxws.JaxWsUtils;
import org.netbeans.modules.websvc.core.jaxws.nodes.JaxWsClientNode;
import org.netbeans.modules.websvc.core.jaxws.nodes.ServiceNode;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class JaxWsClientChildren
extends Children.Keys {
    Client client;
    WsdlModel wsdlModel;

    public JaxWsClientChildren(Client client) {
        this.client = client;
    }

    protected void addNotify() {
        super.addNotify();
        FileObject wsdlFo = this.getLocalWsdl();
        final WsdlModeler wsdlModeler = ((JaxWsClientNode)this.getNode()).getWsdlModeler();
        if (wsdlModeler != null) {
            this.wsdlModel = wsdlModeler.getWsdlModel();
            if (this.wsdlModel == null) {
                wsdlModeler.generateWsdlModel(new WsdlModelListener(){

                    public void modelCreated(WsdlModel model) {
                        JaxWsClientChildren.this.wsdlModel = model;
                        ((JaxWsClientNode)JaxWsClientChildren.this.getNode()).changeIcon();
                        if (model == null) {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new JaxWsUtils.WsImportClientFailedMessage(wsdlModeler.getCreationException()));
                        }
                        JaxWsClientChildren.this.updateKeys();
                    }
                });
            } else {
                this.updateKeys();
            }
        }
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
        super.removeNotify();
    }

    private void updateKeys() {
        List keys = null;
        if (this.wsdlModel != null) {
            keys = this.wsdlModel.getServices();
        }
        this.setKeys(keys == null ? new ArrayList() : keys);
    }

    protected Node[] createNodes(Object key) {
        if (key instanceof WsdlService) {
            return new Node[]{new ServiceNode((WsdlService)key)};
        }
        return new Node[0];
    }

    void refreshKeys(boolean downloadWsdl) {
        FileObject srcRoot;
        Project project;
        super.addNotify();
        Object keys = null;
        JAXWSClientSupport support = this.getJAXWSClientSupport();
        final JaxWsClientNode clientNode = (JaxWsClientNode)this.getNode();
        if (downloadWsdl) {
            try {
                FileObject xmlResorcesFo;
                FileObject srcRoot2;
                Project project2;
                String clientName = clientNode.getName();
                WSUtils.retrieveResource((FileObject)support.getLocalWsdlFolderForClient(clientName, true), (URI)new URI(this.client.getWsdlUrl()));
                if (this.client.getWsdlUrl().startsWith("file:") && (project2 = FileOwnerQuery.getOwner((FileObject)(srcRoot2 = (FileObject)this.getNode().getLookup().lookup(FileObject.class)))).getLookup().lookup(J2eeModuleProvider.class) != null && (xmlResorcesFo = support.getLocalWsdlFolderForClient(clientName, false)) != null) {
                    FileObject wsdlFolder = this.getWsdlFolderForClient(support, clientName);
                    WSUtils.copyFiles((FileObject)xmlResorcesFo, (FileObject)wsdlFolder);
                }
            }
            catch (URISyntaxException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            catch (UnknownHostException ex) {
                ErrorManager.getDefault().annotate((Throwable)ex, NbBundle.getMessage(JaxWsClientChildren.class, (String)"MSG_ConnectionProblem"));
                return;
            }
            catch (IOException ex) {
                ErrorManager.getDefault().annotate((Throwable)ex, NbBundle.getMessage(JaxWsClientChildren.class, (String)"MSG_ConnectionProblem"));
                return;
            }
        }
        FileObject wsdlFo = this.getLocalWsdl();
        final WsdlModeler wsdlModeler = clientNode.getWsdlModeler();
        clientNode.setModelGenerationFinished(false);
        clientNode.changeIcon();
        if (wsdlModeler != null) {
            wsdlModeler.generateWsdlModel(new WsdlModelListener(){

                public void modelCreated(WsdlModel model) {
                    Client client;
                    JaxWsClientChildren.this.wsdlModel = model;
                    clientNode.setModelGenerationFinished(true);
                    clientNode.changeIcon();
                    if (model == null) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new JaxWsUtils.WsImportClientFailedMessage(wsdlModeler.getCreationException()));
                    }
                    JaxWsClientChildren.this.updateKeys();
                    if (model != null && (client = clientNode.getJaxWsModel().findClientByName(clientNode.getName())) != null) {
                        String newPkgName;
                        String javaName;
                        int dotPosition;
                        WsdlService wsdlService = null;
                        boolean jaxWsModelChanged = false;
                        List wsdlServices = model.getServices();
                        if (wsdlServices != null && wsdlServices.size() > 0) {
                            wsdlService = (WsdlService)wsdlServices.get(0);
                        }
                        String oldPkgName = client.getPackageName();
                        if (wsdlService != null && oldPkgName != null && !client.isPackageNameForceReplace() && (dotPosition = (javaName = wsdlService.getJavaName()).lastIndexOf(".")) >= 0 && !oldPkgName.equals(newPkgName = javaName.substring(0, dotPosition))) {
                            client.setPackageName(newPkgName);
                            jaxWsModelChanged = true;
                        }
                        if (jaxWsModelChanged) {
                            try {
                                clientNode.getJaxWsModel().write();
                            }
                            catch (IOException ex) {
                                ErrorManager.getDefault().notify(65536, (Throwable)ex);
                            }
                        }
                    }
                }
            });
        }
        if ((project = FileOwnerQuery.getOwner((FileObject)(srcRoot = (FileObject)this.getNode().getLookup().lookup(FileObject.class)))) != null) {
            FileObject buildImplFo = project.getProjectDirectory().getFileObject("nbproject/build-impl.xml");
            try {
                String name = this.client.getName();
                ExecutorTask wsimportTask = ActionUtils.runTarget((FileObject)buildImplFo, (String[])new String[]{"wsimport-client-clean-" + name, "wsimport-client-" + name}, null);
                wsimportTask.waitFinished();
            }
            catch (IOException ex) {
                ErrorManager.getDefault().log(ex.getLocalizedMessage());
            }
            catch (IllegalArgumentException ex) {
                ErrorManager.getDefault().log(ex.getLocalizedMessage());
            }
            String packageName = this.client.getPackageName().replace(".", "/");
            FileObject clientArtifactsFolder = project.getProjectDirectory().getFileObject("build/generated/wsimport/client/" + packageName);
            if (clientArtifactsFolder != null) {
                clientArtifactsFolder.refresh();
            }
        }
    }

    private JAXWSClientSupport getJAXWSClientSupport() {
        return ((JaxWsClientNode)this.getNode()).getJAXWSClientSupport();
    }

    private FileObject getLocalWsdl() {
        return ((JaxWsClientNode)this.getNode()).getLocalWsdl();
    }

    WsdlModel getWsdlModel() {
        return this.wsdlModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject getWsdlFolderForClient(JAXWSClientSupport support, String name) throws IOException {
        FileObject clientWsdlFolder;
        FileObject globalWsdlFolder = support.getWsdlFolder(true);
        FileObject oldWsdlFolder = globalWsdlFolder.getFileObject("client/" + name);
        if (oldWsdlFolder != null) {
            FileLock lock = oldWsdlFolder.lock();
            try {
                oldWsdlFolder.delete(lock);
            }
            finally {
                lock.releaseLock();
            }
        }
        if ((clientWsdlFolder = globalWsdlFolder.getFileObject("client")) == null) {
            clientWsdlFolder = globalWsdlFolder.createFolder("client");
        }
        return clientWsdlFolder.createFolder(name);
    }
}

