/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.wseditor.support;

import java.util.Collection;
import java.util.Set;
import org.netbeans.modules.websvc.core.wseditor.spi.WSEditorProvider;
import org.netbeans.modules.websvc.core.wseditor.spi.WSEditorProviderRegistry;
import org.netbeans.modules.websvc.core.wseditor.support.EditWSAttributesCookie;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.CookieAction;

public final class WSEditAttributesAction
extends CookieAction {
    protected void performAction(Node[] activatedNodes) {
        if (activatedNodes.length == 1) {
            final EditWSAttributesCookie cookie = (EditWSAttributesCookie)activatedNodes[0].getCookie(EditWSAttributesCookie.class);
            Runnable task = new Runnable(){

                public void run() {
                    if (cookie != null) {
                        cookie.openWSAttributesEditor();
                    }
                }
            };
            RequestProcessor.getDefault().post(task, 10);
        }
    }

    protected int mode() {
        return 8;
    }

    public String getName() {
        return NbBundle.getMessage(WSEditAttributesAction.class, (String)"CTL_WSEditAttributesAction");
    }

    protected Class[] cookieClasses() {
        return new Class[]{EditWSAttributesCookie.class};
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    private WSEditorProviderRegistry populateWSEditorProviderRegistry() {
        WSEditorProviderRegistry registry = WSEditorProviderRegistry.getDefault();
        if (registry.getEditorProviders().isEmpty()) {
            Lookup.Result results = Lookup.getDefault().lookup(new Lookup.Template(WSEditorProvider.class));
            Collection services = results.allInstances();
            for (WSEditorProvider provider : services) {
                registry.register(provider);
            }
        }
        return registry;
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes.length == 1) {
            WSEditorProviderRegistry registry = this.populateWSEditorProviderRegistry();
            Set<WSEditorProvider> providers = registry.getEditorProviders();
            if (providers.size() == 0) {
                return false;
            }
            Node node = activatedNodes[0];
            for (WSEditorProvider provider : providers) {
                if (!provider.enable(node)) continue;
                return true;
            }
        }
        return false;
    }
}

