/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsdl.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.modules.websvc.wsdl.wizard.Utilities;
import org.netbeans.modules.websvc.wsdl.wizard.WsdlPanel;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class WsdlUIPanel
extends JPanel {
    private static final String TARGET_URL_PREFIX = NbBundle.getMessage(WsdlUIPanel.class, (String)"TXT_defaultTNS");
    private static final String DEFAULT_SERVICE_NAME = NbBundle.getMessage(WsdlUIPanel.class, (String)"TXT_defaultServiceName");
    private WsdlPanel wizardPanel;
    private JTextField fileNameTF;
    private JButton browseButton;
    private JCheckBox cbImport;
    private JPanel jPanel1;
    private JLabel namespaceLB;
    private JTextField nsTF;
    private JLabel schemaLB;
    private JTextField schemaTF;

    public WsdlUIPanel(WsdlPanel wizardPanel) {
        this.initComponents();
        this.wizardPanel = wizardPanel;
        this.nsTF.setText(TARGET_URL_PREFIX + DEFAULT_SERVICE_NAME);
    }

    void attachFileNameListener(JTextField fileNameTF) {
        this.fileNameTF = fileNameTF;
        if (fileNameTF != null) {
            this.nsTF.setText(TARGET_URL_PREFIX + fileNameTF.getText());
            DocListener list = new DocListener();
            Document doc = fileNameTF.getDocument();
            doc.addDocumentListener(list);
        } else {
            this.nsTF.setText(TARGET_URL_PREFIX + DEFAULT_SERVICE_NAME);
        }
    }

    private void initComponents() {
        this.cbImport = new JCheckBox();
        this.schemaTF = new JTextField();
        this.browseButton = new JButton();
        this.schemaLB = new JLabel();
        this.namespaceLB = new JLabel();
        this.nsTF = new JTextField();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.cbImport.setMnemonic(NbBundle.getMessage(WsdlUIPanel.class, (String)"MNEM_importSchema").charAt(0));
        this.cbImport.setText(NbBundle.getMessage(WsdlUIPanel.class, (String)"LBL_importSchema"));
        this.cbImport.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbImport.setMargin(new Insets(0, 0, 0, 0));
        this.cbImport.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                WsdlUIPanel.this.cbImportItemStateChanged(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 6, 5);
        this.add((Component)this.cbImport, gridBagConstraints);
        this.cbImport.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WsdlUIPanel.class, (String)"LBL_importSchema"));
        this.schemaTF.setEditable(false);
        this.schemaTF.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/websvc/wsdl/wizard/Bundle").getString("HINT_schemaFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.add((Component)this.schemaTF, gridBagConstraints);
        this.schemaTF.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WsdlUIPanel.class, (String)"A11Y_schemaTF"));
        this.browseButton.setMnemonic(NbBundle.getMessage(WsdlUIPanel.class, (String)"MNEM_browse").charAt(0));
        this.browseButton.setText(NbBundle.getMessage(WsdlUIPanel.class, (String)"LBL_browse"));
        this.browseButton.setEnabled(false);
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WsdlUIPanel.this.browseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.add((Component)this.browseButton, gridBagConstraints);
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WsdlUIPanel.class, (String)"A11Y_browse"));
        this.schemaLB.setDisplayedMnemonic(NbBundle.getMessage(WsdlUIPanel.class, (String)"MNEM_schemaFiles").charAt(0));
        this.schemaLB.setLabelFor(this.schemaTF);
        this.schemaLB.setText(NbBundle.getMessage(WsdlUIPanel.class, (String)"LBL_schemaFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.schemaLB, gridBagConstraints);
        this.namespaceLB.setDisplayedMnemonic(NbBundle.getMessage(WsdlUIPanel.class, (String)"MNEM_targetNamespace").charAt(0));
        this.namespaceLB.setLabelFor(this.nsTF);
        this.namespaceLB.setText(NbBundle.getMessage(WsdlUIPanel.class, (String)"LBL_targetNamespace"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 2, 0);
        this.add((Component)this.namespaceLB, gridBagConstraints);
        this.nsTF.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/websvc/wsdl/wizard/Bundle").getString("HINT_targetNamespace"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 2, 0);
        this.add((Component)this.nsTF, gridBagConstraints);
        this.nsTF.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WsdlUIPanel.class, (String)"HINT_targetNamespace"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        String maskTitle;
        String dialogTitle = NbBundle.getMessage(WsdlUIPanel.class, (String)"TITLE_selectSchema");
        File[] files = Utilities.selectFiles("xsd XSD", dialogTitle, maskTitle = NbBundle.getMessage(WsdlUIPanel.class, (String)"TXT_schemaFiles"), this.wizardPanel.getProject());
        if (files == null || files.length == 0) {
            return;
        }
        String original = this.schemaTF.getText().trim();
        StringBuilder fileString = new StringBuilder(original);
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            String location = f.toURI().normalize().toString();
            if (fileString.indexOf(location) >= 0) continue;
            if (fileString.length() > 0) {
                fileString.append(",");
            }
            fileString.append(location);
        }
        this.schemaTF.setText(fileString.toString());
    }

    private void cbImportItemStateChanged(ItemEvent evt) {
        if (this.cbImport.isSelected()) {
            this.schemaTF.setEditable(true);
            this.browseButton.setEnabled(true);
        } else {
            this.schemaTF.setEditable(false);
            this.browseButton.setEnabled(false);
        }
    }

    String getNS() {
        return this.nsTF.getText();
    }

    String getWsName() {
        if (this.fileNameTF != null) {
            return this.fileNameTF.getText();
        }
        return DEFAULT_SERVICE_NAME;
    }

    boolean isImport() {
        return this.cbImport.isSelected();
    }

    SchemaInfo[] getSchemas() {
        if (this.cbImport.isSelected()) {
            String schemas = this.schemaTF.getText();
            String[] urls = schemas.split(",");
            ArrayList<SchemaInfo> infos = new ArrayList<SchemaInfo>();
            for (int i = 0; i < urls.length; ++i) {
                String urlString = urls[i].trim();
                if (urlString.length() == 0) continue;
                try {
                    URL url = new URL(urlString);
                    infos.add(new SchemaInfo(url));
                    continue;
                }
                catch (MalformedURLException ex) {
                    try {
                        DataFolder folder = this.wizardPanel.getTemplateWizard().getTargetFolder();
                        FileObject fo = folder.getPrimaryFile();
                        if (fo.getFileObject(urlString) == null) continue;
                        String parentURL = fo.getURL().toExternalForm();
                        infos.add(new SchemaInfo(new URL(parentURL + urlString)));
                        continue;
                    }
                    catch (IOException ex1) {
                        // empty catch block
                    }
                }
            }
            SchemaInfo[] result = new SchemaInfo[infos.size()];
            infos.toArray(result);
            return result;
        }
        return new SchemaInfo[0];
    }

    static class SchemaInfo {
        private URL url;

        SchemaInfo(URL url) {
            this.url = url;
        }

        URL getURL() {
            return this.url;
        }

        String getNamespace() {
            InputSource is = new InputSource(this.url.toExternalForm());
            try {
                return this.parse(is);
            }
            catch (IOException ex) {
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
            return "";
        }

        String getSchemaName() {
            return this.url.toExternalForm();
        }

        private String parse(InputSource is) throws IOException, SAXException {
            NsHandler handler;
            block3: {
                XMLReader xmlReader = XMLUtil.createXMLReader();
                handler = new NsHandler();
                xmlReader.setContentHandler(handler);
                try {
                    xmlReader.parse(is);
                }
                catch (SAXException ex) {
                    if ("EXIT".equals(ex.getMessage())) break block3;
                    throw ex;
                }
            }
            String ns = handler.getNs();
            if (ns == null) {
                return "";
            }
            return ns;
        }

        private static class NsHandler
        extends DefaultHandler {
            private String ns;

            private NsHandler() {
            }

            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (qName.endsWith("schema")) {
                    this.ns = attributes.getValue("targetNamespace");
                    throw new SAXException("EXIT");
                }
            }

            String getNs() {
                return this.ns;
            }
        }
    }

    private class DocListener
    implements DocumentListener {
        private DocListener() {
        }

        public void removeUpdate(DocumentEvent e) {
            this.documentChanged(e);
        }

        public void insertUpdate(DocumentEvent e) {
            this.documentChanged(e);
        }

        public void changedUpdate(DocumentEvent e) {
            this.documentChanged(e);
        }

        private void documentChanged(DocumentEvent e) {
            String ns = WsdlUIPanel.this.nsTF.getText();
            int index = ns.lastIndexOf(47);
            if (index > 0) {
                boolean hasExt = ns.endsWith(".wsdl");
                WsdlUIPanel.this.nsTF.setText(ns.substring(0, index + 1) + WsdlUIPanel.this.fileNameTF.getText().trim() + (hasExt ? ".wsdl" : ""));
            }
        }
    }
}

