/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.html;

import java.util.Collection;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.editor.ext.html.HTMLCompletionQuery;
import org.netbeans.editor.ext.html.HTMLSyntaxSupport;
import org.netbeans.editor.ext.html.HTMLTokenContext;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.ErrorManager;

public class HTMLCompletionProvider
implements CompletionProvider {
    private static ErrorManager ERR = ErrorManager.getDefault();
    private static final boolean NON_EXACT_MATCH = true;
    private static final boolean ENABLED = true;
    static /* synthetic */ Class class$org$netbeans$modules$editor$html$HTMLCompletionProvider;

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        int type = ((HTMLSyntaxSupport)Utilities.getDocument((JTextComponent)component).getSyntaxSupport()).checkCompletion(component, typedText, false);
        if (type == 0) {
            return 3;
        }
        return 0;
    }

    public CompletionTask createTask(int queryType, JTextComponent component) {
        if (queryType == 1) {
            return new AsyncCompletionTask((AsyncCompletionQuery)new Query(component.getCaret().getDot()), component);
        }
        if (queryType == 2) {
            return new AsyncCompletionTask((AsyncCompletionQuery)new DocQuery(null), component);
        }
        return null;
    }

    private static CompletionQuery.Result queryImpl(JTextComponent component, int offset) {
        Class kitClass = Utilities.getKitClass((JTextComponent)component);
        if (kitClass != null) {
            HTMLSyntaxSupport support = (HTMLSyntaxSupport)Utilities.getSyntaxSupport((JTextComponent)component);
            return HTMLCompletionQuery.getDefault().query(component, offset, (SyntaxSupport)support);
        }
        return null;
    }

    private static void checkHideCompletion(BaseDocument doc, int caretOffset) {
        HTMLSyntaxSupport sup = (HTMLSyntaxSupport)doc.getSyntaxSupport().get(HTMLSyntaxSupport.class);
        try {
            TokenItem ti = sup.getTokenChain(caretOffset <= 0 ? 0 : caretOffset - 1, caretOffset);
            if (ti != null && ti.getTokenID() == HTMLTokenContext.TEXT && !ti.getImage().startsWith("<") && !ti.getImage().startsWith("&")) {
                HTMLCompletionProvider.hideCompletion();
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private static void hideCompletion() {
        Completion.get().hideCompletion();
        Completion.get().hideDocumentation();
    }

    private static abstract class AbstractQuery
    extends AsyncCompletionQuery {
        private AbstractQuery() {
        }

        protected void preQueryUpdate(JTextComponent component) {
            int caretOffset = component.getCaretPosition();
            Document doc = component.getDocument();
            HTMLCompletionProvider.checkHideCompletion((BaseDocument)doc, caretOffset);
        }

        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            HTMLCompletionProvider.checkHideCompletion((BaseDocument)doc, caretOffset);
            this.doQuery(resultSet, doc, caretOffset);
            resultSet.finish();
        }

        abstract void doQuery(CompletionResultSet var1, Document var2, int var3);
    }

    static class DocQuery
    extends AbstractQuery {
        private JTextComponent component;
        private CompletionQuery.ResultItem item;

        DocQuery(HTMLCompletionQuery.HTMLResultItem item) {
            this.item = item;
        }

        protected void prepareQuery(JTextComponent component) {
            this.component = component;
        }

        protected void doQuery(CompletionResultSet resultSet, Document doc, int caretOffset) {
            HTMLCompletionQuery.HTMLResultItem htmlItem;
            Object resultObj;
            List result;
            CompletionQuery.Result res = null;
            if (this.item == null && (res = HTMLCompletionProvider.queryImpl(this.component, caretOffset)) != null && (result = res.getData()) != null && result.size() > 0 && (resultObj = result.get(0)) instanceof CompletionQuery.ResultItem) {
                this.item = (CompletionQuery.ResultItem)resultObj;
            }
            if ((htmlItem = (HTMLCompletionQuery.HTMLResultItem)this.item) != null && htmlItem.getHelpID() != null) {
                resultSet.setDocumentation((CompletionDocumentation)new HTMLCompletionQuery.DocItem(htmlItem));
                if (res != null) {
                    resultSet.setTitle(res.getTitle());
                    resultSet.setAnchorOffset(((HTMLCompletionQuery.HTMLCompletionResult)res).getSubstituteOffset());
                }
            }
        }
    }

    static class Query
    extends AbstractQuery {
        private JTextComponent component;
        private int creationCaretOffset;
        static final /* synthetic */ boolean $assertionsDisabled;

        Query(int caretOffset) {
            this.creationCaretOffset = caretOffset;
        }

        protected void prepareQuery(JTextComponent component) {
            this.component = component;
        }

        protected void doQuery(CompletionResultSet resultSet, Document doc, int caretOffset) {
            HTMLCompletionQuery.HTMLCompletionResult res = (HTMLCompletionQuery.HTMLCompletionResult)HTMLCompletionProvider.queryImpl(this.component, caretOffset);
            if (res == null) {
                return;
            }
            List results = res.getData();
            if (!$assertionsDisabled && results == null) {
                throw new AssertionError();
            }
            resultSet.addAllItems((Collection)results);
            resultSet.setTitle(res.getTitle());
            resultSet.setAnchorOffset(res.getSubstituteOffset());
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$editor$html$HTMLCompletionProvider == null ? (class$org$netbeans$modules$editor$html$HTMLCompletionProvider = HTMLCompletionProvider.class$("org.netbeans.modules.editor.html.HTMLCompletionProvider")) : class$org$netbeans$modules$editor$html$HTMLCompletionProvider).desiredAssertionStatus();
        }
    }
}

