/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.comparators;

import java.util.Comparator;
import org.netbeans.api.java.comparators.IdentifierComparator;
import org.netbeans.api.java.comparators.MParameterComparator;
import org.netbeans.api.java.comparators.MemberNameComparator;
import org.openide.src.ConstructorElement;
import org.openide.src.Identifier;
import org.openide.src.MethodParameter;

class ConstructorComparator
extends MemberNameComparator {
    protected Comparator idComparator;
    protected Comparator paramComparator;

    protected ConstructorComparator(int type) {
        super(type);
        int source_type;
        int paramType = source_type = type & 1;
        if ((type & 0x100) > 0) {
            paramType |= 4;
        }
        if ((type & 0x200) > 0) {
            paramType |= 0x40;
        }
        if ((type & 0x400) > 0) {
            paramType |= 0x20;
        }
        if ((type & 0x10) != 0) {
            this.idComparator = IdentifierComparator.createComparator(source_type);
        }
        if ((type & 8) != 0) {
            this.paramComparator = MParameterComparator.createComparator(paramType);
        }
    }

    public int compare(Object o1, Object o2) {
        int i;
        int result;
        ConstructorElement ce1 = (ConstructorElement)o1;
        ConstructorElement ce2 = (ConstructorElement)o2;
        if ((this.type & 4) != 0 && (result = super.compare(ce1, ce2)) != 0) {
            return result;
        }
        if ((this.type & 0x10) != 0) {
            Identifier[] excB;
            Identifier[] excA = ce1.getExceptions();
            if (excA.length != (excB = ce2.getExceptions()).length) {
                return excA.length - excB.length > 0 ? 1 : -1;
            }
            for (i = 0; i < excA.length; ++i) {
                result = this.idComparator.compare(excA[i], excB[i]);
                if (result == 0) continue;
                return result;
            }
        }
        if (this.paramComparator != null) {
            MethodParameter[] paramB;
            MethodParameter[] paramA = ce1.getParameters();
            if (paramA.length != (paramB = ce2.getParameters()).length) {
                return paramA.length - paramB.length > 0 ? 1 : -1;
            }
            for (i = 0; i < paramA.length; ++i) {
                result = this.paramComparator.compare(paramA[i], paramB[i]);
                if (result == 0) continue;
                return result;
            }
        }
        return 0;
    }

    static Comparator createComparator(int type) {
        return new ConstructorComparator(type);
    }
}

