/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.openide.src.ClassElement;
import org.openide.src.ElementFormat;
import org.openide.src.ElementPrinter;
import org.openide.src.ElementPrinterInterruptException;
import org.openide.src.Identifier;
import org.openide.src.JavaDoc;
import org.openide.src.JavaDocSupport;
import org.openide.src.MemberElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceException;
import org.openide.src.Type;

public class ConstructorElement
extends MemberElement {
    private static final ElementFormat HEADER_FORMAT = new ElementFormat("{m,,\" \"}{n}({a}){e,\" throws \",}");
    static final long serialVersionUID = 4794977239847390179L;

    public ConstructorElement() {
        this(new Memory(), null);
    }

    public ConstructorElement(Impl impl, ClassElement clazz) {
        super(impl, clazz);
    }

    public Object clone() {
        return new ConstructorElement(new Memory(this), null);
    }

    final Impl getConstructorImpl() {
        return (Impl)this.impl;
    }

    public int getModifiersMask() {
        return 7;
    }

    public final MethodParameter[] getParameters() {
        return this.getConstructorImpl().getParameters();
    }

    public final void setParameters(MethodParameter[] params) throws SourceException {
        this.getConstructorImpl().setParameters(params);
    }

    public final Identifier[] getExceptions() {
        return this.getConstructorImpl().getExceptions();
    }

    public final void setExceptions(Identifier[] exceptions) throws SourceException {
        this.getConstructorImpl().setExceptions(exceptions);
    }

    public final void setBody(String s) throws SourceException {
        this.getConstructorImpl().setBody(s);
    }

    public final String getBody() {
        return this.getConstructorImpl().getBody();
    }

    public final JavaDoc.Method getJavaDoc() {
        return this.getConstructorImpl().getJavaDoc();
    }

    public void print(ElementPrinter printer) throws ElementPrinterInterruptException {
        this.printerMark(printer, 0);
        JavaDoc.Method doc = this.getJavaDoc();
        if (doc != null && !doc.isEmpty()) {
            this.printerMark(printer, 2);
            ConstructorElement.printJavaDoc(doc, printer);
            this.printerMark(printer, 3);
            printer.println("");
        }
        this.printerMark(printer, 4);
        printer.print(this.getFormat().format(this));
        this.printerMark(printer, 5);
        String body = this.getBody();
        ClassElement declClass = this.getDeclaringClass();
        if (declClass != null && declClass.isInterface() || Modifier.isAbstract(this.getModifiers()) || body == null) {
            printer.print(";");
        } else {
            printer.print(" {");
            this.printerMark(printer, 6);
            printer.print(body);
            this.printerMark(printer, 7);
            printer.print("}");
        }
        this.printerMark(printer, 1);
    }

    void printerMark(ElementPrinter printer, int what) throws ElementPrinterInterruptException {
        printer.markConstructor(this, what);
    }

    ElementFormat getFormat() {
        return HEADER_FORMAT;
    }

    static class Memory
    extends MemberElement.Memory
    implements Impl {
        private MethodParameter[] parameters;
        private Identifier[] exceptions;
        private String body;
        private JavaDoc.Method javaDoc;
        static final long serialVersionUID = -4826478874004410760L;

        Memory() {
            this.exceptions = new Identifier[0];
            this.parameters = new MethodParameter[0];
            this.body = "";
            this.javaDoc = JavaDocSupport.createMethodJavaDoc(null);
        }

        Memory(ConstructorElement el) {
            super(el);
            this.exceptions = el.getExceptions();
            this.parameters = el.getParameters();
            this.body = el.getBody();
            this.javaDoc = el.getJavaDoc().isEmpty() ? JavaDocSupport.createMethodJavaDoc(null) : JavaDocSupport.createMethodJavaDoc(el.getJavaDoc().getRawText());
        }

        public MethodParameter[] getParameters() {
            return this.parameters;
        }

        public void setParameters(MethodParameter[] params) {
            MethodParameter[] m = this.parameters;
            this.parameters = params;
            this.firePropertyChange("parameters", m, params);
        }

        public Identifier[] getExceptions() {
            return this.exceptions;
        }

        public void setExceptions(Identifier[] exceptions) {
            Identifier[] old = this.exceptions;
            this.exceptions = exceptions;
            this.firePropertyChange("exceptions", old, exceptions);
        }

        public void setBody(String s) throws SourceException {
            String old = this.body;
            this.body = s;
            this.firePropertyChange("body", old, this.body);
        }

        public String getBody() {
            return this.body;
        }

        public JavaDoc.Method getJavaDoc() {
            return this.javaDoc;
        }

        public Object readResolve() {
            return new ConstructorElement(this, null);
        }
    }

    public static class Key {
        private Type[] params;

        public Key(Type[] params) {
            this.params = params;
        }

        public Key(ConstructorElement ce) {
            MethodParameter[] mp = ce.getParameters();
            this.params = new Type[mp.length];
            for (int i = 0; i < mp.length; ++i) {
                this.params[i] = mp[i].getType();
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            return Arrays.equals(this.params, ((Key)obj).params);
        }

        public int hashCode() {
            if (this.params == null) {
                return 0;
            }
            int length = this.params.length;
            if (length == 0) {
                return 0;
            }
            if (length == 1) {
                return this.params[0].getFullString().hashCode();
            }
            return this.params[0].getFullString().hashCode() ^ this.params[length - 1].getFullString().hashCode();
        }
    }

    public static interface Impl
    extends MemberElement.Impl {
        public static final long serialVersionUID = -8757076629808175158L;

        public MethodParameter[] getParameters();

        public void setParameters(MethodParameter[] var1) throws SourceException;

        public Identifier[] getExceptions();

        public void setExceptions(Identifier[] var1) throws SourceException;

        public void setBody(String var1) throws SourceException;

        public String getBody();

        public JavaDoc.Method getJavaDoc();
    }
}

