/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.jvm.CRTFlags;
import com.sun.tools.javac.tree.Tree;
import com.sun.tools.javac.util.ByteBuffer;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRTable
implements CRTFlags {
    private final boolean crtDebug = false;
    private ListBuffer<CRTEntry> entries = new ListBuffer();
    private Map<Object, SourceRange> positions = new HashMap<Object, SourceRange>();
    private Map<Tree, Integer> endPositions;
    Tree.MethodDef methodTree;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$sun$tools$javac$jvm$CRTable;

    public CRTable(Tree.MethodDef tree, Map<Tree, Integer> endPositions) {
        this.methodTree = tree;
        this.endPositions = endPositions;
    }

    public void put(Object tree, int flags, int startPc, int endPc) {
        this.entries.append(new CRTEntry(tree, flags, startPc, endPc));
    }

    public int writeCRT(ByteBuffer databuf) {
        int crtEntries = 0;
        new SourceComputer().csp(this.methodTree);
        List<CRTEntry> l = this.entries.toList();
        while (l.nonEmpty()) {
            CRTEntry entry = (CRTEntry)l.head;
            if (entry.startPc != entry.endPc) {
                SourceRange pos = this.positions.get(entry.tree);
                if (!$assertionsDisabled && pos == null) {
                    throw new AssertionError((Object)"CRT: tree source positions are undefined");
                }
                if (pos.startPos != -1 && pos.endPos != -1) {
                    databuf.appendChar(entry.startPc);
                    databuf.appendChar(entry.endPc - 1);
                    databuf.appendInt(pos.startPos);
                    databuf.appendInt(pos.endPos);
                    databuf.appendChar(entry.flags);
                    ++crtEntries;
                }
            }
            l = l.tail;
        }
        return crtEntries;
    }

    public int length() {
        return this.entries.length();
    }

    private String getTypes(int flags) {
        String types = "";
        if ((flags & 1) != 0) {
            types = new StringBuffer().append(types).append(" CRT_STATEMENT").toString();
        }
        if ((flags & 2) != 0) {
            types = new StringBuffer().append(types).append(" CRT_BLOCK").toString();
        }
        if ((flags & 4) != 0) {
            types = new StringBuffer().append(types).append(" CRT_ASSIGNMENT").toString();
        }
        if ((flags & 8) != 0) {
            types = new StringBuffer().append(types).append(" CRT_FLOW_CONTROLLER").toString();
        }
        if ((flags & 0x10) != 0) {
            types = new StringBuffer().append(types).append(" CRT_FLOW_TARGET").toString();
        }
        if ((flags & 0x20) != 0) {
            types = new StringBuffer().append(types).append(" CRT_INVOKE").toString();
        }
        if ((flags & 0x40) != 0) {
            types = new StringBuffer().append(types).append(" CRT_CREATE").toString();
        }
        if ((flags & 0x80) != 0) {
            types = new StringBuffer().append(types).append(" CRT_BRANCH_TRUE").toString();
        }
        if ((flags & 0x100) != 0) {
            types = new StringBuffer().append(types).append(" CRT_BRANCH_FALSE").toString();
        }
        return types;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        $assertionsDisabled = !(class$com$sun$tools$javac$jvm$CRTable == null ? (class$com$sun$tools$javac$jvm$CRTable = CRTable.class$("com.sun.tools.javac.jvm.CRTable")) : class$com$sun$tools$javac$jvm$CRTable).desiredAssertionStatus();
    }

    class SourceRange {
        int startPos;
        int endPos;

        SourceRange() {
            this.startPos = -1;
            this.endPos = -1;
        }

        SourceRange(int startPos, int endPos) {
            this.startPos = startPos;
            this.endPos = endPos;
        }

        SourceRange mergeWith(SourceRange sr) {
            if (sr == null) {
                return this;
            }
            if (this.startPos == -1) {
                this.startPos = sr.startPos;
            } else if (sr.startPos != -1) {
                int n = this.startPos = this.startPos < sr.startPos ? this.startPos : sr.startPos;
            }
            if (this.endPos == -1) {
                this.endPos = sr.endPos;
            } else if (sr.endPos != -1) {
                this.endPos = this.endPos > sr.endPos ? this.endPos : sr.endPos;
            }
            return this;
        }
    }

    class CRTEntry {
        Object tree;
        int flags;
        int startPc;
        int endPc;

        CRTEntry(Object tree, int flags, int startPc, int endPc) {
            this.tree = tree;
            this.flags = flags;
            this.startPc = startPc;
            this.endPc = endPc;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SourceComputer
    extends Tree.Visitor {
        SourceRange result;
        static final /* synthetic */ boolean $assertionsDisabled;

        SourceComputer() {
        }

        public SourceRange csp(Tree tree) {
            if (tree == null) {
                return null;
            }
            tree.accept(this);
            if (this.result != null) {
                CRTable.this.positions.put(tree, this.result);
            }
            return this.result;
        }

        public SourceRange csp(List<Tree> trees) {
            if (trees == null || !trees.nonEmpty()) {
                return null;
            }
            SourceRange list_sr = new SourceRange();
            List<Tree> l = trees;
            while (l.nonEmpty()) {
                list_sr.mergeWith(this.csp((Tree)l.head));
                l = l.tail;
            }
            CRTable.this.positions.put(trees, list_sr);
            return list_sr;
        }

        public SourceRange cspCases(List<Tree.Case> trees) {
            if (trees == null || !trees.nonEmpty()) {
                return null;
            }
            SourceRange list_sr = new SourceRange();
            List<Tree.Case> l = trees;
            while (l.nonEmpty()) {
                list_sr.mergeWith(this.csp((Tree)l.head));
                l = l.tail;
            }
            CRTable.this.positions.put(trees, list_sr);
            return list_sr;
        }

        public SourceRange cspCatchers(List<Tree.Catch> trees) {
            if (trees == null || !trees.nonEmpty()) {
                return null;
            }
            SourceRange list_sr = new SourceRange();
            List<Tree.Catch> l = trees;
            while (l.nonEmpty()) {
                list_sr.mergeWith(this.csp((Tree)l.head));
                l = l.tail;
            }
            CRTable.this.positions.put(trees, list_sr);
            return list_sr;
        }

        @Override
        public void visitMethodDef(Tree.MethodDef tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.body));
            this.result = sr;
        }

        @Override
        public void visitVarDef(Tree.VarDef tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            this.csp(tree.vartype);
            sr.mergeWith(this.csp(tree.init));
            this.result = sr;
        }

        @Override
        public void visitSkip(Tree.Skip tree) {
            SourceRange sr;
            this.result = sr = new SourceRange(this.startPos(tree), this.startPos(tree));
        }

        @Override
        public void visitBlock(Tree.Block tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            this.csp(tree.stats);
            this.result = sr;
        }

        @Override
        public void visitDoLoop(Tree.DoLoop tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.body));
            sr.mergeWith(this.csp(tree.cond));
            this.result = sr;
        }

        @Override
        public void visitWhileLoop(Tree.WhileLoop tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.cond));
            sr.mergeWith(this.csp(tree.body));
            this.result = sr;
        }

        @Override
        public void visitForLoop(Tree.ForLoop tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.init));
            sr.mergeWith(this.csp(tree.cond));
            sr.mergeWith(this.csp(tree.step));
            sr.mergeWith(this.csp(tree.body));
            this.result = sr;
        }

        @Override
        public void visitForeachLoop(Tree.ForeachLoop tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.var));
            sr.mergeWith(this.csp(tree.expr));
            sr.mergeWith(this.csp(tree.body));
            this.result = sr;
        }

        @Override
        public void visitLabelled(Tree.Labelled tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.body));
            this.result = sr;
        }

        @Override
        public void visitSwitch(Tree.Switch tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.selector));
            sr.mergeWith(this.cspCases(tree.cases));
            this.result = sr;
        }

        @Override
        public void visitCase(Tree.Case tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.pat));
            sr.mergeWith(this.csp(tree.stats));
            this.result = sr;
        }

        @Override
        public void visitSynchronized(Tree.Synchronized tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.lock));
            sr.mergeWith(this.csp(tree.body));
            this.result = sr;
        }

        @Override
        public void visitTry(Tree.Try tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.body));
            sr.mergeWith(this.cspCatchers(tree.catchers));
            sr.mergeWith(this.csp(tree.finalizer));
            this.result = sr;
        }

        @Override
        public void visitCatch(Tree.Catch tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.param));
            sr.mergeWith(this.csp(tree.body));
            this.result = sr;
        }

        @Override
        public void visitConditional(Tree.Conditional tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.cond));
            sr.mergeWith(this.csp(tree.truepart));
            sr.mergeWith(this.csp(tree.falsepart));
            this.result = sr;
        }

        @Override
        public void visitIf(Tree.If tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.cond));
            sr.mergeWith(this.csp(tree.thenpart));
            sr.mergeWith(this.csp(tree.elsepart));
            this.result = sr;
        }

        @Override
        public void visitExec(Tree.Exec tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.expr));
            this.result = sr;
        }

        @Override
        public void visitBreak(Tree.Break tree) {
            SourceRange sr;
            this.result = sr = new SourceRange(this.startPos(tree), this.endPos(tree));
        }

        @Override
        public void visitContinue(Tree.Continue tree) {
            SourceRange sr;
            this.result = sr = new SourceRange(this.startPos(tree), this.endPos(tree));
        }

        @Override
        public void visitReturn(Tree.Return tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.expr));
            this.result = sr;
        }

        @Override
        public void visitThrow(Tree.Throw tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.expr));
            this.result = sr;
        }

        @Override
        public void visitAssert(Tree.Assert tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.cond));
            sr.mergeWith(this.csp(tree.detail));
            this.result = sr;
        }

        @Override
        public void visitApply(Tree.Apply tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.meth));
            sr.mergeWith(this.csp(tree.args));
            this.result = sr;
        }

        @Override
        public void visitNewClass(Tree.NewClass tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.encl));
            sr.mergeWith(this.csp(tree.clazz));
            sr.mergeWith(this.csp(tree.args));
            sr.mergeWith(this.csp(tree.def));
            this.result = sr;
        }

        @Override
        public void visitNewArray(Tree.NewArray tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.elemtype));
            sr.mergeWith(this.csp(tree.dims));
            sr.mergeWith(this.csp(tree.elems));
            this.result = sr;
        }

        @Override
        public void visitParens(Tree.Parens tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.expr));
            this.result = sr;
        }

        @Override
        public void visitAssign(Tree.Assign tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.lhs));
            sr.mergeWith(this.csp(tree.rhs));
            this.result = sr;
        }

        @Override
        public void visitAssignop(Tree.Assignop tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.lhs));
            sr.mergeWith(this.csp(tree.rhs));
            this.result = sr;
        }

        @Override
        public void visitUnary(Tree.Unary tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.arg));
            this.result = sr;
        }

        @Override
        public void visitBinary(Tree.Binary tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.lhs));
            sr.mergeWith(this.csp(tree.rhs));
            this.result = sr;
        }

        @Override
        public void visitTypeCast(Tree.TypeCast tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.clazz));
            sr.mergeWith(this.csp(tree.expr));
            this.result = sr;
        }

        @Override
        public void visitTypeTest(Tree.TypeTest tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.expr));
            sr.mergeWith(this.csp(tree.clazz));
            this.result = sr;
        }

        @Override
        public void visitIndexed(Tree.Indexed tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.indexed));
            sr.mergeWith(this.csp(tree.index));
            this.result = sr;
        }

        @Override
        public void visitSelect(Tree.Select tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.selected));
            this.result = sr;
        }

        @Override
        public void visitIdent(Tree.Ident tree) {
            SourceRange sr;
            this.result = sr = new SourceRange(this.startPos(tree), this.endPos(tree));
        }

        @Override
        public void visitLiteral(Tree.Literal tree) {
            SourceRange sr;
            this.result = sr = new SourceRange(this.startPos(tree), this.endPos(tree));
        }

        @Override
        public void visitTypeIdent(Tree.TypeIdent tree) {
            SourceRange sr;
            this.result = sr = new SourceRange(this.startPos(tree), this.endPos(tree));
        }

        @Override
        public void visitTypeArray(Tree.TypeArray tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.elemtype));
            this.result = sr;
        }

        @Override
        public void visitTypeApply(Tree.TypeApply tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.clazz));
            sr.mergeWith(this.csp(tree.arguments));
            this.result = sr;
        }

        @Override
        public void visitTypeParameter(Tree.TypeParameter tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.bounds));
            this.result = sr;
        }

        @Override
        public void visitTypeArgument(Tree.TypeArgument tree) {
            this.result = null;
        }

        @Override
        public void visitErroneous(Tree.Erroneous tree) {
            this.result = null;
        }

        @Override
        public void visitTree(Tree tree) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }

        public int startPos(Tree tree) {
            if (tree == null) {
                return -1;
            }
            return tree.pos;
        }

        public int endPos(Tree tree) {
            if (tree == null) {
                return -1;
            }
            if (tree.tag == 7) {
                return ((Tree.Block)tree).endpos;
            }
            Integer endpos = (Integer)CRTable.this.endPositions.get(tree);
            if (endpos != null) {
                return endpos;
            }
            return -1;
        }

        static {
            $assertionsDisabled = !(class$com$sun$tools$javac$jvm$CRTable == null ? (class$com$sun$tools$javac$jvm$CRTable = CRTable.class$("com.sun.tools.javac.jvm.CRTable")) : class$com$sun$tools$javac$jvm$CRTable).desiredAssertionStatus();
        }
    }
}

