/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.nodes.elements;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jmi.reflect.JmiException;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.java.ui.nodes.editors.TypeEditor;
import org.netbeans.modules.java.ui.nodes.elements.ElementFormat;
import org.netbeans.modules.java.ui.nodes.elements.ElementNode;
import org.netbeans.modules.java.ui.nodes.elements.SourceEditSupport;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.jmiimpl.javamodel.TypeClassImpl;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class MethodCustomizer
extends JPanel {
    private static final String[] COMMON_TYPES = TypeEditor.RVALUE_TYPES;
    private final JavaClass jclass;
    private final CallableFeature element;
    private final Method method;
    private final boolean isConstructor;
    private boolean isOK = true;
    private JPanel accessPanel;
    private JPanel exceptionsPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JTabbedPane jTabbedPane1;
    private JPanel modifierPanel;
    private JTextField nameTextField;
    private JPanel paramsPanel;
    private JComboBox returnCombo;
    private JTextField typeTextField;

    public MethodCustomizer(JavaClass jclass, CallableFeature element) {
        int mask;
        this.jclass = jclass;
        this.element = element;
        this.isConstructor = !(element instanceof Method);
        this.method = this.isConstructor ? null : (Method)element;
        this.initComponents();
        if (jclass.isInterface()) {
            mask = 1025;
        } else {
            mask = 7;
            if (!this.isConstructor) {
                mask |= 0x538;
            }
        }
        this.accessPanel.add((Component)SourceEditSupport.createAccessModifiersPanel((ClassMember)element, mask), "Center");
        PropertyPanel modifEditor = SourceEditSupport.createOtherModifiersPanel((ClassMember)element, mask);
        Node.Property fd = modifEditor.getProperty();
        String mnc = String.valueOf('\uffff');
        fd.setValue("ModifierPanel_Modifier_Abstract_Mnemonic", mnc);
        fd.setValue("ModifierPanel_Modifier_Final_Mnemonic", mnc);
        fd.setValue("ModifierPanel_Modifier_Static_Mnemonic", mnc);
        fd.setValue("ModifierPanel_Modifier_Synchronized_Mnemonic", mnc);
        fd.setValue("ModifierPanel_Modifier_Transient_Mnemonic", mnc);
        fd.setValue("ModifierPanel_Modifier_Volatile_Mnemonic", mnc);
        fd.setValue("ModifierPanel_Modifier_Native_Mnemonic", mnc);
        this.modifierPanel.add((Component)modifEditor, "Center");
        if (this.isConstructor) {
            this.nameTextField.setText(jclass.getSimpleName());
            this.nameTextField.setEnabled(false);
            this.returnCombo.setEnabled(false);
        } else {
            this.nameTextField.setText(element.getName());
            this.returnCombo.setSelectedItem(ElementFormat.elementName((NamedElement)this.method.getType()));
        }
        PropertyPanel paramsEditor = new PropertyPanel(ElementNode.createParametersProperty(element, true), 2);
        fd = paramsEditor.getProperty();
        fd.setValue("mnemonic_Add", MethodCustomizer.getString("CTL_Parameters_Mnemonic_Add"));
        fd.setValue("mnemonic_Remove", MethodCustomizer.getString("CTL_Parameters_Mnemonic_Remove"));
        fd.setValue("mnemonic_Up", MethodCustomizer.getString("CTL_Parameters_Mnemonic_Up"));
        fd.setValue("mnemonic_Down", MethodCustomizer.getString("CTL_Parameters_Mnemonic_Down"));
        fd.setValue("mnemonic_Edit", MethodCustomizer.getString("CTL_Parameters_Mnemonic_Edit"));
        this.paramsPanel.add((Component)paramsEditor, "Center");
        PropertyPanel exceptionsEditor = new PropertyPanel(ElementNode.createExceptionsProperty(element, true), 2);
        fd = exceptionsEditor.getProperty();
        fd.setValue("mnemonic_Add", MethodCustomizer.getString("CTL_Parameters_Mnemonic_Add"));
        fd.setValue("mnemonic_Remove", MethodCustomizer.getString("CTL_Parameters_Mnemonic_Remove"));
        fd.setValue("mnemonic_Up", MethodCustomizer.getString("CTL_Parameters_Mnemonic_Up"));
        fd.setValue("mnemonic_Down", MethodCustomizer.getString("CTL_Parameters_Mnemonic_Down"));
        fd.setValue("mnemonic_Edit", MethodCustomizer.getString("CTL_Parameters_Mnemonic_Edit"));
        this.exceptionsPanel.add((Component)exceptionsEditor, "Center");
        this.jLabel1.setDisplayedMnemonic(MethodCustomizer.getString("CTL_Name_Mnemonic").charAt(0));
        this.jLabel2.setDisplayedMnemonic(MethodCustomizer.getString("CTL_MethodType_Mnemonic").charAt(0));
        this.jLabel3.setVisible(false);
        this.typeTextField.setVisible(false);
        this.initAccessibility();
    }

    public void addNotify() {
        super.addNotify();
        int len = this.nameTextField.getText().length();
        this.nameTextField.setCaretPosition(0);
        this.nameTextField.moveCaretPosition(len);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MethodCustomizer.this.nameTextField.requestFocus();
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.nameTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.typeTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.returnCombo = new JComboBox<String>(COMMON_TYPES);
        this.jLabel4 = new JLabel();
        this.accessPanel = new JPanel();
        this.jLabel5 = new JLabel();
        this.modifierPanel = new JPanel();
        this.jTabbedPane1 = new JTabbedPane();
        this.paramsPanel = new JPanel();
        this.exceptionsPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(6, 6, 6, 6)));
        this.jLabel1.setLabelFor(this.nameTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage((Class)MethodCustomizer.class, (String)"CTL_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.nameTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                MethodCustomizer.this.nameTextFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 8, 0, 0);
        this.add((Component)this.nameTextField, gridBagConstraints);
        this.nameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)MethodCustomizer.class, (String)"ACSD_MethodNameTextField"));
        this.jLabel3.setLabelFor(this.typeTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage((Class)MethodCustomizer.class, (String)"CTL_Generic_Type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)this.typeTextField, gridBagConstraints);
        this.typeTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)MethodCustomizer.class, (String)"ACSD_MethodType"));
        this.jLabel2.setLabelFor(this.returnCombo);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage((Class)MethodCustomizer.class, (String)"CTL_ReturnType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.returnCombo.setEditable(true);
        this.returnCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MethodCustomizer.this.returnComboActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)this.returnCombo, gridBagConstraints);
        this.returnCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)MethodCustomizer.class, (String)"ACSD_MethodReturnType"));
        this.jLabel4.setLabelFor(this.accessPanel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getBundle((Class)MethodCustomizer.class).getString("CTL_AccessRights"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.accessPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)this.accessPanel, gridBagConstraints);
        this.jLabel5.setLabelFor(this.modifierPanel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage((Class)MethodCustomizer.class, (String)"CTL_Modifiers"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jLabel5, gridBagConstraints);
        this.modifierPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)this.modifierPanel, gridBagConstraints);
        this.paramsPanel.setLayout(new BorderLayout());
        this.paramsPanel.setBorder(new EmptyBorder(new Insets(0, 0, 10, 0)));
        this.jTabbedPane1.addTab(NbBundle.getMessage((Class)MethodCustomizer.class, (String)"CTL_Parameters"), this.paramsPanel);
        this.exceptionsPanel.setLayout(new BorderLayout());
        this.exceptionsPanel.setBorder(new EmptyBorder(new Insets(0, 0, 10, 0)));
        this.jTabbedPane1.addTab(NbBundle.getMessage((Class)MethodCustomizer.class, (String)"CTL_Exceptions"), this.exceptionsPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.jTabbedPane1, gridBagConstraints);
    }

    private void returnComboActionPerformed(ActionEvent evt) {
        Object selItem = this.returnCombo.getSelectedItem();
        if (this.isConstructor || selItem == null) {
            return;
        }
        String selItemTxt = selItem.toString().trim();
        Type oldValue = this.method.getType();
        boolean ok = false;
        try {
            Type newValue = this.getJModel().getType().resolve(selItemTxt);
            if (oldValue.equals(newValue)) {
                return;
            }
            if (!TypeEditor.isValidTypeSyntax(selItemTxt)) {
                MethodCustomizer.notifyUserWarning("MSG_Not_Valid_Type", "invalid type");
            } else {
                this.method.setType(newValue);
                ok = true;
            }
        }
        catch (JmiException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        this.isOK = ok;
        if (!ok) {
            this.returnCombo.setSelectedItem(ElementFormat.elementName((NamedElement)oldValue));
        }
    }

    private void nameTextFieldFocusLost(FocusEvent evt) {
        if (evt != null && (evt.isTemporary() || !this.isAncestorOf(evt.getOppositeComponent())) || this.isConstructor) {
            return;
        }
        String newName = this.nameTextField.getText().trim();
        String oldName = this.method.getName();
        boolean ok = false;
        try {
            if (evt == null) {
                Method met;
                if (!oldName.equals(newName)) {
                    if (!Utilities.isJavaIdentifier((String)newName)) {
                        MethodCustomizer.notifyUserWarning("MSG_Not_Valid_Identifier", "invalid name");
                        this.isOK = false;
                        this.nameTextField.setText(oldName);
                        return;
                    }
                    this.method.setName(newName);
                }
                if ((met = this.jclass.getMethod(newName, MethodCustomizer.params2Types(this.element.getParameters()), true)) != null) {
                    Type type;
                    Type retType = TypeClassImpl.getRawType((Type)this.element.getType());
                    if (retType instanceof UnresolvedClass && !((type = this.getJModel().getType().resolve("java.lang." + retType.getName())) instanceof UnresolvedClass)) {
                        retType = type;
                    }
                    if (met.getDeclaringClass() == this.jclass) {
                        MethodCustomizer.notifyUserWarning("MSG_Used_Identifier", newName, "invalid name");
                    } else if (TypeClassImpl.getRawType((Type)met.getType()) != retType) {
                        MethodCustomizer.notifyUserWarning("MSG_Another_Return_Type", newName, "invalid name");
                    } else if (Modifier.isFinal(met.getModifiers())) {
                        MethodCustomizer.notifyUserWarning("MSG_Final_Method_Overriden", met.getDeclaringClass().getName(), "invalid name");
                    } else {
                        ok = true;
                    }
                } else {
                    ok = true;
                }
            } else if (!Utilities.isJavaIdentifier((String)newName)) {
                MethodCustomizer.notifyUserWarning("MSG_Not_Valid_Identifier", "invalid name");
            } else {
                if (oldName.equals(newName)) {
                    return;
                }
                this.method.setName(newName);
                ok = true;
            }
        }
        catch (JmiException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        this.isOK = ok;
        if (!ok) {
            this.nameTextField.setText(oldName);
        }
    }

    private void initAccessibility() {
        this.nameTextField.getAccessibleContext().setAccessibleName(MethodCustomizer.getString("ACS_MethodNameTextField"));
        this.nameTextField.getAccessibleContext().setAccessibleDescription(MethodCustomizer.getString("ACS_MethodNameTextField"));
        this.getAccessibleContext().setAccessibleDescription(MethodCustomizer.getString("ACSD_MethodCustomizerDialog"));
    }

    public boolean isOK() {
        this.nameTextFieldFocusLost(null);
        if (this.isOK) {
            this.returnComboActionPerformed(null);
        }
        return this.isOK;
    }

    private JavaModelPackage getJModel() {
        return JavaMetamodel.getManager().getJavaExtent((Element)this.jclass);
    }

    private static String getString(String key) {
        return NbBundle.getMessage((Class)MethodCustomizer.class, (String)key);
    }

    private static void notifyUserWarning(String bundleKey, String msg) {
        IllegalArgumentException e = new IllegalArgumentException(msg);
        ErrorManager.getDefault().annotate((Throwable)e, 256, null, MethodCustomizer.getString(bundleKey), null, null);
        ErrorManager.getDefault().notify((Throwable)e);
    }

    private static void notifyUserWarning(String bundleKey, String param, String msg) {
        IllegalArgumentException e = new IllegalArgumentException(msg);
        ErrorManager.getDefault().annotate((Throwable)e, 256, null, NbBundle.getMessage((Class)MethodCustomizer.class, (String)bundleKey, (Object)param), null, null);
        ErrorManager.getDefault().notify((Throwable)e);
    }

    private static List params2Types(List params) {
        ArrayList<Type> types = new ArrayList<Type>(params.size());
        Iterator it = params.iterator();
        while (it.hasNext()) {
            Parameter p = (Parameter)it.next();
            Type t = p.getType();
            types.add(t);
        }
        return types;
    }
}

