/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.wizard;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.ui.wizard.Util;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;

class JavaPackageIterator
implements TemplateWizard.Iterator {
    WizardDescriptor.Panel targetChooser;
    TemplateWizard wizardInstance;

    JavaPackageIterator() {
    }

    static TemplateWizard.Iterator create() {
        return new JavaPackageIterator();
    }

    public boolean hasNext() {
        return false;
    }

    public void previousPanel() {
        throw new NoSuchElementException();
    }

    public void removeChangeListener(ChangeListener l) {
    }

    public void addChangeListener(ChangeListener l) {
    }

    public String name() {
        return "";
    }

    public void nextPanel() {
        throw new NoSuchElementException();
    }

    public boolean hasPrevious() {
        return false;
    }

    public WizardDescriptor.Panel current() {
        return this.wizardInstance.targetChooser();
    }

    public void initialize(TemplateWizard wiz) {
        this.wizardInstance = wiz;
    }

    public void uninitialize(TemplateWizard wiz) {
    }

    private void throwIllegalName(String key, String offending) throws IllegalStateException {
        String msg = offending == null ? Util.getString(key) : MessageFormat.format(Util.getString(key), offending);
        IllegalStateException x = (IllegalStateException)ErrorManager.getDefault().annotate((Throwable)new IllegalStateException(msg), 256, null, msg, null, null);
        throw x;
    }

    public Set instantiate(TemplateWizard wiz) throws IOException {
        String tn;
        String s;
        DataFolder fld = wiz.getTargetFolder();
        FileObject fldFO = fld.getPrimaryFile();
        ClassPath cp = ClassPath.getClassPath((FileObject)fldFO, (String)"classpath/source");
        if (cp == null) {
            this.throwIllegalName("ERR_NotInSourcePath", null);
        }
        if (!Util.isValidPackageName(s = cp.getResourceName(fldFO, '.', false))) {
            this.throwIllegalName("FMTERR_InvalidPackage", s);
        }
        if ((tn = wiz.getTargetName()) == null) {
            tn = Util.getString("TXT_DefaultPackageName");
        } else if (!Util.isValidPackageName(tn)) {
            this.throwIllegalName("FMTERR_InvalidPackage", tn);
        }
        s = s + '.' + tn;
        String pkgPath = s.replace('.', '/');
        FileObject target = cp.findResource(pkgPath);
        if (target != null && target.isFolder()) {
            this.throwIllegalName("FMTERR_pkg_already_exist", tn);
        }
        DataObject d = DataObject.find((FileObject)FileUtil.createFolder((FileObject)fldFO, (String)tn.replace('.', '/')));
        s = d.getName();
        fld = d.getFolder();
        d = d.createFromTemplate(fld, s);
        return Collections.singleton(d);
    }
}

