/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenProcessor;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.java.JavaFoldManager;
import org.netbeans.editor.ext.java.JavaTokenContext;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.Import;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaDoc;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.java.NbJavaSyntaxSupport;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.ParsingListener;
import org.netbeans.spi.editor.fold.FoldHierarchyTransaction;
import org.netbeans.spi.editor.fold.FoldManager;
import org.netbeans.spi.editor.fold.FoldManagerFactory;
import org.netbeans.spi.editor.fold.FoldOperation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.PositionBounds;
import org.openide.util.RequestProcessor;

final class NbJavaFoldManager
extends JavaFoldManager
implements SettingsChangeListener,
ParsingListener,
Runnable {
    private static final int INIT_FOLDS_PARSING_FOLD_UPDATES_DELAY = 1000;
    private static boolean debug = Boolean.getBoolean("netbeans.debug.editor.fold.manager.java");
    private FoldOperation operation;
    private final HashMap id2foldInfo = new HashMap();
    private Fold initialCommentFold;
    private Fold importsFold;
    private boolean foldImportsPreset;
    private boolean foldInnerClassesPreset;
    private boolean foldJavadocsPreset;
    private boolean foldCodeBlocksPreset;
    private boolean foldInitialCommentsPreset;
    private boolean listeningOnParsing;
    private boolean documentModified;
    private static RequestProcessor javaFoldsRP;
    static /* synthetic */ Class class$org$netbeans$modules$editor$java$NbJavaFoldManager;

    private static synchronized RequestProcessor getJavaFoldsRP() {
        if (javaFoldsRP == null) {
            javaFoldsRP = new RequestProcessor("Java-Folds", 1);
        }
        return javaFoldsRP;
    }

    public void init(FoldOperation operation) {
        this.operation = operation;
        this.settingsChange(null);
    }

    private FoldOperation getOperation() {
        return this.operation;
    }

    public void initFolds(FoldHierarchyTransaction transaction) {
        if (this.foldImportsPreset || this.foldCodeBlocksPreset || this.foldInnerClassesPreset || this.foldJavadocsPreset) {
            NbJavaFoldManager.getJavaFoldsRP().post((Runnable)this);
        } else {
            NbJavaFoldManager.getJavaFoldsRP().post((Runnable)this, 1000, 1);
        }
    }

    public void insertUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
        this.documentModified = true;
    }

    public void removeUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
        this.documentModified = true;
    }

    public void changedUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
    }

    public void removeEmptyNotify(Fold emptyFold) {
        this.removeFoldNotify(emptyFold);
    }

    public void removeDamagedNotify(Fold damagedFold) {
        this.removeFoldNotify(damagedFold);
    }

    public void expandNotify(Fold expandedFold) {
    }

    public void release() {
    }

    public void resourceParsed(Resource resource) {
        FileObject primaryFile;
        DataObject dob = this.getDataObject();
        if (dob != null && (primaryFile = dob.getPrimaryFile()) != null) {
            String resourceName;
            try {
                resourceName = resource.getName();
            }
            catch (Exception e) {
                resourceName = null;
            }
            if (resourceName != null && primaryFile.getPath().endsWith(resourceName) && JavaModel.getFileObject((Resource)resource) == primaryFile) {
                this.updateFolds(null);
            }
        }
    }

    public void run() {
        try {
            Resource resource = this.getResource();
            if (resource != null && resource.isValid()) {
                if (!this.listeningOnParsing) {
                    this.listeningOnParsing = true;
                    new WeakParsingListener(this).startListening();
                }
                this.updateFolds(null);
            }
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable t) {
            ErrorManager.getDefault().notify(t);
        }
    }

    private void updateFolds(FoldHierarchyTransaction transaction) {
        if (!this.getOperation().isReleased()) {
            final UpdateFoldsRequest request = this.collectFoldUpdates(transaction != null);
            if (transaction != null) {
                this.processUpdateFoldRequest(request, transaction);
            } else {
                Runnable hierarchyUpdate = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        if (!NbJavaFoldManager.this.getOperation().isReleased()) {
                            Document doc = NbJavaFoldManager.this.getDocument();
                            if (!(doc instanceof AbstractDocument)) {
                                return;
                            }
                            AbstractDocument adoc = (AbstractDocument)doc;
                            adoc.readLock();
                            try {
                                FoldHierarchy hierarchy = NbJavaFoldManager.this.getOperation().getHierarchy();
                                hierarchy.lock();
                                try {
                                    FoldHierarchyTransaction t = NbJavaFoldManager.this.getOperation().openTransaction();
                                    try {
                                        NbJavaFoldManager.this.processUpdateFoldRequest(request, t);
                                    }
                                    finally {
                                        t.commit();
                                    }
                                }
                                finally {
                                    hierarchy.unlock();
                                }
                            }
                            finally {
                                adoc.readUnlock();
                            }
                        }
                    }
                };
                SwingUtilities.invokeLater(hierarchyUpdate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateFoldsRequest collectFoldUpdates(boolean inInitFolds) {
        UpdateFoldsRequest request = new UpdateFoldsRequest();
        Document doc = this.getDocument();
        if (this.getOperation().isReleased() || !(doc instanceof AbstractDocument)) {
            return request;
        }
        AbstractDocument adoc = (AbstractDocument)doc;
        if (inInitFolds && !this.isAnydFoldPresetRequiringParsing()) {
            adoc.readLock();
            try {
                this.collectNonParsingFoldUpdates(request, adoc);
            }
            catch (BadLocationException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            finally {
                adoc.readUnlock();
            }
            NbJavaFoldManager.getJavaFoldsRP().post((Runnable)this, 1000);
        } else {
            ((JMManager)JMManager.getManager()).waitScanFinished();
            JavaModel.getJavaRepository().beginTrans(false);
            try {
                JavaModel.setClassPath((FileObject)this.getDataObject().getPrimaryFile());
                Resource resource = this.getResource();
                if (resource == null || !resource.isValid()) {
                    UpdateFoldsRequest updateFoldsRequest = request;
                    return updateFoldsRequest;
                }
                adoc.readLock();
                try {
                    this.collectNonParsingFoldUpdates(request, adoc);
                    int docLength = adoc.getLength();
                    int importsStartOffset = Integer.MAX_VALUE;
                    int importsEndOffset = Integer.MIN_VALUE;
                    Iterator it = resource.getImports().iterator();
                    while (it.hasNext()) {
                        Import imp = (Import)it.next();
                        PositionBounds pb = JavaMetamodel.getManager().getElementPosition((Element)imp);
                        importsStartOffset = Math.min(importsStartOffset, pb.getBegin().getOffset());
                        importsEndOffset = Math.max(importsEndOffset, pb.getEnd().getOffset());
                    }
                    if (importsStartOffset != Integer.MAX_VALUE && importsStartOffset >= 0 && (importsStartOffset += 7) < importsEndOffset && importsEndOffset <= docLength) {
                        request.setImportsFoldInfo(new ImportsFoldInfo(adoc.createPosition(importsStartOffset), adoc.createPosition(importsEndOffset)));
                    }
                    List l = resource.getClassifiers();
                    Iterator it2 = l.iterator();
                    while (it2.hasNext()) {
                        JavaClass cls = (JavaClass)it2.next();
                        if (debug) {
                            System.err.println("JavaFoldManager: found Class: " + cls);
                        }
                        this.collectClassFoldUpdates(request, cls, true, adoc);
                    }
                }
                catch (BadLocationException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
                finally {
                    adoc.readUnlock();
                }
            }
            finally {
                JavaModel.getJavaRepository().endTrans();
            }
        }
        return request;
    }

    private void collectNonParsingFoldUpdates(UpdateFoldsRequest request, AbstractDocument doc) throws BadLocationException {
        int docLength = doc.getLength();
        BaseDocument bdoc = (BaseDocument)doc;
        NbJavaSyntaxSupport sup = (NbJavaSyntaxSupport)bdoc.getSyntaxSupport();
        InitialCommentProcessor icp = new InitialCommentProcessor();
        sup.tokenizeText(icp, 0, docLength, false);
        int icStartOffset = icp.getCommentStartOffset();
        int icEndOffset = icp.getCommentEndOffset();
        if (icStartOffset >= 0 && icStartOffset < icEndOffset && icEndOffset <= docLength) {
            request.setInitialCommentFoldInfo(new InitialCommentFoldInfo(bdoc.createPosition(icStartOffset), bdoc.createPosition(icEndOffset)));
        }
    }

    private void collectClassFoldUpdates(UpdateFoldsRequest request, JavaClass cls, boolean topLevel, AbstractDocument doc) throws BadLocationException {
        ClassMemberFoldInfo clsInfo = new ClassMemberFoldInfo((ClassMember)cls, topLevel, doc);
        request.addMemberFoldInfo(clsInfo);
        Iterator it = cls.getFeatures().iterator();
        while (it.hasNext()) {
            Feature f = (Feature)it.next();
            if (debug) {
                System.err.println("JavaFoldManager: found Feature: " + f);
            }
            if (f instanceof JavaClass) {
                JavaClass subCls = (JavaClass)f;
                if (debug) {
                    System.err.println("JavaFoldManager: found SubClass: " + subCls);
                }
                this.collectClassFoldUpdates(request, subCls, false, doc);
                continue;
            }
            boolean javadocOnly = f instanceof Field;
            ClassMemberFoldInfo featureInfo = new ClassMemberFoldInfo((ClassMember)f, javadocOnly, doc);
            request.addMemberFoldInfo(featureInfo);
        }
    }

    private void processUpdateFoldRequest(UpdateFoldsRequest request, FoldHierarchyTransaction transaction) {
        if (request.isValid()) {
            String id;
            Iterator<Object> it;
            Fold origFold = this.getInitialCommentFold();
            InitialCommentFoldInfo icInfo = request.getInitialCommentFoldInfo();
            if (icInfo != null) {
                if (icInfo.isUpdateNecessary(origFold)) {
                    boolean collapsed;
                    boolean bl = origFold != null ? origFold.isCollapsed() : (collapsed = this.documentModified ? false : this.foldInitialCommentsPreset);
                    if (origFold != null) {
                        this.getOperation().removeFromHierarchy(origFold, transaction);
                        this.setInitialCommentFold(null);
                    }
                    try {
                        icInfo.updateHierarchy(transaction, collapsed);
                    }
                    catch (BadLocationException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                }
            } else if (origFold != null) {
                this.getOperation().removeFromHierarchy(origFold, transaction);
                this.setInitialCommentFold(null);
            }
            origFold = this.getImportsFold();
            ImportsFoldInfo impsInfo = request.getImportsFoldInfo();
            if (impsInfo != null) {
                if (impsInfo.isUpdateNecessary(origFold)) {
                    boolean collapsed;
                    boolean bl = origFold != null ? origFold.isCollapsed() : (collapsed = this.documentModified ? false : this.foldImportsPreset);
                    if (origFold != null) {
                        this.getOperation().removeFromHierarchy(origFold, transaction);
                        this.setImportsFold(null);
                    }
                    try {
                        impsInfo.updateHierarchy(transaction, collapsed);
                    }
                    catch (BadLocationException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                }
            } else if (origFold != null) {
                this.getOperation().removeFromHierarchy(origFold, transaction);
                this.setImportsFold(null);
            }
            Map obsoleteId2FoldInfo = (Map)this.id2foldInfo.clone();
            List infoList = request.getMemberFoldInfos();
            if (infoList != null) {
                it = infoList.iterator();
                while (it.hasNext()) {
                    ClassMemberFoldInfo orig;
                    ClassMemberFoldInfo info = (ClassMemberFoldInfo)it.next();
                    if (info.isUpdateNecessary(orig = this.findClassMemberFoldInfo(id = info.getId()))) {
                        if (orig != null) {
                            orig.removeFromHierarchy(transaction);
                        }
                        try {
                            info.updateHierarchy(transaction, orig);
                        }
                        catch (BadLocationException e) {
                            ErrorManager.getDefault().notify((Throwable)e);
                        }
                        this.putClassMemberFoldInfo(id, info);
                    }
                    if (orig == null) continue;
                    obsoleteId2FoldInfo.remove(id);
                }
            }
            it = obsoleteId2FoldInfo.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = (Map.Entry)it.next();
                id = (String)e.getKey();
                ClassMemberFoldInfo foldInfo = (ClassMemberFoldInfo)e.getValue();
                foldInfo.removeFromHierarchy(transaction);
                this.removeClassMemberFoldInfo(id);
                if (!debug) continue;
                System.err.println("Removing obsolete foldInfo: " + foldInfo);
            }
        }
    }

    private boolean isAnydFoldPresetRequiringParsing() {
        return this.foldImportsPreset || this.foldCodeBlocksPreset || this.foldInnerClassesPreset || this.foldJavadocsPreset;
    }

    Fold getInitialCommentFold() {
        return this.initialCommentFold;
    }

    void setInitialCommentFold(Fold initialCommentFold) {
        this.initialCommentFold = initialCommentFold;
    }

    Fold getImportsFold() {
        return this.importsFold;
    }

    void setImportsFold(Fold importsFold) {
        this.importsFold = importsFold;
    }

    private ClassMemberFoldInfo findClassMemberFoldInfo(String id) {
        return (ClassMemberFoldInfo)this.id2foldInfo.get(id);
    }

    private void removeClassMemberFoldInfo(String id) {
        this.id2foldInfo.remove(id);
    }

    private void putClassMemberFoldInfo(String id, ClassMemberFoldInfo info) {
        this.id2foldInfo.put(id, info);
    }

    public void settingsChange(SettingsChangeEvent evt) {
        this.foldInitialCommentsPreset = this.getSetting("code-folding-collapse-initial-comment");
        this.foldImportsPreset = this.getSetting("code-folding-collapse-import");
        this.foldCodeBlocksPreset = this.getSetting("code-folding-collapse-method");
        this.foldInnerClassesPreset = this.getSetting("code-folding-collapse-innerclass");
        this.foldJavadocsPreset = this.getSetting("code-folding-collapse-javadoc");
    }

    private boolean getSetting(String settingName) {
        JTextComponent tc = this.getOperation().getHierarchy().getComponent();
        return SettingsUtil.getBoolean((Class)Utilities.getKitClass((JTextComponent)tc), (String)settingName, (boolean)false);
    }

    Document getDocument() {
        return this.getOperation().getHierarchy().getComponent().getDocument();
    }

    DataObject getDataObject() {
        Document doc = this.getDocument();
        return doc != null ? NbEditorUtilities.getDataObject((Document)doc) : null;
    }

    Resource getResource() {
        DataObject dob = this.getDataObject();
        return dob != null ? JavaModel.getResource((FileObject)dob.getPrimaryFile()) : null;
    }

    private void removeFoldNotify(Fold fold) {
        if (fold == this.getInitialCommentFold()) {
            this.setInitialCommentFold(null);
        } else if (fold == this.getImportsFold()) {
            this.setImportsFold(null);
        } else {
            ClassMemberFoldInfo info = (ClassMemberFoldInfo)this.getOperation().getExtraInfo(fold);
            info.removeFoldNotify(fold);
        }
    }

    public static final class Factory
    implements FoldManagerFactory {
        public FoldManager createFoldManager() {
            return new NbJavaFoldManager();
        }
    }

    private static final class WeakParsingListener
    implements ParsingListener {
        private WeakReference ref;

        WeakParsingListener(ParsingListener l) {
            this.ref = new WeakReference<ParsingListener>(l);
        }

        public void startListening() {
            JavaMetamodel.getManager();
            JavaMetamodel.addParsingListener((ParsingListener)this);
        }

        public void resourceParsed(Resource r) {
            ParsingListener l = (ParsingListener)this.ref.get();
            if (l != null) {
                l.resourceParsed(r);
            } else {
                JavaMetamodel.getManager();
                JavaMetamodel.removeParsingListener((ParsingListener)this);
            }
        }
    }

    private final class UpdateFoldsRequest {
        private Document creationTimeDoc;
        private InitialCommentFoldInfo initialCommentFoldInfo;
        private ImportsFoldInfo importsFoldInfo;
        private List memberFoldInfos;

        UpdateFoldsRequest() {
            this.creationTimeDoc = NbJavaFoldManager.this.getDocument();
        }

        boolean isValid() {
            return this.creationTimeDoc == NbJavaFoldManager.this.getDocument();
        }

        InitialCommentFoldInfo getInitialCommentFoldInfo() {
            return this.initialCommentFoldInfo;
        }

        void setInitialCommentFoldInfo(InitialCommentFoldInfo initialCommentFoldInfo) {
            this.initialCommentFoldInfo = initialCommentFoldInfo;
        }

        ImportsFoldInfo getImportsFoldInfo() {
            return this.importsFoldInfo;
        }

        void setImportsFoldInfo(ImportsFoldInfo importsFoldInfo) {
            this.importsFoldInfo = importsFoldInfo;
        }

        List getMemberFoldInfos() {
            return this.memberFoldInfos;
        }

        void addMemberFoldInfo(ClassMemberFoldInfo foldInfo) {
            if (this.memberFoldInfos == null) {
                this.memberFoldInfos = new ArrayList();
            }
            this.memberFoldInfos.add(foldInfo);
        }
    }

    private final class ClassMemberFoldInfo {
        private String id;
        private ClassMember classMember;
        private JavaDoc javadoc;
        private Fold fold;
        private Fold javadocFold;
        private boolean javadocFoldOnly;
        private JavaFoldManager.FoldTemplate template;
        private JavaFoldManager.FoldTemplate javadocTemplate;
        private Position classMemberStartPos;
        private Position classMemberEndPos;
        private Position javadocStartPos;
        private Position javadocEndPos;
        static final /* synthetic */ boolean $assertionsDisabled;

        public ClassMemberFoldInfo(ClassMember classMember, boolean javadocFoldOnly, AbstractDocument doc) throws BadLocationException {
            PositionBounds bounds;
            this.classMember = classMember;
            this.javadocFoldOnly = javadocFoldOnly;
            this.template = JavaFoldManager.CODE_BLOCK_FOLD_TEMPLATE;
            this.javadocTemplate = JavaFoldManager.JAVADOC_FOLD_TEMPLATE;
            this.id = classMember.refMofId();
            this.javadoc = classMember.getJavadoc();
            int docLength = doc.getLength();
            JavaMetamodel jmm = JavaMetamodel.getManager();
            if (!javadocFoldOnly) {
                PositionBounds bounds2;
                ClassMember elem = classMember;
                if (elem instanceof Method) {
                    // empty if block
                }
                if ((bounds2 = jmm.getElementPosition((Element)elem)) != null) {
                    int startOffset = bounds2.getBegin().getOffset();
                    int endOffset = bounds2.getEnd().getOffset();
                    if (startOffset >= 0 && startOffset < endOffset && endOffset <= docLength) {
                        if ((elem instanceof Method || elem instanceof Constructor || elem instanceof JavaClass) && doc instanceof BaseDocument) {
                            BaseDocument bdoc = (BaseDocument)doc;
                            NbJavaSyntaxSupport sup = (NbJavaSyntaxSupport)bdoc.getSyntaxSupport();
                            OpeningBraceProcessor obp = new OpeningBraceProcessor(endOffset);
                            sup.tokenizeText(obp, startOffset, endOffset, false);
                            int braceOffset = obp.getOpeningBraceOffset();
                            startOffset = braceOffset >= 0 && braceOffset < endOffset ? braceOffset : -1;
                        }
                        if (startOffset >= 0) {
                            this.classMemberStartPos = doc.createPosition(startOffset);
                            this.classMemberEndPos = doc.createPosition(endOffset);
                        }
                    }
                }
            }
            if (this.javadoc != null && (bounds = jmm.getElementPosition((Element)this.javadoc)) != null) {
                int startOffset = bounds.getBegin().getOffset();
                int endOffset = bounds.getEnd().getOffset();
                if (startOffset >= 0 && startOffset < endOffset && endOffset <= docLength) {
                    this.javadocStartPos = doc.createPosition(startOffset);
                    this.javadocEndPos = doc.createPosition(endOffset);
                }
            }
        }

        public String getId() {
            return this.id;
        }

        public boolean isUpdateNecessary(ClassMemberFoldInfo orig) {
            boolean update = false;
            if (orig == null) {
                update = true;
            } else {
                if (!this.javadocFoldOnly) {
                    Fold origFold = orig.getFold();
                    if (this.classMemberStartPos != null && (origFold == null || this.classMemberStartPos.getOffset() != origFold.getStartOffset() || this.classMemberEndPos.getOffset() != origFold.getEndOffset())) {
                        update = true;
                    }
                }
                if (!update && this.javadoc != null) {
                    Fold origJavadocFold = orig.getJavadocFold();
                    if (this.javadocStartPos != null && origJavadocFold != null) {
                        if (this.javadocStartPos.getOffset() != origJavadocFold.getStartOffset() || this.javadocEndPos.getOffset() != origJavadocFold.getEndOffset()) {
                            update = true;
                        }
                    } else {
                        update = true;
                    }
                }
            }
            return update;
        }

        public void updateHierarchy(FoldHierarchyTransaction transaction, ClassMemberFoldInfo origInfo) throws BadLocationException {
            int endOffset;
            int startOffset;
            if (debug) {
                System.err.println("JavaFoldManager.updateHierarchy(): classMember=" + this.classMember);
            }
            if (!this.javadocFoldOnly && this.classMemberStartPos != null && FoldOperation.isBoundsValid((int)(startOffset = this.classMemberStartPos.getOffset()), (int)(endOffset = this.classMemberEndPos.getOffset()), (int)this.template.getStartGuardedLength(), (int)this.template.getEndGuardedLength())) {
                Fold origFold;
                boolean collapsed = origInfo != null && (origFold = origInfo.getFold()) != null ? origFold.isCollapsed() : (NbJavaFoldManager.this.documentModified ? false : (this.classMember instanceof JavaClass ? NbJavaFoldManager.this.foldInnerClassesPreset : NbJavaFoldManager.this.foldCodeBlocksPreset));
                this.fold = NbJavaFoldManager.this.getOperation().addToHierarchy(this.template.getType(), this.template.getDescription(), collapsed, startOffset, endOffset, this.template.getStartGuardedLength(), this.template.getEndGuardedLength(), (Object)this, transaction);
            }
            if (this.javadoc != null && this.javadocStartPos != null && FoldOperation.isBoundsValid((int)(startOffset = this.javadocStartPos.getOffset()), (int)(endOffset = this.javadocEndPos.getOffset()), (int)this.javadocTemplate.getStartGuardedLength(), (int)this.javadocTemplate.getEndGuardedLength())) {
                Fold origJavadocFold;
                boolean javadocCollapsed = origInfo != null && (origJavadocFold = origInfo.getJavadocFold()) != null ? origJavadocFold.isCollapsed() : (NbJavaFoldManager.this.documentModified ? false : NbJavaFoldManager.this.foldJavadocsPreset);
                this.javadocFold = NbJavaFoldManager.this.getOperation().addToHierarchy(this.javadocTemplate.getType(), this.javadocTemplate.getDescription(), javadocCollapsed, startOffset, endOffset, this.javadocTemplate.getStartGuardedLength(), this.javadocTemplate.getEndGuardedLength(), (Object)this, transaction);
            }
        }

        public void removeFromHierarchy(FoldHierarchyTransaction transaction) {
            if (debug) {
                System.err.println("JavaFoldManager.removeFromHierarchy(): " + this);
            }
            if (this.fold != null) {
                NbJavaFoldManager.this.getOperation().removeFromHierarchy(this.fold, transaction);
            }
            if (this.javadocFold != null) {
                NbJavaFoldManager.this.getOperation().removeFromHierarchy(this.javadocFold, transaction);
            }
        }

        public Fold getFold() {
            return this.fold;
        }

        public Fold getJavadocFold() {
            return this.javadocFold;
        }

        public void removeFoldNotify(Fold removedFold) {
            if (removedFold == this.fold) {
                this.fold = null;
            } else if (removedFold == this.javadocFold) {
                this.javadocFold = null;
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }

        public ClassMember getClassMember() {
            return this.classMember;
        }

        public JavaDoc getJavadoc() {
            return this.javadoc;
        }

        public String toString() {
            return "fold=" + this.fold + ", javadocFold=" + this.javadocFold;
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$editor$java$NbJavaFoldManager == null ? (class$org$netbeans$modules$editor$java$NbJavaFoldManager = NbJavaFoldManager.class$("org.netbeans.modules.editor.java.NbJavaFoldManager")) : class$org$netbeans$modules$editor$java$NbJavaFoldManager).desiredAssertionStatus();
        }
    }

    private final class ImportsFoldInfo {
        private Position importsStartPos;
        private Position importsEndPos;

        ImportsFoldInfo(Position importsStartPos, Position importsEndPos) {
            this.importsStartPos = importsStartPos;
            this.importsEndPos = importsEndPos;
        }

        public boolean isUpdateNecessary(Fold origImportsFold) {
            return origImportsFold == null || origImportsFold.getStartOffset() != this.importsStartPos.getOffset() || origImportsFold.getEndOffset() != this.importsEndPos.getOffset();
        }

        public void updateHierarchy(FoldHierarchyTransaction transaction, boolean collapsed) throws BadLocationException {
            int endOffset;
            int startOffset = this.importsStartPos.getOffset();
            if (FoldOperation.isBoundsValid((int)startOffset, (int)(endOffset = this.importsEndPos.getOffset()), (int)JavaFoldManager.IMPORTS_FOLD_TEMPLATE.getStartGuardedLength(), (int)JavaFoldManager.IMPORTS_FOLD_TEMPLATE.getEndGuardedLength())) {
                Fold fold = NbJavaFoldManager.this.getOperation().addToHierarchy(JavaFoldManager.IMPORTS_FOLD_TEMPLATE.getType(), JavaFoldManager.IMPORTS_FOLD_TEMPLATE.getDescription(), collapsed, startOffset, endOffset, JavaFoldManager.IMPORTS_FOLD_TEMPLATE.getStartGuardedLength(), JavaFoldManager.IMPORTS_FOLD_TEMPLATE.getEndGuardedLength(), (Object)this, transaction);
                NbJavaFoldManager.this.setImportsFold(fold);
            }
        }
    }

    private final class InitialCommentFoldInfo {
        private Position initialCommentStartPos;
        private Position initialCommentEndPos;

        InitialCommentFoldInfo(Position initialCommentStartPos, Position initialCommentEndPos) {
            this.initialCommentStartPos = initialCommentStartPos;
            this.initialCommentEndPos = initialCommentEndPos;
        }

        public boolean isUpdateNecessary(Fold origInitialCommentFold) {
            return origInitialCommentFold == null || origInitialCommentFold.getStartOffset() != this.initialCommentStartPos.getOffset() || origInitialCommentFold.getEndOffset() != this.initialCommentEndPos.getOffset();
        }

        public void updateHierarchy(FoldHierarchyTransaction transaction, boolean collapsed) throws BadLocationException {
            int endOffset;
            int startOffset = this.initialCommentStartPos.getOffset();
            if (FoldOperation.isBoundsValid((int)startOffset, (int)(endOffset = this.initialCommentEndPos.getOffset()), (int)JavaFoldManager.INITIAL_COMMENT_FOLD_TEMPLATE.getStartGuardedLength(), (int)JavaFoldManager.INITIAL_COMMENT_FOLD_TEMPLATE.getEndGuardedLength())) {
                Fold fold = NbJavaFoldManager.this.getOperation().addToHierarchy(JavaFoldManager.INITIAL_COMMENT_FOLD_TEMPLATE.getType(), JavaFoldManager.INITIAL_COMMENT_FOLD_TEMPLATE.getDescription(), collapsed, startOffset, endOffset, JavaFoldManager.INITIAL_COMMENT_FOLD_TEMPLATE.getStartGuardedLength(), JavaFoldManager.INITIAL_COMMENT_FOLD_TEMPLATE.getEndGuardedLength(), (Object)this, transaction);
                NbJavaFoldManager.this.setInitialCommentFold(fold);
            }
        }
    }

    private static final class OpeningBraceProcessor
    implements TokenProcessor {
        private int bufferStartOffset;
        private int limitOffset = -1;
        private int openingBraceOffset = -1;

        public int eot(int offset) {
            return 0;
        }

        OpeningBraceProcessor(int limitOffset) {
            this.limitOffset = limitOffset;
        }

        public void nextBuffer(char[] buffer, int offset, int len, int startPos, int preScan, boolean lastBuffer) {
            this.bufferStartOffset = startPos - offset;
        }

        public boolean token(TokenID tokenID, TokenContextPath tokenContextPath, int tokenBufferOffset, int tokenLength) {
            int offset = this.bufferStartOffset + tokenBufferOffset;
            if (JavaTokenContext.LBRACE.equals(tokenID)) {
                this.openingBraceOffset = offset;
                return false;
            }
            return offset < this.limitOffset;
        }

        public int getOpeningBraceOffset() {
            return this.openingBraceOffset;
        }
    }

    private final class InitialCommentProcessor
    implements TokenProcessor {
        private int bufferStartOffset;
        private int commentStartOffset = -1;
        private int commentEndOffset = -1;

        public int eot(int offset) {
            return 0;
        }

        public void nextBuffer(char[] buffer, int offset, int len, int startPos, int preScan, boolean lastBuffer) {
            this.bufferStartOffset = startPos - offset;
        }

        public boolean token(TokenID tokenID, TokenContextPath tokenContextPath, int tokenBufferOffset, int tokenLength) {
            Document doc = NbJavaFoldManager.this.getOperation().getHierarchy().getComponent().getDocument();
            if (JavaTokenContext.BLOCK_COMMENT.equals(tokenID) && doc != null) {
                int startOffset = this.bufferStartOffset + tokenBufferOffset;
                try {
                    String text = doc.getText(startOffset, 3);
                    if (!"/**".equals(text)) {
                        this.commentStartOffset = this.bufferStartOffset + tokenBufferOffset;
                        this.commentEndOffset = this.commentStartOffset + tokenLength;
                    }
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
                return false;
            }
            return JavaTokenContext.WHITESPACE.equals(tokenID);
        }

        public int getCommentStartOffset() {
            return this.commentStartOffset;
        }

        public int getCommentEndOffset() {
            return this.commentEndOffset;
        }
    }
}

