/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.netbeans.editor.DialogSupport;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.WeakTimerListener;
import org.netbeans.editor.ext.ListCompletionView;
import org.netbeans.editor.ext.java.JCCellRenderer;
import org.netbeans.editor.ext.java.JavaFastOpenPanel;
import org.netbeans.editor.ext.java.JavaSettingsDefaults;
import org.openide.util.RequestProcessor;

public abstract class JavaFastOpen
implements ActionListener {
    private static final int TIMER_DELAY = 1000;
    private JavaFastOpenPanel panel;
    private ListCellRenderer cellRenderer;
    private JList resultList;
    private Dialog dialog;
    private JButton[] buttons;
    private Evaluator evaluator;
    private static Timer timer;
    protected boolean caseSensitive;
    protected boolean includeInnerClasses;
    protected boolean includeLibraryClasses;
    private static final int SET_EXP = 1;
    private static final int POPULATE_LIST = 2;
    private static final int OPEN = 3;
    protected static JavaFastOpen fastOpen;

    public JavaFastOpen() {
        timer = new Timer(0, (ActionListener)new WeakTimerListener((ActionListener)this));
        timer.setRepeats(false);
    }

    public void setDialogVisible(boolean visible) {
        if (this.dialog == null) {
            this.dialog = this.createDialog();
        }
        if (visible) {
            this.caseSensitive = this.isCaseSensitive();
            this.includeInnerClasses = this.isIncludeInnerClasses();
            this.includeLibraryClasses = this.isIncludeLibraryClasses();
            this.getPanel().setCaseSensitive(this.caseSensitive);
            this.getPanel().setIncludeInnerClasses(this.includeInnerClasses);
            this.getPanel().setIncludeLibraryClasses(this.includeLibraryClasses);
            this.getPanel().popupNotify();
            this.dialog.setVisible(true);
        } else {
            this.dialog.setVisible(false);
            if (this.evaluator != null) {
                this.evaluator.breakLoop();
            }
            this.dialog.dispose();
            fastOpen = null;
        }
    }

    protected void openSource(Object item, int order) {
    }

    protected ListCellRenderer createCellRenderer() {
        JCCellRenderer rr = new JCCellRenderer();
        return rr;
    }

    protected JList createResultList() {
        ListCompletionView list = new ListCompletionView(this.getCellRenderer());
        list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                ListCompletionView view = (ListCompletionView)JavaFastOpen.this.getResultList();
                if (e.getClickCount() == 2 && view.showingData()) {
                    JavaFastOpen.this.actionPerformed(new ActionEvent(JavaFastOpen.this.getButtons()[0], 0, ""));
                }
            }
        });
        return list;
    }

    protected JButton[] getButtons() {
        if (this.buttons == null) {
            this.buttons = new JButton[]{new JButton(LocaleSupport.getString((String)"JFO_openSourceButton", (String)"Open Source")), new JButton(LocaleSupport.getString((String)"JFO_closeButton", (String)"Close"))};
            this.buttons[0].setEnabled(false);
            String mnemonic = LocaleSupport.getString((String)"JFO_openSourceButtonMnemonic", (String)"O");
            if (mnemonic != null && mnemonic.length() > 0) {
                this.buttons[0].setMnemonic(mnemonic.charAt(0));
            }
            if ((mnemonic = LocaleSupport.getString((String)"JFO_closeButtonMnemonic", (String)"C")) != null && mnemonic.length() > 0) {
                this.buttons[1].setMnemonic(mnemonic.charAt(0));
            }
            this.buttons[0].getAccessibleContext().setAccessibleDescription(LocaleSupport.getString((String)"ACSD_JFO_openSourceButton"));
            this.buttons[1].getAccessibleContext().setAccessibleDescription(LocaleSupport.getString((String)"ACSD_JFO_closeButton"));
        }
        return this.buttons;
    }

    protected Class getKitClass() {
        return null;
    }

    protected boolean isCaseSensitive() {
        Class kitClass = this.getKitClass();
        if (kitClass != null) {
            return SettingsUtil.getBoolean((Class)kitClass, (String)"goto-class-case-sensitive", (Boolean)JavaSettingsDefaults.defaultGotoClassCaseSensitive);
        }
        return JavaSettingsDefaults.defaultGotoClassCaseSensitive;
    }

    protected void setCaseSensitive(boolean caseSensitive) {
    }

    protected boolean isIncludeInnerClasses() {
        Class kitClass = this.getKitClass();
        if (kitClass != null) {
            return SettingsUtil.getBoolean((Class)kitClass, (String)"goto-class-show-inner-classes", (Boolean)JavaSettingsDefaults.defaultGotoClassShowInnerClasses);
        }
        return JavaSettingsDefaults.defaultGotoClassShowInnerClasses;
    }

    protected void setIncludeInnerClasses(boolean includeInnerClasses) {
    }

    protected boolean isIncludeLibraryClasses() {
        Class kitClass = this.getKitClass();
        if (kitClass != null) {
            return SettingsUtil.getBoolean((Class)kitClass, (String)"goto-class-show-library-classes", (Boolean)JavaSettingsDefaults.defaultGotoClassShowLibraryClasses);
        }
        return JavaSettingsDefaults.defaultGotoClassShowLibraryClasses;
    }

    protected void setIncludeLibraryClasses(boolean includeLibraryClasses) {
    }

    protected Dialog createDialog() {
        String title = LocaleSupport.getString((String)"JFO_title", (String)"Open Java Source");
        Dialog dialog = DialogSupport.createDialog((String)title, (JPanel)this.getPanel(), (boolean)false, (JButton[])this.getButtons(), (boolean)false, (int)0, (int)1, (ActionListener)this);
        if (dialog instanceof JDialog) {
            ((JDialog)dialog).getRootPane().setDefaultButton(null);
        }
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JavaFastOpen.this.setDialogVisible(false);
            }

            public void windowClosed(WindowEvent evt) {
            }
        });
        return dialog;
    }

    protected JavaFastOpenPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JavaFastOpenPanel(this);
        }
        return this.panel;
    }

    ListCellRenderer getCellRenderer() {
        if (this.cellRenderer == null) {
            this.cellRenderer = this.createCellRenderer();
        }
        return this.cellRenderer;
    }

    protected JList getResultList() {
        if (this.resultList == null) {
            this.resultList = this.createResultList();
        }
        return this.resultList;
    }

    private Evaluator getEvaluator() {
        if (this.evaluator == null) {
            this.evaluator = new Evaluator(0);
            RequestProcessor.getDefault().post((Runnable)this.evaluator);
        }
        return this.evaluator;
    }

    protected String getSearchText() {
        return this.getPanel().getSearchText();
    }

    public void setSearchText(String text) {
        this.getPanel().setSearchText(text);
        this.postUpdate();
    }

    protected void postUpdate() {
        SwingUtilities.invokeLater(new Evaluator(1));
    }

    protected abstract List findClasses(String var1, boolean var2, boolean var3, boolean var4);

    List evaluate(String exp, boolean caseSensitive, boolean includeInnerClasses, boolean includeLibraryClasses) {
        List ret = null;
        if (exp != null && exp.length() > 0) {
            timer.setInitialDelay(1000);
            timer.setDelay(1000);
            timer.start();
            ret = this.findClasses(exp, caseSensitive, includeInnerClasses, includeLibraryClasses);
            timer.stop();
            this.getPanel().setCursor(Cursor.getPredefinedCursor(0));
        }
        return ret;
    }

    void populate(List result) {
        if (result != null && this.getResultList() instanceof ListCompletionView) {
            SwingUtilities.invokeLater(new Evaluator(2, result));
        }
    }

    private String listActionFor(KeyEvent ev) {
        InputMap map = this.resultList.getInputMap();
        Object o = map.get(KeyStroke.getKeyStrokeForEvent(ev));
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    boolean boundScrollingKey(KeyEvent ev) {
        String action = this.listActionFor(ev);
        return "selectPreviousRow".equals(action) || "selectNextRow".equals(action) || "selectFirstRow".equals(action) || "selectLastRow".equals(action) || "scrollUp".equals(action) || "scrollDown".equals(action);
    }

    void delegateScrollingKey(KeyEvent ev) {
        String action = this.listActionFor(ev);
        Action a = this.resultList.getActionMap().get(action);
        if (a != null) {
            a.actionPerformed(new ActionEvent(this.resultList, 0, action));
        }
    }

    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.buttons[0] || src == this.panel) {
            this.setCaseSensitive(this.caseSensitive);
            this.setIncludeInnerClasses(this.includeInnerClasses);
            this.setIncludeLibraryClasses(this.includeLibraryClasses);
            this.getEvaluator().postOpen();
        } else if (src instanceof Timer) {
            this.getPanel().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.setDialogVisible(false);
        }
    }

    private void open() {
        SwingUtilities.invokeLater(new Evaluator(3));
    }

    static {
        fastOpen = null;
    }

    private class Evaluator
    implements Runnable {
        private int opID;
        private List result;
        private String exp;
        private String lastExp;
        private boolean open;
        private boolean exit;
        private boolean lastCaseSensitive;
        private boolean lastIncludeInnerClasses;
        private boolean lastIncludeLibraryClasses;

        Evaluator(int opID) {
            this(opID, null);
        }

        Evaluator(int opID, List result) {
            this.opID = opID;
            this.result = result;
        }

        synchronized void setExp(String exp) {
            this.exp = exp;
        }

        synchronized void postOpen() {
            this.open = true;
        }

        void breakLoop() {
            this.exit = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            switch (this.opID) {
                case 1: {
                    String text = JavaFastOpen.this.getPanel().getSearchText();
                    String lastText = ((JavaFastOpen)JavaFastOpen.this).getEvaluator().lastExp;
                    if (lastText == null && text.length() > 0) {
                        JavaFastOpen.this.getButtons()[0].setEnabled(true);
                    }
                    if ((lastText == null || lastText.length() == 0) && text.length() > 0) {
                        ((ListCompletionView)JavaFastOpen.this.getResultList()).displayWaitStatus();
                    }
                    JavaFastOpen.this.getEvaluator().setExp(text);
                    JavaFastOpen.this.caseSensitive = JavaFastOpen.this.getPanel().getCaseSensitive();
                    JavaFastOpen.this.includeInnerClasses = JavaFastOpen.this.getPanel().getIncludeInnerClasses();
                    JavaFastOpen.this.includeLibraryClasses = JavaFastOpen.this.getPanel().getIncludeLibraryClasses();
                    return;
                }
                case 2: {
                    ((ListCompletionView)JavaFastOpen.this.getResultList()).setResult(this.result);
                    JavaFastOpen.this.getResultList().setSelectedIndex(0);
                    JavaFastOpen.this.getButtons()[0].setEnabled(this.result.size() > 0);
                    if (JavaFastOpen.this.dialog instanceof JDialog) {
                        JDialog jd = (JDialog)JavaFastOpen.this.dialog;
                        jd.getRootPane().setDefaultButton(JavaFastOpen.this.getButtons()[0].isEnabled() ? JavaFastOpen.this.getButtons()[0] : null);
                    }
                    return;
                }
                case 3: {
                    int selIndex = JavaFastOpen.this.getResultList().getSelectedIndex();
                    if (selIndex >= 0) {
                        int index;
                        for (index = selIndex; index > 0 && JavaFastOpen.this.getResultList().getModel().getElementAt(selIndex).equals(JavaFastOpen.this.getResultList().getModel().getElementAt(index - 1)); --index) {
                        }
                        JavaFastOpen.this.openSource(JavaFastOpen.this.getResultList().getModel().getElementAt(selIndex), selIndex - index);
                        JavaFastOpen.this.setDialogVisible(false);
                    }
                    return;
                }
            }
            try {
                while (!this.exit) {
                    Object result;
                    if (this.exp != null && !this.exp.equals(this.lastExp) || JavaFastOpen.this.caseSensitive != this.lastCaseSensitive || JavaFastOpen.this.includeInnerClasses != this.lastIncludeInnerClasses || JavaFastOpen.this.includeLibraryClasses != this.lastIncludeLibraryClasses) {
                        this.lastExp = this.exp;
                        this.lastCaseSensitive = JavaFastOpen.this.caseSensitive;
                        this.lastIncludeInnerClasses = JavaFastOpen.this.includeInnerClasses;
                        this.lastIncludeLibraryClasses = JavaFastOpen.this.includeLibraryClasses;
                        if (this.lastExp != null) {
                            result = JavaFastOpen.this.evaluate(this.lastExp, this.lastCaseSensitive, this.lastIncludeInnerClasses, this.lastIncludeLibraryClasses);
                            if (this.lastExp.equals(this.exp)) {
                                JavaFastOpen.this.populate((List)result);
                            }
                        }
                    }
                    result = this;
                    synchronized (result) {
                        if (this.exp != null && this.exp.equals(this.lastExp) && this.open) {
                            JavaFastOpen.this.open();
                            this.open = false;
                        }
                    }
                    Thread.sleep(200L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

